/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.preferences.formfactors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import oracle.adfmf.framework.dt.preferences.formfactors.FormFactor;

public final class FormFactors {
    private List<FormFactor> m_formFactors = new ArrayList<FormFactor>();

    public FormFactors() {
    }

    public FormFactors(List<FormFactor> formFactors) {
        this.m_formFactors = formFactors;
        this._verifyDefaultFormFactorSet();
    }

    void add(FormFactor formFactor) {
        if (!this.m_formFactors.contains(formFactor)) {
            this.m_formFactors.add(formFactor);
        }
    }

    void addAll(Set<FormFactor> formFactors) {
        this.m_formFactors.removeAll(formFactors);
        this.m_formFactors.addAll(formFactors);
        this._verifyDefaultFormFactorSet();
    }

    void remove(FormFactor formFactor) {
        this.m_formFactors.remove(formFactor);
    }

    public void set(Collection<FormFactor> formFactors) {
        this.m_formFactors = new ArrayList<FormFactor>(formFactors);
        this._verifyDefaultFormFactorSet();
    }

    public Collection<FormFactor> getAll() {
        return Collections.unmodifiableCollection(this.m_formFactors);
    }

    FormFactor get(int index) {
        return this.m_formFactors.get(index);
    }

    int indexOf(FormFactor formFactor) {
        return this.m_formFactors.indexOf(formFactor);
    }

    int getSize() {
        return this.m_formFactors.size();
    }

    public List<FormFactor> getFormFactorList() {
        return this.m_formFactors;
    }

    public boolean isEmpty() {
        return this.m_formFactors.isEmpty();
    }

    private void _verifyDefaultFormFactorSet() {
        if (this.m_formFactors.isEmpty()) {
            return;
        }
        for (FormFactor formFactor : this.m_formFactors) {
            if (!formFactor.isDefault()) continue;
            return;
        }
        FormFactor firstFormFactor = this.m_formFactors.get(0);
        if (firstFormFactor != null) {
            firstFormFactor.setAsDefault();
        }
    }
}

