/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.preferences.formfactors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.adfmf.framework.dt.preferences.formfactors.DeviceProperty;
import oracle.adfmf.framework.dt.preferences.formfactors.FormFactorsConstants;
import oracle.javatools.util.Copyable;

public final class FormFactor
implements Copyable {
    private static final int DEFAULT_WIDTH = 320;
    private static final int DEFAULT_HEIGHT = 480;
    private final Map<String, String> m_propertiesMap = new HashMap<String, String>();
    private final List<DeviceProperty> m_moreProperties = new ArrayList<DeviceProperty>();

    public FormFactor() {
        this.setProperty("Default", false);
    }

    public String getProperty(String name) {
        return this.m_propertiesMap.get(name);
    }

    public void setProperty(String name, Object value) {
        if (value != null) {
            this.m_propertiesMap.put(name, value.toString());
        } else {
            this.m_propertiesMap.put(name, null);
        }
    }

    public void removeProperty(String name) {
        this.m_propertiesMap.remove(name);
    }

    public Map<String, String> getPropertyMap() {
        return this.m_propertiesMap;
    }

    public List<DeviceProperty> getMoreProperties() {
        return this.m_moreProperties;
    }

    public void addMoreProperty(DeviceProperty dp) {
        this.m_moreProperties.add(dp);
    }

    public Object copyTo(Object target) {
        if (target == null) {
            target = new FormFactor();
        } else assert (target instanceof FormFactor);
        ((FormFactor)target).m_propertiesMap.putAll(this.m_propertiesMap);
        for (DeviceProperty dp : this.m_moreProperties) {
            DeviceProperty newDp = (DeviceProperty)dp.copyTo(null);
            ((FormFactor)target).m_moreProperties.add(newDp);
        }
        return target;
    }

    public String toString() {
        return this.m_propertiesMap.get("Name");
    }

    public boolean isDefault() {
        String value = this.m_propertiesMap.get("Default");
        if ("true".equals(value)) {
            return true;
        }
        if (!"false".equals(value)) {
            this.setProperty("Default", false);
        }
        return false;
    }

    public void setAsDefault() {
        this.setProperty("Default", true);
    }

    public static FormFactor createDefaultFormFactor() {
        FormFactor formFactor = new FormFactor();
        formFactor.setProperty("Default", true);
        formFactor.setProperty("Default Orientation", FormFactorsConstants.Orientation.PORTRAIT.getOrientation());
        formFactor.setProperty("Resolution Width", 320);
        formFactor.setProperty("Resolution Height", 480);
        formFactor.setProperty("Scale Factor", 1);
        return formFactor;
    }

    public boolean isValid() {
        for (FormFactorsConstants.MasterTableColumns property : FormFactorsConstants.MasterTableColumns.values()) {
            if (property.isRequired() && !FormFactorsConstants.isValueSet(this.getProperty(property.getColumnName()))) {
                return false;
            }
            if (this._isValueValid(property.getColumnName())) continue;
            return false;
        }
        return true;
    }

    private boolean _isValueValid(String propertyName) {
        String value = this.getProperty(propertyName);
        if ("Scale Factor".equals(propertyName)) {
            return FormFactorsConstants.isScaleValid(value);
        }
        if ("Resolution Height".equals(propertyName) || "Resolution Width".equals(propertyName)) {
            return FormFactorsConstants.isResolutionValid(value);
        }
        return true;
    }
}

