/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.preferences;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.adfmf.common.ControlGroupPanel;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.preferences.AndroidPreferencesPanel;
import oracle.adfmf.framework.dt.preferences.IosPreferencesPanel;
import oracle.adfmf.framework.dt.preferences.PlatformPreferencesBase;
import oracle.ide.extension.RegisteredByExtension;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;

@RegisteredByExtension(value="oracle.adf.mobile")
final class PlatformSDKsPrefsPanel
extends DefaultTraversablePanel {
    private static final long serialVersionUID = 1L;
    private static final int PLATFORM_LIST_WIDTH = 180;
    private static final int PLATFORM_LIST_HEIGHT = 65;
    private static final String SDK_PREFERENCES_HELPTOPIC = "f1_adfmf_preferences_sdks_html";
    private JList m_platformList;
    private final List<PlatformPreferencesBase> m_platformOptionsPanelList = new ArrayList<PlatformPreferencesBase>();

    public PlatformSDKsPrefsPanel() {
        this.setLayout(new GridBagLayout());
        this.initializeComponent();
    }

    public void onEntry(TraversableContext context) {
        for (PlatformPreferencesBase currPlatform : this.m_platformOptionsPanelList) {
            currPlatform.onEntry(context);
        }
        this.m_platformList.setSelectedIndex(0);
    }

    public void onExit(TraversableContext context) throws TraversalException {
        int currPlatformUiIndex = 0;
        for (PlatformPreferencesBase currPlatform : this.m_platformOptionsPanelList) {
            try {
                currPlatform.onExit(context);
                ++currPlatformUiIndex;
            }
            catch (TraversalException te) {
                this.m_platformList.setSelectedIndex(currPlatformUiIndex);
                throw te;
            }
        }
    }

    public String getHelpID() {
        return SDK_PREFERENCES_HELPTOPIC;
    }

    private void initializeComponent() {
        boolean gridX = false;
        int gridY = 0;
        ControlGroupPanel containerPanel = new ControlGroupPanel();
        containerPanel.addPanel(this.createPlatformListPanel(), 0, gridY++);
        this.m_platformOptionsPanelList.add(new AndroidPreferencesPanel());
        this.m_platformOptionsPanelList.add(new IosPreferencesPanel());
        for (PlatformPreferencesBase currPlatform : this.m_platformOptionsPanelList) {
            currPlatform.setVisible(false);
            containerPanel.addPanel(currPlatform, 0, gridY);
        }
        boolean containerGridX = false;
        int containerGridY = 0;
        int HORIZONTAL_INDENT_SDK_PANEL = 6;
        this.add((Component)((Object)containerPanel), this.gbc(0, containerGridY++, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 6, 0, 0)));
        this.add(Box.createGlue(), this.gbc(0, containerGridY, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0)));
    }

    private ControlGroupPanel createPlatformListPanel() {
        boolean gridX = false;
        boolean gridY = false;
        String[] listElementArray = new String[]{MobileResourceUtils.getText("ANDROID_LABEL"), MobileResourceUtils.getText("IOS_LABEL")};
        ControlGroupPanel supportedPlatformPanel = new ControlGroupPanel();
        supportedPlatformPanel.setWeightX(1.0);
        supportedPlatformPanel.setBottomIndentPixelSize(3);
        this.m_platformList = supportedPlatformPanel.addLabeledJList(0, 0, 1, MobileResourceUtils.getText("SUPPORTED_PLATFORMS_LABEL"), listElementArray, 180, 65, Color.BLACK, 0);
        this.m_platformList.addListSelectionListener(new PlatformSelectionListener());
        return supportedPlatformPanel;
    }

    private class PlatformSelectionListener
    implements ListSelectionListener {
        private PlatformSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            boolean adjust = listSelectionEvent.getValueIsAdjusting();
            if (!adjust) {
                JList list = (JList)listSelectionEvent.getSource();
                int selectedPlatformUiIndex = list.getSelectedIndex();
                int currPlatformIndex = 0;
                for (PlatformPreferencesBase currPlatform : PlatformSDKsPrefsPanel.this.m_platformOptionsPanelList) {
                    currPlatform.setVisible(currPlatformIndex == selectedPlatformUiIndex);
                    ++currPlatformIndex;
                }
            }
        }
    }
}

