/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.preferences;

import oracle.adfmf.common.util.PreferenceUtils;
import oracle.ide.extension.RegisteredByExtension;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;

@RegisteredByExtension(value="oracle.adf.mobile")
public final class PlatformSDKsPrefs
extends HashStructureAdapter {
    public static final String DATA_KEY = "oracle.adfmf.framework.dt.preferences.PlatformSDKsPrefs";
    private static final String KEY_ANDROID_SDK_DIR = "androidSdkDir";
    private static final String KEY_ANDROID_PLATFORM_DIR = "androidPlatformDir";
    private static final String KEY_ANDROID_BUILD_TOOLS_DIR = "androidBuildToolsDir";
    private static final String KEY_IOS_XCODEBUILD_DIR = "iOSxcodebuildDir";
    private static final String KEY_IOS_SDK_DIR = "iOSSdkDir";
    private static final String KEY_IOS_AUTOMATICALLY_ADD_TO_ITUNES_DIR = "iOSiTunesDir";
    private static final String KEY_IOS_CERTIFICATE = "iosCertificate";
    private static final String KEY_IOS_PROVISIONING_PROFILE = "iosProvisioningProfile";
    private static final String KEY_ANDROID_RELEASE_SIGNING_KEYSTORE_PATH = "androidReleaseSigningKeystorePath";
    private static final String KEY_ANDROID_RELEASE_SIGNING_KEY_PASSWORD = "androidReleaseSigningKeyPassword";
    private static final String KEY_ANDROID_RELEASE_SIGNING_KEYSTORE_PASSWORD = "androidReleaseSigningKeystorePassword";
    private static final String KEY_ANDROID_RELEASE_SIGNING_KEY_ALIAS = "androidReleaseSigningKeyAlias";
    private static final String KEY_ANDROID_DEBUG_SIGNING_PASSWORD = "androidDebugSigningPassword";

    private PlatformSDKsPrefs(HashStructure hash) {
        super(hash);
    }

    public static PlatformSDKsPrefs getInstance(PropertyStorage storage) {
        return new PlatformSDKsPrefs(PlatformSDKsPrefs.findOrCreate((PropertyStorage)storage, (String)DATA_KEY));
    }

    public String getAndroidSdkDir() {
        return null != this._hash.getString(KEY_ANDROID_SDK_DIR) ? this._hash.getString(KEY_ANDROID_SDK_DIR) : PreferenceUtils.getAndroidDefaultSdkPath();
    }

    public void setAndroidSdkDir(String sdkDir) {
        this._hash.putString(KEY_ANDROID_SDK_DIR, sdkDir);
    }

    public String getAndroidPlatformDir() {
        return null != this._hash.getString(KEY_ANDROID_PLATFORM_DIR) ? this._hash.getString(KEY_ANDROID_PLATFORM_DIR) : PreferenceUtils.getAndroidDefaulPlatformPath();
    }

    public void setAndroidPlatformDir(String platformDir) {
        this._hash.putString(KEY_ANDROID_PLATFORM_DIR, platformDir);
    }

    public String getAndroidBuildToolsDir() {
        String storedBuildToolsDir = this._hash.getString(KEY_ANDROID_BUILD_TOOLS_DIR);
        return PreferenceUtils.getCorrectedAndroidBuildToolsDir(storedBuildToolsDir);
    }

    public void setAndroidBuildToolsDir(String buildToolsDir) {
        this._hash.putString(KEY_ANDROID_BUILD_TOOLS_DIR, buildToolsDir);
    }

    public String getiOSxcodebuildDir() {
        return null != this._hash.getString(KEY_IOS_XCODEBUILD_DIR) ? this._hash.getString(KEY_IOS_XCODEBUILD_DIR) : PreferenceUtils.getIosXcodebuildDir();
    }

    public void setiOSxcodebuildDir(String ideDir) {
        this._hash.putString(KEY_IOS_XCODEBUILD_DIR, ideDir);
    }

    public String getiOSSdkDir() {
        return null != this._hash.getString(KEY_IOS_SDK_DIR) ? this._hash.getString(KEY_IOS_SDK_DIR) : PreferenceUtils.getIosSdkDir();
    }

    public void setiOSSdkDir(String sdkDir) {
        this._hash.putString(KEY_IOS_SDK_DIR, sdkDir);
    }

    public String getiOSAutomaticallyAddToiTunesDir() {
        String iTunesDirHashVal = this._hash.getString(KEY_IOS_AUTOMATICALLY_ADD_TO_ITUNES_DIR);
        String iTunesDir = null != iTunesDirHashVal && !iTunesDirHashVal.isEmpty() ? iTunesDirHashVal : "";
        return iTunesDir;
    }

    public void setiOSAutomaticallyAddToiTunesDir(String sdkDir) {
        this._hash.putString(KEY_IOS_AUTOMATICALLY_ADD_TO_ITUNES_DIR, sdkDir);
    }

    public String getiOSProvisioningProfile() {
        return this._hash.getString(KEY_IOS_PROVISIONING_PROFILE, "");
    }

    public void setiOSProvisioningProfile(String provisioningProfilePath) {
        this._hash.putString(KEY_IOS_PROVISIONING_PROFILE, provisioningProfilePath);
    }

    public String getiOSCertificate() {
        return this._hash.getString(KEY_IOS_CERTIFICATE, "");
    }

    public void setiOSCertificate(String iosCertificate) {
        this._hash.putString(KEY_IOS_CERTIFICATE, iosCertificate);
    }

    public String getAndroidReleaseSigningKeystorePath() {
        return this._hash.getString(KEY_ANDROID_RELEASE_SIGNING_KEYSTORE_PATH, "");
    }

    public void setAndroidReleaseSigningKeystorePath(String keyStorePath) {
        this._hash.putString(KEY_ANDROID_RELEASE_SIGNING_KEYSTORE_PATH, keyStorePath);
    }

    public char[] getAndroidReleaseSigningKeyPassword() {
        return this._hash.getString(KEY_ANDROID_RELEASE_SIGNING_KEY_PASSWORD, "").toCharArray();
    }

    public void setAndroidReleaseSigningKeyPassword(char[] encryptedKeyPassword) {
        this._hash.putString(KEY_ANDROID_RELEASE_SIGNING_KEY_PASSWORD, String.valueOf(encryptedKeyPassword));
    }

    public char[] getAndroidReleaseSigningKeystorePassword() {
        return this._hash.getString(KEY_ANDROID_RELEASE_SIGNING_KEYSTORE_PASSWORD, "").toCharArray();
    }

    public void setAndroidReleaseSigningKeystorePassword(char[] encryptedKeyStorePassword) {
        this._hash.putString(KEY_ANDROID_RELEASE_SIGNING_KEYSTORE_PASSWORD, String.valueOf(encryptedKeyStorePassword));
    }

    public String getAndroidReleaseSigningKeyAlias() {
        return this._hash.getString(KEY_ANDROID_RELEASE_SIGNING_KEY_ALIAS, "");
    }

    public void setAndroidReleaseSigningKeyAlias(String keyAlias) {
        this._hash.putString(KEY_ANDROID_RELEASE_SIGNING_KEY_ALIAS, keyAlias);
    }

    public char[] getAndroidDebugSigningPassword() {
        char[] returnValue = null;
        String value = this._hash.getString(KEY_ANDROID_DEBUG_SIGNING_PASSWORD);
        if (null != value) {
            returnValue = value.toCharArray();
        }
        return returnValue;
    }

    public char[] getAndroidDefaultDebugSigningPassword() {
        String KEY_SEED_VALUE = "android";
        return "android".toCharArray();
    }

    public void setAndroidDebugSigningPassword(char[] encryptedDebugSigningPassword) {
        this._hash.putString(KEY_ANDROID_DEBUG_SIGNING_PASSWORD, String.valueOf(encryptedDebugSigningPassword));
    }
}

