/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.preferences;

import java.awt.Component;
import java.net.URL;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import oracle.adfmf.common.util.FileUtils;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.common.util.PreferenceUtils;
import oracle.adfmf.framework.dt.deploy.DeployFileUtils;
import oracle.adfmf.framework.dt.deploy.common.ui.BrowserPanel;
import oracle.adfmf.framework.dt.deploy.common.ui.IosSigningOptions;
import oracle.adfmf.framework.dt.deploy.common.ui.IosSigningPanel;
import oracle.adfmf.framework.dt.deploy.ios.core.IosDeployUtil;
import oracle.adfmf.framework.dt.preferences.PlatformPreferencesBase;
import oracle.adfmf.framework.dt.preferences.PlatformSDKsPrefs;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.PlatformUtils;

public class IosPreferencesPanel
extends PlatformPreferencesBase {
    private IosSigningPanel _iosSigningPanel;
    private static final long serialVersionUID = 1L;
    private static final String LOGGER_BASE_CLASS = "oracle.adfmf.framework.dt";
    private BrowserPanel _iOSSdkDirControl;
    private final URLChooser _iOSSdkPathChooser = DialogUtil.newURLChooser();
    private BrowserPanel _iOSxcodeBuildDirControl;
    private BrowserPanel _iOSiTunesDirControl;

    public IosPreferencesPanel() {
        this._initializeComponent();
    }

    public void onEntry(TraversableContext context) {
        PlatformSDKsPrefs data = this.getPlatformSDKsPrefs(context);
        String iOSxcodebuildDir = data.getiOSxcodebuildDir();
        this.setInitialSdkPath(iOSxcodebuildDir, this._iOSxcodeBuildDirControl);
        String iOSSdkDir = data.getiOSSdkDir();
        this.setInitialSdkPath(iOSSdkDir, this._iOSSdkDirControl);
        String automaticallyAddToItunesDir = data.getiOSAutomaticallyAddToiTunesDir();
        this.setInitialSdkPath(automaticallyAddToItunesDir, this._iOSiTunesDirControl);
        this._iosSigningPanel.onEntry(new IosSigningOptions(data));
    }

    public void onExit(TraversableContext context) throws TraversalException {
        if (!PlatformUtils.isMac()) {
            return;
        }
        PlatformSDKsPrefs data = this.getPlatformSDKsPrefs(context);
        String sdkDir = DeployFileUtils.getTrimmedStringValue(this._iOSSdkDirControl.getText());
        if (ModelUtil.hasLength((String)sdkDir)) {
            this._validateSdkPath(sdkDir);
            this._validateSdkVersion(sdkDir);
        }
        data.setiOSSdkDir(sdkDir);
        String xcodebuildDir = DeployFileUtils.getTrimmedStringValue(this._iOSxcodeBuildDirControl.getText());
        if (ModelUtil.hasLength((String)xcodebuildDir)) {
            this._validateXcodeBuildDirectory(xcodebuildDir);
        }
        data.setiOSxcodebuildDir(xcodebuildDir);
        String automaticallyAddToItunesDir = DeployFileUtils.getTrimmedStringValue(this._iOSiTunesDirControl.getText());
        if (ModelUtil.hasLength((String)automaticallyAddToItunesDir)) {
            this._validateAddToItunesDirectory(automaticallyAddToItunesDir);
        }
        data.setiOSAutomaticallyAddToiTunesDir(automaticallyAddToItunesDir);
        IosSigningOptions iosSigningOptions = this._iosSigningPanel.onExit();
        data.setiOSProvisioningProfile(iosSigningOptions.getProvisioningProfileFilePath());
        data.setiOSCertificate(iosSigningOptions.getCertificate());
        try {
            URL xcodebuildDirUrl = URLFactory.newDirURL((String)IosDeployUtil.getXcodebuildPath());
            Logger logger = Logger.getLogger(LOGGER_BASE_CLASS);
            IosDeployUtil.throwExceptionOnInvalidXcodeVersion(logger, xcodebuildDirUrl);
        }
        catch (Exception e) {
            throw new TraversalException((Object)e);
        }
    }

    private void _initializeComponent() {
        this._initializeIosSdkPathChooser();
        boolean gridX = false;
        int gridY = 0;
        boolean SDK_PATH_CONTROL_LEFT_INDENT = false;
        String iOSSdkDirHint = PreferenceUtils.getIosSdkDirExample();
        String xcodeBuildDirHint = PreferenceUtils.getIosXcodebuildDirExample();
        this._iOSSdkDirControl = new BrowserPanel((Component)((Object)this), this._iOSSdkPathChooser, MobileResourceUtils.getText("IOS_SDK_DIR_LABEL"), iOSSdkDirHint, true, 0);
        this._iOSSdkDirControl.setToolTipText(iOSSdkDirHint);
        this.addPanel(this._iOSSdkDirControl, 0, gridY++);
        this._iOSxcodeBuildDirControl = new BrowserPanel((Component)((Object)this), this._iOSSdkPathChooser, MobileResourceUtils.getText("IOS_XCODEBUILD_DIR_LABEL"), xcodeBuildDirHint, true, 0);
        this._iOSxcodeBuildDirControl.setToolTipText(xcodeBuildDirHint);
        this.addPanel(this._iOSxcodeBuildDirControl, 0, gridY++);
        String iTunesDirExample = PreferenceUtils.getUserIosItunesDirExample();
        this._iOSiTunesDirControl = new BrowserPanel((Component)((Object)this), this._iOSSdkPathChooser, MobileResourceUtils.getText("IOS_ITUNES_DIR_LABEL"), iTunesDirExample, true, 0);
        this._iOSiTunesDirControl.setToolTipText(iTunesDirExample);
        this._iosSigningPanel = new IosSigningPanel();
        this.addPanel(this._iOSiTunesDirControl, 0, gridY++);
        this.addPanel(this._iosSigningPanel, 0, gridY++);
        this.addGlue(0, gridY);
    }

    private void _initializeIosSdkPathChooser() {
        this._iOSSdkPathChooser.setSelectionScope(1);
        this._iOSSdkPathChooser.setSelectionMode(0);
        this._iOSSdkPathChooser.setShowJarsAsDirs(false);
        DialogUtil.initURLChooser((URLChooser)this._iOSSdkPathChooser, null);
    }

    private void _validateSdkPath(String sdkDir) throws TraversalException {
        if (!FileUtils.isiOSSdkDirValid(sdkDir)) {
            String confirmSdkDirMsg = MobileResourceUtils.getMsg("ADF-MBL-10000", FileUtils.getIOSExePath(sdkDir), "6.0");
            String sdkDirMsgBoxTitle = MobileResourceUtils.getText("INVALID_IOS_SDK_DIR_TITLE");
            this._showConfirmationDialog(confirmSdkDirMsg, sdkDirMsgBoxTitle);
        }
    }

    private void _validateSdkVersion(String sdkDir) throws TraversalException {
        if (!FileUtils.isiOSSdkVersionValid(sdkDir)) {
            String confirmSdkVersionMsg = MobileResourceUtils.getMsg("ADF-MBL-10017", "6.0");
            String sdkVersionMsgBoxTitle = MobileResourceUtils.getText("INVALID_IOS_SDK_DIR_TITLE");
            this._showConfirmationDialog(confirmSdkVersionMsg, sdkVersionMsgBoxTitle);
        }
    }

    private void _validateXcodeBuildDirectory(String xcodebuildDir) throws TraversalException {
        if (!FileUtils.isiOSxcodebuildDirValid(xcodebuildDir)) {
            String confirmXcodebuildDirMsg = MobileResourceUtils.getMsg("ADF-MBL-10010", FileUtils.getIOSExePath(xcodebuildDir));
            String xcodebuildDirMsgBoxTitle = MobileResourceUtils.getText("INVALID_XCODEBUILD_DIR_TITLE");
            this._showConfirmationDialog(confirmXcodebuildDirMsg, xcodebuildDirMsgBoxTitle);
        }
    }

    private void _validateAddToItunesDirectory(String automaticallyAddToItunesDir) throws TraversalException {
        if (!FileUtils.isiOSiTunesDirValid(automaticallyAddToItunesDir)) {
            String confirmITunesdDirMsg = MobileResourceUtils.getMsg("ADF-MBL-11000", automaticallyAddToItunesDir);
            String iTunesDirMsgBoxTitle = MobileResourceUtils.getText("INVALID_AUTOMATICALLY_ADD_TO_ITUNES_DIR_TITLE");
            this._showConfirmationDialog(confirmITunesdDirMsg, iTunesDirMsgBoxTitle);
        }
    }

    private void _showConfirmationDialog(String msg, String msgBoxTitle) throws TraversalException {
        int rtn = JOptionPane.showConfirmDialog((Component)((Object)this), msg, msgBoxTitle, 0);
        if (rtn != 0) {
            throw new TraversalException(null);
        }
    }
}

