/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.preferences;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JOptionPane;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.preferences.FormFactorsPrefs;
import oracle.adfmf.framework.dt.preferences.formfactors.FormFactor;
import oracle.adfmf.framework.dt.preferences.formfactors.FormFactors;
import oracle.adfmf.framework.dt.preferences.formfactors.FormFactorsMasterPanel;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;

public final class FormFactorsPrefsPanel
extends DefaultTraversablePanel {
    private static final String FORMFACTOR_HELPTOPIC = "f1_adfmf_preferences_formfactors_html";
    FormFactorsMasterPanel m_masterPanel = null;

    public FormFactorsPrefsPanel() {
        this.initializeComponent();
    }

    public void onEntry(TraversableContext dataContext) {
        FormFactorsPrefs options = FormFactorsPrefs.getInstance(dataContext.getPropertyStorage());
        FormFactors formFactors = options.loadFormFactors();
        if (formFactors == null) {
            formFactors = options.loadDefaultFormFactors();
        }
        this.m_masterPanel.setFormFactors(formFactors);
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        this.m_masterPanel.stopEditingAndSave();
        FormFactors formFactors = this.m_masterPanel.getFormFactors();
        this.validateRequiredFields(formFactors);
        FormFactorsPrefs options = FormFactorsPrefs.getInstance(dataContext.getPropertyStorage());
        options.saveFormFactors(formFactors);
    }

    public String getHelpID() {
        return FORMFACTOR_HELPTOPIC;
    }

    private void initializeComponent() {
        this.setLayout(new BorderLayout(4, 4));
        this.m_masterPanel = new FormFactorsMasterPanel(null);
        this.add(this.m_masterPanel, "Center");
    }

    private void validateRequiredFields(FormFactors formFactors) throws TraversalException {
        List<FormFactor> formFactorList = formFactors.getFormFactorList();
        for (FormFactor formFactor : formFactorList) {
            if (formFactor.isValid()) continue;
            JOptionPane.showConfirmDialog((Component)((Object)this), MobileResourceUtils.getText("MISSING_FORM_FACTOR_FIELD"), MobileResourceUtils.getText("INCOMPLETE_FORM_FACTOR"), -1, 0);
            throw new TraversalException(null);
        }
    }
}

