/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.preferences;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.adfmf.framework.dt.preferences.formfactors.FormFactor;
import oracle.adfmf.framework.dt.preferences.formfactors.FormFactors;
import oracle.adfmf.framework.dt.preferences.formfactors.FormFactorsConstants;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.data.StructureChangeListener;

public final class FormFactorsPrefs
extends HashStructureAdapter {
    private static final String DATA_KEY = "oracle.adfmf.framework.dt.preferences.FormFactorsPrefs";
    private static final String LIST_KEY = "formFactorList";
    private static final List<FormFactor> s_defaultFormFactors = FormFactorsPrefs.initDefaultFormFactors();

    private static List<FormFactor> initDefaultFormFactors() {
        ArrayList<FormFactor> ffList = new ArrayList<FormFactor>();
        for (String[] formFactorPropertyValues : FormFactorsConstants.getDefaultFormFactors()) {
            ffList.add(FormFactorsPrefs.createFormFactor(formFactorPropertyValues[0], formFactorPropertyValues[1], formFactorPropertyValues[2], formFactorPropertyValues[3], formFactorPropertyValues[4], formFactorPropertyValues[5], formFactorPropertyValues[6], formFactorPropertyValues[7]));
        }
        return ffList;
    }

    private static FormFactor createFormFactor(String isDefault, String name, String platform, String model, String orientation, String resolutionWidth, String resolutionHeight, String scaleFactor) {
        FormFactor formFactor = new FormFactor();
        formFactor.setProperty("Default", isDefault);
        formFactor.setProperty("Name", name);
        formFactor.setProperty("Platform", platform);
        formFactor.setProperty("Model", model);
        formFactor.setProperty("Default Orientation", orientation);
        formFactor.setProperty("Resolution Width", resolutionWidth);
        formFactor.setProperty("Resolution Height", resolutionHeight);
        formFactor.setProperty("Scale Factor", scaleFactor);
        return formFactor;
    }

    private FormFactorsPrefs(HashStructure hashStructure) {
        super(hashStructure);
    }

    public static FormFactorsPrefs getInstance(PropertyStorage storage) {
        return new FormFactorsPrefs(FormFactorsPrefs.findOrCreate((PropertyStorage)storage, (String)DATA_KEY));
    }

    public static List<FormFactor> getDefaultFormFactors() {
        ArrayList<FormFactor> ffList = new ArrayList<FormFactor>();
        for (FormFactor formFactor : s_defaultFormFactors) {
            FormFactor newff = (FormFactor)formFactor.copyTo(null);
            ffList.add(newff);
        }
        return ffList;
    }

    public void saveFormFactors(FormFactors formFactors) {
        List<FormFactor> formFactorList = formFactors.getFormFactorList();
        ListStructure ls = this.convertListToListStructure(formFactorList);
        this._hash.putListStructure(LIST_KEY, ls);
    }

    public FormFactors loadFormFactors() {
        ListStructure ls = this._hash.getListStructure(LIST_KEY);
        if (ls == null) {
            return null;
        }
        List<FormFactor> formFactorList = this.convertListStructureToList(ls);
        return new FormFactors(formFactorList);
    }

    public FormFactors loadDefaultFormFactors() {
        FormFactors formFactors = new FormFactors();
        formFactors.set(s_defaultFormFactors);
        return formFactors;
    }

    public void addStructureChangeListener(StructureChangeListener listener) {
        this._hash.addStructureChangeListener(listener);
    }

    public void removeStructureChangeListener(StructureChangeListener listener) {
        this._hash.removeStructureChangeListener(listener);
    }

    private ListStructure convertListToListStructure(List<FormFactor> formFactorList) {
        ListStructure ls = ListStructure.newInstance();
        for (FormFactor formFactor : formFactorList) {
            HashStructure blockHash = HashStructure.newInstance();
            Map<String, String> propertyMap = formFactor.getPropertyMap();
            for (Map.Entry<String, String> entry : propertyMap.entrySet()) {
                if (entry.getKey() == null) continue;
                blockHash.putString(entry.getKey(), entry.getValue());
            }
            ls.add((Object)blockHash);
        }
        return ls;
    }

    private List<FormFactor> convertListStructureToList(ListStructure ls) {
        ArrayList<FormFactor> formFactorList = new ArrayList<FormFactor>();
        for (Object hash : ls) {
            HashStructure blockHash = (HashStructure)hash;
            FormFactor formFactor = new FormFactor();
            Set keys = blockHash.keySet();
            for (String key : keys) {
                formFactor.setProperty(key, blockHash.getString(key));
            }
            formFactorList.add(formFactor);
        }
        return formFactorList;
    }
}

