/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.preferences;

import java.awt.Component;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import oracle.adfmf.common.ControlGroupPanel;
import oracle.adfmf.common.util.FileUtils;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.common.util.PreferenceUtils;
import oracle.adfmf.framework.dt.deploy.DeployFileUtils;
import oracle.adfmf.framework.dt.deploy.common.ui.AndroidSigningOptions;
import oracle.adfmf.framework.dt.deploy.common.ui.AndroidSigningPanel;
import oracle.adfmf.framework.dt.deploy.common.ui.BrowserPanel;
import oracle.adfmf.framework.dt.deploy.common.util.EncryptionUtils;
import oracle.adfmf.framework.dt.preferences.PlatformPreferencesBase;
import oracle.adfmf.framework.dt.preferences.PlatformSDKsPrefs;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.util.ModelUtil;

public class AndroidPreferencesPanel
extends PlatformPreferencesBase {
    private static final long serialVersionUID = 1L;
    private BrowserPanel _androidSdkDirControl;
    private BrowserPanel _androidSdkPlatformDirControl;
    private BrowserPanel _androidSdkBuildToolsDirControl;
    private final URLChooser _androidChooser = DialogUtil.newURLChooser();
    private AndroidSigningPanel _androidSigningPanel;
    private final transient Logger _logger = Logger.getLogger(AndroidPreferencesPanel.class.getName());

    public AndroidPreferencesPanel() {
        this._initializeComponent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEntry(TraversableContext context) {
        AndroidSigningOptions androidSigningOptions = null;
        char[] releaseSigningKeystorePassword = null;
        char[] releaseSigningKeyPassword = null;
        char[] debugSigningPassword = null;
        PlatformSDKsPrefs data = this.getPlatformSDKsPrefs(context);
        String androidSdkDir = data.getAndroidSdkDir();
        this.setInitialSdkPath(androidSdkDir, this._androidSdkDirControl);
        String androidPlatformDir = data.getAndroidPlatformDir();
        this.setInitialSdkPath(androidPlatformDir, this._androidSdkPlatformDirControl);
        String androidBuildToolsDir = data.getAndroidBuildToolsDir();
        if (FileUtils.areBuildToolsInPlatformToolsForSdk(androidSdkDir)) {
            this._androidSdkBuildToolsDirControl.getTextField().setEnabled(false);
        } else {
            this._androidSdkBuildToolsDirControl.getTextField().setEnabled(true);
        }
        this.setInitialSdkPath(androidBuildToolsDir, this._androidSdkBuildToolsDirControl);
        releaseSigningKeystorePassword = data.getAndroidReleaseSigningKeystorePassword();
        releaseSigningKeyPassword = data.getAndroidReleaseSigningKeyPassword();
        debugSigningPassword = data.getAndroidDebugSigningPassword();
        androidSigningOptions = new AndroidSigningOptions(data.getAndroidReleaseSigningKeystorePath(), data.getAndroidReleaseSigningKeyAlias(), releaseSigningKeystorePassword, releaseSigningKeyPassword, debugSigningPassword);
        try {
            this._androidSigningPanel.onEntry(androidSigningOptions);
        }
        catch (TraversalException e) {
            this._logger.warning(MobileResourceUtils.getMsg("ADF-MBL-11502", new Object[]{e}));
        }
        finally {
            if (null != androidSigningOptions) {
                androidSigningOptions.invalidate();
            }
            EncryptionUtils.zeroCharBuffer(releaseSigningKeystorePassword);
            EncryptionUtils.zeroCharBuffer(releaseSigningKeyPassword);
            EncryptionUtils.zeroCharBuffer(debugSigningPassword);
        }
    }

    public void onExit(TraversableContext context) throws TraversalException {
        PlatformSDKsPrefs platformSdkPrefs = this.getPlatformSDKsPrefs(context);
        this._saveAndroidSdkDir(platformSdkPrefs);
        this._saveAndroidPlatformSdkDir(platformSdkPrefs);
        this._saveAndroidBuildToolsSdkDir(platformSdkPrefs);
        this._saveAndroidPasswords(platformSdkPrefs);
    }

    private void _initializeComponent() {
        this._initializeAndroidUrlChooser();
        String sdkExamplePath = PreferenceUtils.getAndroidSdkPathExample();
        String sdkPlatformExamplePath = PreferenceUtils.getAndroidPlatformPathExample();
        String sdkBuildToolsExamplePath = PreferenceUtils.getAndroidBuildToolsPathExample();
        ControlGroupPanel sdkPathsPanel = new ControlGroupPanel();
        boolean SDK_PATH_CONTROL_LEFT_INDENT = false;
        boolean ALIGN_VERTICALLY = true;
        this._androidSdkDirControl = new BrowserPanel((Component)((Object)this), this._androidChooser, MobileResourceUtils.getText("ANDROID_SDK_LOCATION_LABEL"), sdkExamplePath, true, 0);
        this._androidSdkDirControl.setToolTipText(sdkExamplePath);
        boolean gridX = false;
        int gridY = 0;
        sdkPathsPanel.addPanel(this._androidSdkDirControl, 0, gridY++);
        this._androidSdkPlatformDirControl = new BrowserPanel((Component)((Object)this), this._androidChooser, MobileResourceUtils.getText("ANDROID_PLATFORM_LOCATION_LABEL"), sdkPlatformExamplePath, true, 0);
        this._androidSdkPlatformDirControl.setToolTipText(sdkPlatformExamplePath);
        sdkPathsPanel.addPanel(this._androidSdkPlatformDirControl, 0, gridY++);
        this._androidSdkBuildToolsDirControl = new BrowserPanel((Component)((Object)this), this._androidChooser, MobileResourceUtils.getText("ANDROID_BUILD_TOOLS_LOCATION_LABEL"), sdkBuildToolsExamplePath, true, 0);
        this._androidSdkBuildToolsDirControl.setToolTipText(sdkBuildToolsExamplePath);
        sdkPathsPanel.addPanel(this._androidSdkBuildToolsDirControl, 0, gridY++);
        this._androidSigningPanel = new AndroidSigningPanel();
        gridY = 0;
        this.addPanel(sdkPathsPanel, 0, gridY++);
        this.addPanel(this._androidSigningPanel, 0, gridY++);
        this.addGlue(0, gridY);
    }

    private void _initializeAndroidUrlChooser() {
        this._androidChooser.setSelectionScope(1);
        this._androidChooser.setSelectionMode(0);
        this._androidChooser.setShowJarsAsDirs(false);
        DialogUtil.initURLChooser((URLChooser)this._androidChooser, null);
    }

    private void _saveAndroidSdkDir(PlatformSDKsPrefs platformSDKsPrefs) throws TraversalException {
        String androidSdkDirMsgBoxTitle;
        String confirmAndroidSdkDirMsg;
        int rtnAcceptInvalidAndroidSdkDir;
        String androidSdkDir = DeployFileUtils.getTrimmedStringValue(this._androidSdkDirControl.getText());
        if (ModelUtil.hasLength((String)androidSdkDir) && !FileUtils.isAndroidSdkDirValid(androidSdkDir) && (rtnAcceptInvalidAndroidSdkDir = JOptionPane.showConfirmDialog((Component)((Object)this), confirmAndroidSdkDirMsg = MobileResourceUtils.getMsg("ADF-MBL-10006", androidSdkDir), androidSdkDirMsgBoxTitle = MobileResourceUtils.getText("INVALID_ANDROID_SDK_DIR_TITLE"), 0)) != 0) {
            throw new TraversalException(null);
        }
        platformSDKsPrefs.setAndroidSdkDir(androidSdkDir);
    }

    private void _saveAndroidPlatformSdkDir(PlatformSDKsPrefs platformSDKsPrefs) throws TraversalException {
        String androidPlatformDirMsgBoxTitle;
        String confirmAndroidPlatformDirMsg;
        int rtnAcceptInvalidAndroidPlatformDir;
        String androidPlatformDir = DeployFileUtils.getTrimmedStringValue(this._androidSdkPlatformDirControl.getText());
        if (ModelUtil.hasLength((String)androidPlatformDir) && !FileUtils.isAndroidPlatformDirValid(androidPlatformDir) && (rtnAcceptInvalidAndroidPlatformDir = JOptionPane.showConfirmDialog((Component)((Object)this), confirmAndroidPlatformDirMsg = MobileResourceUtils.getMsg("ADF-MBL-10007", androidPlatformDir, "9"), androidPlatformDirMsgBoxTitle = MobileResourceUtils.getText("INVALID_ANDROID_PLATFORM_DIR_TITLE"), 0)) != 0) {
            throw new TraversalException(null);
        }
        platformSDKsPrefs.setAndroidPlatformDir(androidPlatformDir);
    }

    private void _saveAndroidBuildToolsSdkDir(PlatformSDKsPrefs platformSDKsPrefs) throws TraversalException {
        String androidBuildToolsDirMsgBoxTitle;
        String confirmAndroidBuildToolsDirMsg;
        int rtnAcceptInvalidAndroidBuildToolsDir;
        String androidBuildToolsDir = DeployFileUtils.getTrimmedStringValue(this._androidSdkBuildToolsDirControl.getText());
        if (ModelUtil.hasLength((String)androidBuildToolsDir) && !FileUtils.isAndroidBuildToolsDirValid(androidBuildToolsDir) && (rtnAcceptInvalidAndroidBuildToolsDir = JOptionPane.showConfirmDialog((Component)((Object)this), confirmAndroidBuildToolsDirMsg = MobileResourceUtils.getMsg("ADF-MBL-10018", androidBuildToolsDir, "9"), androidBuildToolsDirMsgBoxTitle = MobileResourceUtils.getText("INVALID_ANDROID_BUILD_TOOLS_DIR_TITLE"), 0)) != 0) {
            throw new TraversalException(null);
        }
        platformSDKsPrefs.setAndroidBuildToolsDir(androidBuildToolsDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _saveAndroidPasswords(PlatformSDKsPrefs platformSDKsPrefs) throws TraversalException {
        AndroidSigningOptions androidSigningOptions = null;
        char[] releaseSigningKey = null;
        char[] releaseSigningKeystorePassword = null;
        char[] debugSigningPassword = null;
        try {
            androidSigningOptions = this._androidSigningPanel.onExit();
            platformSDKsPrefs.setAndroidReleaseSigningKeystorePath(androidSigningOptions.getReleaseSigningKeystorePath());
            platformSDKsPrefs.setAndroidReleaseSigningKeyAlias(androidSigningOptions.getReleaseSigningKeyAlias());
            releaseSigningKey = androidSigningOptions.getReleaseSigningKeyPassword();
            platformSDKsPrefs.setAndroidReleaseSigningKeyPassword(releaseSigningKey);
            releaseSigningKeystorePassword = androidSigningOptions.getReleaseSigningKeystorePassword();
            platformSDKsPrefs.setAndroidReleaseSigningKeystorePassword(releaseSigningKeystorePassword);
            debugSigningPassword = androidSigningOptions.getDebugSigningPassword();
            platformSDKsPrefs.setAndroidDebugSigningPassword(debugSigningPassword);
            if (null != androidSigningOptions) {
                androidSigningOptions.invalidate();
            }
        }
        catch (Throwable throwable) {
            if (null != androidSigningOptions) {
                androidSigningOptions.invalidate();
            }
            EncryptionUtils.zeroCharBuffer(releaseSigningKey);
            EncryptionUtils.zeroCharBuffer(releaseSigningKeystorePassword);
            EncryptionUtils.zeroCharBuffer(debugSigningPassword);
            throw throwable;
        }
        EncryptionUtils.zeroCharBuffer(releaseSigningKey);
        EncryptionUtils.zeroCharBuffer(releaseSigningKeystorePassword);
        EncryptionUtils.zeroCharBuffer(debugSigningPassword);
    }
}

