/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.ide;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import oracle.adfmf.common.util.McAppUtils;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.ide.MobileAppResourcesDirectoryNode;
import oracle.ide.model.Element;
import oracle.ide.model.Observer;
import oracle.ide.model.RelativeDirectoryElement;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.navigator.ApplicationChangeEvent;
import oracle.ide.navigator.ApplicationChangeListener;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemEvent;
import oracle.ide.net.URLFileSystemListener;
import oracle.ide.net.URLPath;
import oracle.jdeveloper.appresources.AbstractFolder;

public class MobileAppResourcesNode
extends AbstractFolder
implements RelativeDirectoryElement,
ApplicationChangeListener {
    private Workspace _currentWorkspace;
    private boolean _loadedChildren = false;
    private URL _rootURL = null;
    private URLPath _urlPath = new URLPath();
    private ResourcesNodeListener _listener = new ResourcesNodeListener();

    public MobileAppResourcesNode() {
        this._loadChildren();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void prepareChildren() {
        ArrayList arrayList = this._children;
        synchronized (arrayList) {
            if (!this._loadedChildren && this._currentWorkspace != null) {
                this._loadChildren();
            }
        }
    }

    public String getShortLabel() {
        return MobileResourceUtils.getText("MOBILE_APP_RESOURCES_NODE_LABEL");
    }

    public String getToolTipText() {
        return MobileResourceUtils.getText("MOBILE_APP_RESOURCES_NODE_DESCRIPTION");
    }

    public void applicationChanged(ApplicationChangeEvent event) {
        if (event.getStateChange() == 2) {
            if (this._currentWorkspace != null) {
                URLFileSystem.removeURLFileSystemListener((URL)this._getDir(this._currentWorkspace), (URLFileSystemListener)this._listener);
            }
            this._currentWorkspace = event.getApplication();
            if (this._currentWorkspace != null) {
                this._loadChildren();
                URLFileSystem.addURLFileSystemListener((URL)this._getDir(this._currentWorkspace), (URLFileSystemListener)this._listener);
            }
        } else if (event.getStateChange() == 1 && this._currentWorkspace != null) {
            URLFileSystem.removeURLFileSystemListener((URL)this._getDir(event.getApplication()), (URLFileSystemListener)this._listener);
            this._currentWorkspace = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _loadChildren() {
        this._loadRoots();
        ArrayList arrayList = this._children;
        synchronized (arrayList) {
            ArrayList removed = new ArrayList(this._children.size());
            for (Object child : this._children) {
                removed.add(child);
            }
            this._children.clear();
            UpdateMessage.fireChildrenRemoved((Subject)this, removed);
            this._children.clear();
            if (this._currentWorkspace != null) {
                this._rootURL = McAppUtils.getResourcesDir(this._currentWorkspace);
                if (URLFileSystem.isDirectory((URL)this._rootURL)) {
                    URL[] children = URLFileSystem.list((URL)this._rootURL);
                    for (int i = 0; i < children.length; ++i) {
                        if (!URLFileSystem.isDirectory((URL)children[i])) continue;
                        String dirName = URLFileSystem.getFileName((URL)children[i]);
                        this._addChild((Element)new MobileAppResourcesDirectoryNode(this._currentWorkspace, dirName, children[i]));
                    }
                    this._loadedChildren = true;
                }
            }
        }
    }

    private void _loadRoots() {
        if (this._currentWorkspace != null) {
            this._rootURL = McAppUtils.getResourcesDir(this._currentWorkspace);
            this._urlPath.setEntries(new URL[]{this._rootURL});
        }
    }

    public URLPath getRootDirectories() {
        return this._urlPath;
    }

    public String getRelativePath() {
        return "";
    }

    private void _addChild(Element child) {
        this._children.add(child);
        this.attach((Observer)child);
    }

    private URL _getDir(Workspace ws) {
        return McAppUtils.getWorkspaceDir(ws);
    }

    public Iterator<Element> getChildren() {
        return super.getChildren();
    }

    private void refreshChildren() {
        this._loadChildren();
        UpdateMessage.fireStructureChanged((Subject)this);
    }

    private class ResourcesNodeListener
    implements URLFileSystemListener {
        private ResourcesNodeListener() {
        }

        public void notifyEvent(URLFileSystemEvent event) {
            int eventType = event.getEventType();
            switch (eventType) {
                case 10: 
                case 11: 
                case 12: {
                    String rootPath = URLFileSystem.getPath((URL)MobileAppResourcesNode.this._rootURL);
                    String eventPath = URLFileSystem.getPath((URL)event.getURL());
                    if (eventPath == null || !eventPath.startsWith(rootPath)) break;
                    MobileAppResourcesNode.this.refreshChildren();
                    break;
                }
            }
        }
    }
}

