/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.ide;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.adfmf.framework.dt.ide.MobileAppResourcesNode;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.Observer;
import oracle.ide.model.RelativeDirectoryElement;
import oracle.ide.model.Subject;
import oracle.ide.model.UnrecognizedTextNode;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemEvent;
import oracle.ide.net.URLFileSystemListener;
import oracle.ide.net.URLPath;
import oracle.jdeveloper.appresources.AbstractFolder;
import oracle.jdeveloper.appresources.ApplicationResourcesWindow;
import oracle.jdeveloper.model.ApplicationContent;

public class MobileAppResourcesDirectoryNode
extends AbstractFolder
implements RelativeDirectoryElement,
Locatable,
Observer {
    private Workspace _workspace;
    private URLPath _roots;
    private String _relativePath;
    private URL _url;
    private String _shortLabel;
    private MobileAppResourcesListener _listener = new MobileAppResourcesListener();
    private boolean _loadedChildren = false;

    MobileAppResourcesDirectoryNode(Workspace workspace, String shortLabel, URL url) {
        this._shortLabel = shortLabel;
        this._workspace = workspace;
        this.setURL(url);
    }

    public URLPath getRootDirectories() {
        return this._roots;
    }

    public String getRelativePath() {
        return this._relativePath;
    }

    public String getShortLabel() {
        return this._shortLabel;
    }

    public String getLongLabel() {
        if (this._url != null) {
            return this._url.toString();
        }
        return "";
    }

    public URL getURL() {
        return this._url;
    }

    public void setURL(URL url) {
        if (this._url != null) {
            URLFileSystem.removeURLFileSystemListener((URL)this._url, (URLFileSystemListener)this._listener);
        }
        this._url = url;
        if (this._url != null) {
            this._roots = new URLPath(URLFileSystem.getParent((URL)url));
            this._relativePath = URLFileSystem.getFileName((URL)url);
            URLFileSystem.addURLFileSystemListener((URL)this._url, (URLFileSystemListener)this._listener);
        } else {
            this._roots = new URLPath();
            this._relativePath = "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void prepareChildren() {
        ArrayList arrayList = this._children;
        synchronized (arrayList) {
            if (!this._loadedChildren) {
                this._loadChildren();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _loadChildren() {
        ArrayList arrayList = this._children;
        synchronized (arrayList) {
            this._children.clear();
            if (this._workspace != null && this._url != null) {
                ApplicationContent content = ApplicationContent.getInstance((Workspace)this._workspace);
                Iterator iter = content.getDescriptors(this._url);
                while (iter.hasNext()) {
                    Object childNode = (Element)iter.next();
                    if (childNode instanceof UnrecognizedTextNode && this._isDirectory((Element)childNode)) {
                        childNode = new SubDirectoryNode(((Locatable)childNode).getURL());
                    }
                    this._children.add(childNode);
                }
                ApplicationResourcesWindow.sortNodes((ArrayList)this._children);
            }
            this._loadedChildren = true;
        }
    }

    private boolean _isDirectory(Element element) {
        if (element instanceof Locatable) {
            URL url = ((Locatable)element).getURL();
            return url != null && URLFileSystem.isDirectory((URL)url);
        }
        return false;
    }

    public void update(Object observed, UpdateMessage change) {
        List list;
        if (observed instanceof MobileAppResourcesNode && change.getMessageID() == UpdateMessage.CHILD_REMOVED && (list = change.getRemoveObjects()).contains((Object)this)) {
            ((MobileAppResourcesNode)((Object)observed)).detach(this);
            if (this._url != null) {
                URLFileSystem.removeURLFileSystemListener((URL)this._url, (URLFileSystemListener)this._listener);
            }
        }
    }

    public Iterator<Element> getChildren() {
        return super.getChildren();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _refreshChildren() {
        ArrayList arrayList = this._children;
        synchronized (arrayList) {
            if (this._loadedChildren) {
                this._loadChildren();
            }
        }
        UpdateMessage.fireStructureChanged((Subject)this);
    }

    private class MobileAppResourcesListener
    implements URLFileSystemListener {
        private MobileAppResourcesListener() {
        }

        public void notifyEvent(URLFileSystemEvent event) {
            int eventType = event.getEventType();
            switch (eventType) {
                case 1: 
                case 3: 
                case 4: {
                    MobileAppResourcesDirectoryNode.this._refreshChildren();
                }
            }
        }
    }

    private class SubDirectoryNode
    extends AbstractFolder
    implements RelativeDirectoryElement,
    Locatable {
        private URL _url;
        private String _relativePath;
        private String _shortLabel;

        SubDirectoryNode(URL url) {
            this._url = url;
            this._relativePath = URLFileSystem.toRelativeSpec((URL)this._url, (URL)MobileAppResourcesDirectoryNode.this.getRootDirectories().getFirstEntry(), (boolean)true);
            this._shortLabel = URLFileSystem.getFileName((URL)url);
        }

        public URLPath getRootDirectories() {
            return MobileAppResourcesDirectoryNode.this.getRootDirectories();
        }

        public String getRelativePath() {
            return this._relativePath;
        }

        public String getShortLabel() {
            return this._shortLabel;
        }

        public URL getURL() {
            return this._url;
        }

        public void setURL(URL url) {
            this._url = url;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void prepareChildren() {
            ArrayList arrayList = this._children;
            synchronized (arrayList) {
                this._children.clear();
                if (MobileAppResourcesDirectoryNode.this._workspace != null && this._url != null) {
                    ApplicationContent content = ApplicationContent.getInstance((Workspace)MobileAppResourcesDirectoryNode.this._workspace);
                    Iterator iter = content.getDescriptors(this._url);
                    while (iter.hasNext()) {
                        Object childNode = (Node)iter.next();
                        if (childNode instanceof UnrecognizedTextNode && MobileAppResourcesDirectoryNode.this._isDirectory((Element)childNode)) {
                            childNode = new SubDirectoryNode(((Locatable)childNode).getURL());
                        }
                        this._children.add(childNode);
                    }
                    ApplicationResourcesWindow.sortNodes((ArrayList)this._children);
                }
            }
        }

        public Iterator<Element> getChildren() {
            return super.getChildren();
        }
    }
}

