/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.ide;

import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.adf.share.dt.config.ADFConfigFactory;
import oracle.adf.share.dt.config.ADFConfigNode;
import oracle.adfdt.model.ide.managers.ConfigurationManager;
import oracle.adfdt.model.ide.navigator.nodes.DataControlConfigurationNode;
import oracle.adfdt.model.objects.Configuration;
import oracle.adfdt.model.objects.DataControl;
import oracle.adfdtinternal.model.ide.jdev.JDevDataControlManager;
import oracle.adfmf.common.util.FileUtils;
import oracle.adfmf.common.util.McAppUtils;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.common.util.ProjectUtils;
import oracle.adfmf.framework.dt.editor.FrameworkXmlSourceNode;
import oracle.adfmf.framework.dt.editor.feature.FeatureXmlSourceNode;
import oracle.ide.Context;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.model.JProjectUtil;
import oracle.jdeveloper.model.JavaProject;

public final class FrameworkProjectBuilder {
    private static final String _AMX_DIR = "amx";
    private static final String _PROPERTIES_DIR = "properties";
    private static final String _TEMPLATES_DIR = "templates";
    private static final String _DATA_CONTROLS_DCX_FILE = "DataControls.dcx";
    private static final String _LIFE_CYCLE_LISTENER_CLASS = "LifeCycleListenerImpl";
    private static final String _LIFE_CYCLE_LISTENER_TEMPLATE_FILE = "LifeCycleListenerImpl.template";
    private static final String _LIFE_CYCLE_LISTENER_JAVA_FILE = "LifeCycleListenerImpl.java";
    private static final String _PACKAGE = "package ";
    private static final Logger _LOGGER = Logger.getLogger(FrameworkProjectBuilder.class.getName());

    public static void initBaseProject(Project project) {
        ProjectUtils.setDefaultJDK(project);
        ProjectUtils.setCurrentCompilerJavac(project);
        ProjectUtils.setJdkVerSource(project, "1.4");
        ProjectUtils.setJdkVerTarget(project, "1.4");
        ProjectUtils.setProjectDefaultBundleTypeToXliff(project);
        ProjectUtils.enableRemoteDebugging(project);
    }

    public static void initAppControllerProject(Workspace workspace, Project project) {
        FileUtils.createDirectory(McAppUtils.getHtmlRootDirectory(project));
        FrameworkXmlSourceNode appXmlNode = McAppUtils.findOrCreateApplicationXml(workspace);
        McAppUtils.updateAppControllerFolder(appXmlNode, project);
        FrameworkProjectBuilder._findOrcreateApplicationContent(workspace);
        McAppUtils.setApplicationDefaultBundleTypeToXliff(workspace);
        FrameworkProjectBuilder._createLifeCycleListenerClass(project);
        FrameworkProjectBuilder._addDeviceFeaturesDataControl(project);
        McAppUtils.findOrCreateMobileConfigXml(workspace);
        McAppUtils.findOrCreateSkinsXml(project);
        FileUtils.createDirectory(McAppUtils.getApplicationSrcMetaInfDirURL(workspace));
        FrameworkProjectBuilder._addCvmAndLoggingPropertiesFiles(McAppUtils.getApplicationSrcMetaInfDirURL(workspace));
        ADFConfigNode adfConfigNode = ADFConfigFactory.findADFConfigXml((Workspace)workspace);
        if (adfConfigNode == null) {
            ADFConfigFactory.createADFConfigXml((Workspace)workspace);
        }
        Project nodeToSave = null;
        try {
            nodeToSave = project;
            nodeToSave.save();
            nodeToSave = workspace;
            nodeToSave.save();
        }
        catch (Exception e) {
            _LOGGER.log(Level.SEVERE, MobileResourceUtils.getMsg("ADF-MBL-00011", nodeToSave.getLongLabel(), e));
        }
    }

    public static void initViewControllerProject(final Workspace workspace, final Project project) {
        FileUtils.createDirectory(McAppUtils.getHtmlRootDirectory(project));
        final FeatureXmlSourceNode featureXmlNode = McAppUtils.findOrCreateFeatureXml(project);
        try {
            project.save();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    Context ctx = new Context(null, workspace, project, (Node)featureXmlNode);
                    EditorManager editorMgr = EditorManager.getEditorManager();
                    editorMgr.openEditor(new OpenEditorOptions(ctx));
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
        catch (Exception e) {
            _LOGGER.log(Level.SEVERE, MobileResourceUtils.getMsg("ADF-MBL-00011", project.getLongLabel(), e));
        }
    }

    private static void _addDeviceFeaturesDataControl(Project project) {
        DataControlConfigurationNode newDcxNode = ConfigurationManager.findOrCreateConfigurationNodeInProject((Context)new Context(null, project));
        try {
            URL extensionDirectoryUrl = FileUtils.getSupportFilesDirectoryUrl();
            URL amxDirectoryUrl = URLFactory.newDirURL((URL)extensionDirectoryUrl, (String)_AMX_DIR);
            URL sourceDcxUrl = URLFactory.newURL((URL)amxDirectoryUrl, (String)_DATA_CONTROLS_DCX_FILE);
            DataControlConfigurationNode oldDcxNode = (DataControlConfigurationNode)NodeFactory.findOrCreate(DataControlConfigurationNode.class, (URL)sourceDcxUrl);
            List dataControls = oldDcxNode.createConfiguration(new Context(null, project)).getDataControls();
            Configuration newConfig = newDcxNode.createConfiguration(new Context(null, project));
            for (DataControl dc : dataControls) {
                if (newConfig.findDataControl(dc.getId()) != null) continue;
                org.w3c.dom.Node importedDataControlNode = newConfig.getOwnerDocument().importNode(dc.getElement(), true);
                newConfig.appendChild(importedDataControlNode);
            }
            newDcxNode.save();
            JDevDataControlManager.getInstance().notifyDataControlSetChanged();
        }
        catch (Exception e) {
            _LOGGER.log(Level.SEVERE, MobileResourceUtils.getMsg("ADF-MBL-00068", e));
        }
    }

    private static void _findOrcreateApplicationContent(Workspace workspace) {
        try {
            URL resourcesDirURL = McAppUtils.getResourcesDir(workspace);
            if (URLFileSystem.exists((URL)resourcesDirURL)) {
                return;
            }
            URL urlSrc = URLFactory.newDirURL((URL)FileUtils.getSupportFilesDirectoryUrl(), (String)"resources");
            FileUtils.copyDirectory(urlSrc, resourcesDirURL);
        }
        catch (Exception e) {
            _LOGGER.log(Level.SEVERE, MobileResourceUtils.getMsg("ADF-MBL-00502", e));
        }
    }

    private static void _addCvmAndLoggingPropertiesFiles(URL srcDirectory) {
        URL extensionDirectoryUrl = FileUtils.getSupportFilesDirectoryUrl();
        URL propertiesDirectoryUrl = URLFactory.newDirURL((URL)extensionDirectoryUrl, (String)_PROPERTIES_DIR);
        URL cvmPropertiesUrl = URLFactory.newURL((URL)propertiesDirectoryUrl, (String)"cvm.properties");
        URL logPropertiesUrl = URLFactory.newURL((URL)propertiesDirectoryUrl, (String)"logging.properties");
        try {
            URLFileSystem.copy((URL)cvmPropertiesUrl, (URL)URLFactory.newURL((URL)srcDirectory, (String)"cvm.properties"));
            URLFileSystem.copy((URL)logPropertiesUrl, (URL)URLFactory.newURL((URL)srcDirectory, (String)"logging.properties"));
        }
        catch (Exception e) {
            _LOGGER.log(Level.SEVERE, MobileResourceUtils.getMsg("ADF-MBL-00014", srcDirectory.getPath(), e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _createLifeCycleListenerClass(Project project) {
        block8: {
            URL srcDirectory;
            URL extensionDirectoryUrl = FileUtils.getSupportFilesDirectoryUrl();
            URL templatesDirectoryUrl = URLFactory.newDirURL((URL)extensionDirectoryUrl, (String)_TEMPLATES_DIR);
            URL lifeCycleListenerTemplateUrl = URLFactory.newURL((URL)templatesDirectoryUrl, (String)_LIFE_CYCLE_LISTENER_TEMPLATE_FILE);
            boolean isDefaultPackageProvided = false;
            String defaultPackage = JavaProject.getInstance((Project)project).getDefaultPackage();
            if (defaultPackage != null && !(defaultPackage = defaultPackage.trim()).isEmpty()) {
                isDefaultPackageProvided = true;
            }
            URL projectSrcDirectory = srcDirectory = JProjectUtil.getProjectBasePath((Project)project);
            try {
                if (isDefaultPackageProvided) {
                    projectSrcDirectory = URLFactory.newDirURL((URL)srcDirectory, (String)defaultPackage.replace(".", "/"));
                    BufferedWriter bufferedWriter = null;
                    FileReader templateFile = null;
                    try {
                        boolean exists = URLFileSystem.mkdirs((URL)projectSrcDirectory);
                        if (exists) {
                            bufferedWriter = new BufferedWriter(new FileWriter(projectSrcDirectory.getPath() + _LIFE_CYCLE_LISTENER_JAVA_FILE));
                            bufferedWriter.write(_PACKAGE + defaultPackage + ";");
                            templateFile = new FileReader(lifeCycleListenerTemplateUrl.getPath());
                            String templateContents = FileUtils.readFileToString(templateFile);
                            bufferedWriter.write(templateContents);
                            bufferedWriter.flush();
                        }
                        break block8;
                    }
                    finally {
                        FileUtils.closeStream(templateFile, null);
                        FileUtils.closeStream(bufferedWriter, null);
                    }
                }
                URLFileSystem.copy((URL)lifeCycleListenerTemplateUrl, (URL)URLFactory.newURL((URL)projectSrcDirectory, (String)_LIFE_CYCLE_LISTENER_JAVA_FILE));
            }
            catch (Exception e) {
                _LOGGER.log(Level.SEVERE, MobileResourceUtils.getMsg("ADF-MBL-00040", projectSrcDirectory.getPath(), e));
            }
        }
    }
}

