/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.ide;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.adfmf.common.util.FileUtils;
import oracle.adfmf.common.util.McAppUtils;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.ide.FeatureBuilderModel;
import oracle.ide.Context;
import oracle.ide.component.NewFileValidator;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLChooserInit;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLTextField;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.plaf.IconicButtonUI;
import oracle.jdeveloper.builder.folder.FolderBuilderPanel;
import oracle.jdeveloper.wizard.common.BaliWizardState;

public class FeatureBuilderPanel
extends FolderBuilderPanel
implements URLChooserInit {
    private JLabel _lblFeatureId = new JLabel();
    private JTextField _fldFeatureId;
    private JLabel _lblFeatureName = new JLabel();
    private JTextField _fldFeatureName;
    private JLabel _lblDirectory = new JLabel();
    private URLTextField _fldDirectory;
    private JButton _btnDirBrowse;
    private JCheckBox _fldAddRef = new JCheckBox();
    private String _packagePrefix = null;
    private boolean _supportsIdAutoFill = true;
    private List<String> _featureIDList = new ArrayList<String>();
    private URL _baseUrl;
    private final GridBagLayout _gridBagLayout = new GridBagLayout();
    private final transient Context _context;
    private static final long serialVersionUID = 1L;

    public FeatureBuilderPanel(Context context) throws IllegalArgumentException {
        if (null == context) {
            throw new IllegalArgumentException();
        }
        this._context = context;
        this._jbInit();
    }

    public void initializeFromState(BaliWizardState state) {
        FeatureBuilderModel model = (FeatureBuilderModel)state;
        this.setFileExtension(model.getFileExtension());
        this.setFileType(model.getFileType());
        try {
            URL dirURL = new URL(model.getDirectory().toString() + model.getFileName() + "/");
            this.setDirectoryURL(dirURL);
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        this.setFileName(model.getFileName());
        this.setCanOverwriteOpenNodes(true);
        this.setNewFileURLValidator((NewFileValidator)model);
        String featureName = model.getFileName();
        int dotPos = featureName.lastIndexOf(".");
        if (dotPos != -1) {
            this._packagePrefix = featureName.substring(0, dotPos);
            featureName = featureName.substring(dotPos + 1);
        }
        this._setFeatureName(featureName);
        this._addFeatureRef(model.shouldAddFeatureRef());
        this._featureIDList = model.getFeatureIdList();
    }

    public boolean validateAndWriteToState(BaliWizardState state) {
        FeatureBuilderModel model = (FeatureBuilderModel)state;
        try {
            URL url = URLFileSystem.getParent((URL)this.getFileURL());
            if (url != null) {
                model.setFileName(this.getFileField().getText());
                model.setURL(url);
                model.setFeatureName(this._fldFeatureName.getText());
                model.setAddFeatureRef(this._fldAddRef.isSelected());
                return true;
            }
        }
        catch (TraversalException ex) {
            ex.showMessageDialog((Component)((Object)this));
        }
        return false;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this._lblFeatureName.setEnabled(enabled);
        this._fldFeatureName.setEnabled(enabled);
        this._fldFeatureName.setEditable(enabled);
        this._lblFeatureId.setEnabled(enabled);
        this._fldFeatureId.setEnabled(enabled);
        this._fldFeatureId.setEditable(enabled);
        this._lblDirectory.setEnabled(enabled);
        this._fldDirectory.setEnabled(enabled);
        this._fldDirectory.setEditable(enabled);
        this._fldAddRef.setEnabled(enabled);
    }

    public URL getFileURL(boolean validateURL) throws TraversalException {
        String newfeatureID = this._fldFeatureId.getText().trim();
        if (newfeatureID.length() <= 0) {
            throw new TraversalException(MobileResourceUtils.getText("ADF_MOBILE_FEATURE_ID_VALID_ERROR_MSG"), MobileResourceUtils.getText("ADF_MOBILE_FEATURE_ID_ERROR_TITLE"));
        }
        if (this._featureIDList != null && this._featureIDList.contains(newfeatureID)) {
            throw new TraversalException(MobileResourceUtils.getText("ADF_MOBILE_FEATURE_ID_UNIQUE_ERROR_MSG", newfeatureID), MobileResourceUtils.getText("ADF_MOBILE_FEATURE_ID_ERROR_TITLE"));
        }
        this.resetURLCache();
        URL selectedUrl = super.getFileURL(validateURL);
        if (null == selectedUrl || !URLFileSystem.isBaseURLFor((URL)this._baseUrl, (URL)selectedUrl)) {
            throw new TraversalException(MobileResourceUtils.getText("ADF_MOBILE_FEATURE_INVALID_DIRECTORY_MSG"), MobileResourceUtils.getText("ADF_MOBILE_FEATURE_INVALID_DIRECTORY_TITLE"));
        }
        return selectedUrl;
    }

    public void initURLChooser(URLChooser urlChooser) {
        FileUtils.initializeURLChooser(this._baseUrl, urlChooser);
    }

    private void _jbInit() {
        this.setSupportsAutoFill(true);
        this.setEnforceFileExtension(false);
        this._fldFeatureId = this.getFileField();
        this._fldFeatureName = new JTextField();
        this._fldDirectory = (URLTextField)this.getDirectoryField();
        this._fldDirectory.setChooserInit((URLChooserInit)this);
        this._baseUrl = McAppUtils.getProjectPublicHtmlDir(this._context.getProject());
        this._btnDirBrowse = this.getBrowseButton();
        this.setBrowseButtonLabel("");
        Border buttonBorder = BorderFactory.createEmptyBorder(4, 4, 4, 4);
        IconicButtonUI.install((AbstractButton)this._btnDirBrowse);
        this._btnDirBrowse.setContentAreaFilled(false);
        this._btnDirBrowse.setBorder(buttonBorder);
        this._btnDirBrowse.setIcon(OracleIcons.getIcon((String)"lov.png"));
        this._setFeatureNamePrompt(MobileResourceUtils.getText("ADF_MOBILE_FEATURE_NAME_LABEL"));
        this._setFeatureIdPrompt(MobileResourceUtils.getText("ADF_MOBILE_FEATURE_ID_LABEL"));
        this._setFeatureDirectoryPrompt(MobileResourceUtils.getText("ADF_MOBILE_FEATURE_DIRECTORY_LABEL"));
        this._addFeatureRefPrompt(MobileResourceUtils.getText("ADF_MOBILE_FEATURE_ADD_REFERENCE_LABEL"));
        FeatureNameListener nameListener = new FeatureNameListener();
        this._fldFeatureName.getDocument().addDocumentListener(nameListener);
        FeatureIDListener idFocusListener = new FeatureIDListener();
        this._fldFeatureId.addFocusListener(idFocusListener);
        this._layoutComponents();
    }

    private void _layoutComponents() {
        this.setLayout(this._gridBagLayout);
        this.removeAll();
        this.add(this._lblFeatureName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.add(this._fldFeatureName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 6, 5, 5), 0, 0));
        this.add(this._lblFeatureId, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.add(this._fldFeatureId, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 6, 5, 5), 0, 0));
        this.add(this._lblDirectory, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this._fldDirectory, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 6, 5, 5), 0, 0));
        this.add(this._btnDirBrowse, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.add(this._fldAddRef, new GridBagConstraints(0, 4, 2, 0, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
    }

    private void _setFeatureName(String featureName) {
        this._fldFeatureName.setText(featureName);
    }

    private void _addFeatureRef(boolean addReference) {
        this._fldAddRef.setSelected(addReference);
    }

    private void _setFeatureIdPrompt(String prompt) {
        ResourceUtils.resLabel((JLabel)this._lblFeatureId, (Component)this._fldFeatureId, (String)prompt);
    }

    private void _setFeatureNamePrompt(String prompt) {
        ResourceUtils.resLabel((JLabel)this._lblFeatureName, (Component)this._fldFeatureName, (String)prompt);
    }

    private void _setFeatureDirectoryPrompt(String prompt) {
        ResourceUtils.resLabel((JLabel)this._lblDirectory, (Component)this._fldDirectory, (String)prompt);
    }

    private void _addFeatureRefPrompt(String prompt) {
        ResourceUtils.resButton((AbstractButton)this._fldAddRef, (String)prompt);
    }

    private class FeatureIDListener
    implements FocusListener {
        private String _featureIDText = null;

        private FeatureIDListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            this._featureIDText = FeatureBuilderPanel.this._fldFeatureId.getText();
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (this._featureIDText != null && !this._featureIDText.equals(FeatureBuilderPanel.this._fldFeatureId.getText())) {
                FeatureBuilderPanel.this._supportsIdAutoFill = false;
            }
        }
    }

    private class FeatureNameListener
    implements DocumentListener {
        private FeatureNameListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this._updateFeatureId();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this._updateFeatureId();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        private void _updateFeatureId() {
            String featureName = FeatureBuilderPanel.this._fldFeatureName.getText().trim();
            if (FeatureBuilderPanel.this._supportsIdAutoFill) {
                if (FeatureBuilderPanel.this._packagePrefix != null && FeatureBuilderPanel.this._packagePrefix.length() > 0) {
                    FeatureBuilderPanel.this._fldFeatureId.setText(FeatureBuilderPanel.this._packagePrefix + "." + featureName);
                } else {
                    FeatureBuilderPanel.this._fldFeatureId.setText(featureName);
                }
            }
        }
    }
}

