/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.ide;

import java.net.URL;
import java.util.List;
import oracle.adfmf.common.util.McAppUtils;
import oracle.adfmf.framework.dt.editor.feature.FeatureXmlConstants;
import oracle.adfmf.framework.dt.editor.feature.FeatureXmlSourceNode;
import oracle.adfmf.framework.dt.ide.FeatureFolderSourceModel;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.task.FixedNameTransactionTask;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ideimpl.navigator.delete.model.DeleteFileVisitor;
import oracle.ideimpl.navigator.delete.model.FileSystemModelUtils;
import oracle.jdeveloper.builder.SourceModel;
import oracle.jdeveloper.builder.folder.EmptyFolderBuilderModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FeatureBuilderModel
extends EmptyFolderBuilderModel {
    private Context _context = null;
    private String _featureName = null;
    private boolean _addReference = true;
    private static final String _CONTENT_ID = "1";

    public FeatureBuilderModel(Context context) {
        super(context);
    }

    public String getFeatureName() {
        return this._featureName;
    }

    public List<String> getFeatureIdList() {
        return ((FeatureFolderSourceModel)this.getSourceModel()).getFeatureIdList();
    }

    public void setFeatureName(String featureName) {
        this._featureName = featureName;
    }

    public boolean shouldAddFeatureRef() {
        return this._addReference;
    }

    public void setAddFeatureRef(boolean addReference) {
        this._addReference = addReference;
    }

    protected void initializeFromContext(Context ctx) {
        this._context = ctx;
        super.initializeFromContext(ctx);
    }

    protected boolean buildFile(Node node) {
        if (super.buildFile(node)) {
            this._deleteReadMeFile();
            this._updateFeatureXml();
            if (this.shouldAddFeatureRef()) {
                this._addFeatureRefToApplicationXml();
            }
            return true;
        }
        return false;
    }

    protected String getBaseName() {
        Workspace workspace = null;
        if (this._context != null) {
            workspace = this._context.getWorkspace();
        }
        return FeatureXmlConstants.getFeatureIdBaseName(workspace);
    }

    protected SourceModel createSourceModel() {
        return new FeatureFolderSourceModel();
    }

    protected void addFileToProject(Node node) {
    }

    private void _deleteReadMeFile() {
        URL fileURL = this.getSourceModel().getURL();
        String fName = URLFileSystem.getFileName((URL)fileURL);
        if ("TempReadme.txt".equalsIgnoreCase(fName) && URLFileSystem.exists((URL)fileURL)) {
            DeleteFileVisitor deleteVisitor = new DeleteFileVisitor();
            FileSystemModelUtils.deleteFolderRecursively((URL[])new URL[]{fileURL}, (DeleteFileVisitor)deleteVisitor);
        }
    }

    private void _updateFeatureXml() {
        Project project = this.getProject();
        final String featureId = this.getFileName();
        final String featureName = this.getFeatureName();
        final String contentId = featureId + "." + _CONTENT_ID;
        FeatureXmlSourceNode featureXmlNode = McAppUtils.findOrCreateFeatureXml(project);
        if (featureXmlNode != null) {
            Context context = Context.newIdeContext((Node)featureXmlNode);
            context.setProject(project);
            JDevXmlContext xmlContext = JDevXmlContext.getXmlContext((Context)context);
            XmlModel model = xmlContext.getModel();
            new FixedNameTransactionTask("Adding feature contents"){

                protected void performTask(AbstractModel model) throws XmlCommitException {
                    Document doc = model.getDocument();
                    Element feature = doc.createElementNS("http://xmlns.oracle.com/adf/mf", McAppUtils.getQualifiedName("feature"));
                    feature.setAttributeNS(null, "id", featureId);
                    feature.setAttributeNS(null, "name", featureName);
                    Element content = doc.createElementNS("http://xmlns.oracle.com/adf/mf", McAppUtils.getQualifiedName("content"));
                    content.setAttributeNS(null, "id", contentId);
                    Element amx = doc.createElementNS("http://xmlns.oracle.com/adf/mf", McAppUtils.getQualifiedName("amx"));
                    content.appendChild(amx);
                    feature.appendChild(content);
                    doc.getFirstChild().appendChild(feature);
                }
            }.run((AbstractModel)model);
        }
    }

    private void _addFeatureRefToApplicationXml() {
        URL appXmlUrl;
        Context context = Context.newIdeContext();
        Workspace workspace = context.getWorkspace();
        if (workspace == null) {
            workspace = Ide.getActiveWorkspace();
        }
        if (!URLFileSystem.exists((URL)(appXmlUrl = McAppUtils.getApplicationXmlURL(workspace)))) {
            McAppUtils.findOrCreateApplicationXml(workspace);
        }
        String featureId = this.getFileName();
        McAppUtils.addFeatureReference(workspace, featureId);
    }
}

