/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.ide;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import oracle.adfdt.library.JDevResourceService;
import oracle.adfdt.library.event.ResourceChangeEvent;
import oracle.adfmf.common.util.McAppUtils;
import oracle.adfmf.common.util.McTechnologyUtils;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.model.WorkspaceChangeEvent;
import oracle.ide.model.WorkspaceChangeListener;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLPath;
import oracle.javatools.data.ChangeInfo;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.model.ApplicationLibraries;

public class FeatureArchiveWorkspaceChangeListener
implements WorkspaceChangeListener {
    private static final String CONNECTIONS = "ADF_Connections";

    public void workspacePropertiesChanged(WorkspaceChangeEvent event) {
        Workspace workspace = event.getWorkspace();
        Project project = McTechnologyUtils.findFirstUIProjectInWorkspace(workspace);
        for (ChangeInfo info : event.getChangeDetails()) {
            String libarayId = null;
            if (info.getChangeType() != 1 || (libarayId = this._getLibraryId(info)) == null) continue;
            List<URL> urls = this._getAddedFeatureAchiveURLList(libarayId, workspace);
            ArrayList<String> alltypes = new ArrayList<String>();
            alltypes.add(CONNECTIONS);
            ResourceChangeEvent rcevent = new ResourceChangeEvent(workspace, project, null, CONNECTIONS, alltypes);
            rcevent.addAdded(urls);
            JDevResourceService svc = JDevResourceService.getInstance((Project)project);
            ArrayList<ResourceChangeEvent> events = new ArrayList<ResourceChangeEvent>();
            events.add(rcevent);
            svc.fireResourcesChanged(events);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String _getLibraryId(ChangeInfo info) {
        String _ID = "id";
        String libraryId = null;
        HashStructure hash = info.getNewValueAsHashStructure();
        if (hash != null) {
            libraryId = hash.getString("id");
        } else {
            ListStructure list = info.getNewValueAsListStructure();
            Object object = list.iteratorLock();
            synchronized (object) {
                for (Object o : list) {
                    if (!(o instanceof HashStructure)) continue;
                    libraryId = ((HashStructure)o).getString("id");
                }
            }
        }
        return libraryId;
    }

    private List<URL> _getAddedFeatureAchiveURLList(String libraryId, Workspace workspace) {
        URL[] jarUrls;
        ArrayList<URL> urls = new ArrayList<URL>();
        ApplicationLibraries lib = ApplicationLibraries.getInstance((Workspace)workspace);
        JLibrary jLib = lib.resolveLibrary((Object)libraryId);
        URLPath path = jLib.getClassPath();
        for (URL jarUrl : jarUrls = path.getEntries()) {
            URL fileUrl = JarUtil.getJarFileURL((URL)jarUrl);
            if (!McAppUtils.isFeatureArchive(fileUrl)) continue;
            urls.add(fileUrl);
        }
        return urls;
    }
}

