/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.ide;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.adfmf.common.ADFMobileConstants;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.ide.net.URLFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class FeatureArchive {
    private final URL _jarURL;
    private static final Logger _logger = Logger.getLogger(FeatureArchive.class.getName());

    public FeatureArchive(URL jarURL) {
        this._jarURL = jarURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getFeatureIds() {
        InputStream is = null;
        ArrayList<String> featureIds = new ArrayList<String>();
        try {
            URL featureXmlUrl = this.getJarFeatureXmlUrl();
            is = featureXmlUrl.openStream();
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document featureXmlDOM = documentBuilder.parse(is);
            NodeList features = featureXmlDOM.getElementsByTagNameNS("http://xmlns.oracle.com/adf/mf", "feature");
            int count = features != null ? features.getLength() : 0;
            for (int i = 0; i < count; ++i) {
                Element element = (Element)features.item(i);
                String featureId = element.getAttributeNS(null, "id");
                if (featureId == null || featureId.trim().length() <= 0) continue;
                featureIds.add(featureId);
            }
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, MobileResourceUtils.getMsg("ADF-MBL-00503", e));
        }
        finally {
            if (null != is) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        return Collections.unmodifiableList(featureIds);
    }

    public URL getJarFeatureXmlUrl() {
        return URLFactory.newJarURL((URL)this._jarURL, (String)ADFMobileConstants.FEATURE_XML_FAR_PATH);
    }
}

