/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.editor.preference;

import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyEditor;
import java.util.Hashtable;
import javax.swing.Box;
import javax.swing.JComponent;
import oracle.adfmf.framework.dt.editor.FrameworkXmlEditorConstants;
import oracle.adfmf.framework.dt.editor.FrameworkXmlKeys;
import oracle.adfmf.framework.dt.editor.feature.FeatureXmlConstants;
import oracle.adfmf.framework.dt.editor.feature.FeatureXmlKeys;
import oracle.adfmf.framework.dt.editor.preference.PanelHelper;
import oracle.adfmf.framework.dt.editor.preference.PrefBooleanAttributePropertyEditor;
import oracle.adfmf.framework.dt.editor.preference.PrefBooleanDefaultAttrComboBoxEditor;
import oracle.adfmf.framework.dt.editor.preference.PrefTextAttributePropertyEditor;
import oracle.adfmf.framework.dt.editor.preference.PrefTypeComboBoxEditor;
import oracle.adfmf.framework.dt.editor.preference.PrefXmlTreePropertyEditor;
import oracle.adfmf.framework.dt.editor.preference.PreferenceListTableEditor;
import oracle.bali.xml.gui.base.xmlComponent.XmlComponentWrapper;
import oracle.bali.xml.gui.jdev.xmlComponent.AbstractXmlPanelWrapper;
import oracle.bali.xml.gui.swing.xmlComponent.XmlCheckBoxEditor;
import oracle.bali.xml.gui.swing.xmlComponent.XmlContextualActionButton;
import oracle.bali.xml.gui.swing.xmlComponent.XmlLayoutOption;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.XmlUsage;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeFilter;
import sun.beans.editors.StringEditor;

public class PreferencePanelHelper {
    private static final int IF_HIDDEN_TAKE_NO_SPACE = 3;
    private static final int ROWS_TO_SHOW = 12;
    private static final Hashtable<String, XmlKey> _frameworkHashTable = new Hashtable();
    private static final Hashtable<String, XmlKey> _featureHashTable = new Hashtable();
    private static final Hashtable[] _keys = new Hashtable[]{_frameworkHashTable, _featureHashTable};
    private static final XmlUsage[] _prefTreeUsage = new XmlUsage[2];
    private static final String PREFERENCES = "preferences";
    private static final String PREF_GROUP = "pref_group";
    private static final String PREF_PAGE = "pref_page";
    private static final String PREF_BOOLEAN = "pref_boolean";
    private static final String PREF_LIST = "pref_list";
    private static final String PREF_NUMBER = "pref_number";
    private static final String PREF_TEXT = "pref_text";
    private static final String PREF_VALUE = "pref_value";
    private static final String PREF_BOOLEAN_LABEL = "pref_boolean_label";
    private static final String PREF_BOOLEAN_ID = "pref_boolean_id";
    private static final String PREF_BOOLEAN_DEFAULT = "pref_boolean_default";
    private static final String PREF_GROUP_LABEL = "pref_group_label";
    private static final String PREF_GROUP_ID = "pref_group_id";
    private static final String PREF_PAGE_LABEL = "pref_page_label";
    private static final String PREF_PAGE_ID = "pref_page_id";
    private static final String PREF_LIST_LABEL = "pref_list_label";
    private static final String PREF_LIST_ID = "pref_list_id";
    private static final String PREF_LIST_DEFAULT = "pref_list_default";
    private static final String PREF_VALUE_NAME = "pref_value_name";
    private static final String PREF_VALUE_VALUE = "pref_value_value";
    private static final String PREF_NUMBER_LABEL = "pref_number_label";
    private static final String PREF_NUMBER_ID = "pref_number_id";
    private static final String PREF_NUMBER_DEFAULT = "pref_number_default";
    private static final String PREF_TEXT_LABEL = "pref_text_label";
    private static final String PREF_TEXT_ID = "pref_text_id";
    private static final String PREF_TEXT_DEFAULT = "pref_text_default";
    private static final String PREF_TEXT_SECRET = "pref_text_secret";
    private static final String PREF_TYPE = "pref_type";

    private PreferencePanelHelper() {
    }

    public static void addPanelComponents(String rootElement, AbstractXmlPanelWrapper panel, XmlComponentWrapper parent) {
        XmlFile fileName;
        if (rootElement.equals("application")) {
            fileName = XmlFile.APPLICATION;
        } else if (rootElement.equals("features")) {
            fileName = XmlFile.FEATURE;
        } else {
            return;
        }
        int fileIndex = fileName.getIndex();
        XmlComponentWrapper preferenceTree = panel.createXmlComponentWrapper((XmlKey)_keys[fileIndex].get(PREFERENCES)).setPropertyEditor((Object)new PrefXmlTreePropertyEditor().setXmlUsage(_prefTreeUsage[fileIndex]).setVisibleRowCount(12).setTreeNodeXmlKey((XmlKey)_keys[fileIndex].get(PREF_GROUP)).setNodeFilter((NodeFilter)new PreferenceNodeFilter()));
        if (parent != null) {
            preferenceTree.setParent(parent);
        }
        XmlLayoutOption preferenceTreeLayout = new XmlLayoutOption().setAddLabel(false).setShowContextualActionButton(false).setWrapToNextRow(false).setRightMargin(10);
        preferenceTreeLayout.getComponentConstraint().alignY("top").growY().spanY();
        ((PanelHelper)panel).addComponent(preferenceTree, preferenceTreeLayout);
        XmlLayoutOption layoutWithLabel = new XmlLayoutOption();
        layoutWithLabel.getComponentConstraint().setHideMode(3);
        layoutWithLabel.getLabelConstraint().setHideMode(3);
        XmlLayoutOption layoutWithoutLabel = new XmlLayoutOption().setAddLabel(false).setShowContextualActionButton(false).setGrowRow(false).setPushRow(false);
        layoutWithoutLabel.getComponentConstraint().setHideMode(3);
        layoutWithoutLabel.getComponentConstraint().setSpanX(2);
        PreferencePanelHelper.addPrefGroupAttrCompBefore(fileName, panel, preferenceTree, layoutWithLabel);
        PreferencePanelHelper.addPrefPageAttrCompBefore(fileName, panel, preferenceTree, layoutWithLabel);
        PreferencePanelHelper.addPrefBooleanAttrCompBefore(fileName, panel, preferenceTree, layoutWithLabel);
        PreferencePanelHelper.addPrefListAttrCompBefore(fileName, panel, preferenceTree, layoutWithLabel);
        PreferencePanelHelper.addPrefNumberAttrCompBefore(fileName, panel, preferenceTree, layoutWithLabel);
        PreferencePanelHelper.addPrefTextAttrCompBefore(fileName, panel, preferenceTree, layoutWithLabel);
        ((PanelHelper)panel).addComponent(panel.createXmlComponentWrapper((XmlKey)_keys[fileIndex].get(PREF_TYPE)).setParent(preferenceTree).setPropertyEditor((Object)new PrefTypeComboBoxEditor((PropertyEditor)new StringEditor())), layoutWithLabel);
        PreferencePanelHelper.addPrefBooleanAttrCompAfter(fileName, panel, preferenceTree, layoutWithLabel);
        PreferencePanelHelper.addPrefListAttrCompAfter(fileName, panel, preferenceTree, layoutWithoutLabel);
        PreferencePanelHelper.addPrefNumberAttrCompAfter(fileName, panel, preferenceTree, layoutWithLabel);
        PreferencePanelHelper.addPrefTextAttrCompAfter(fileName, panel, preferenceTree, layoutWithLabel, layoutWithoutLabel);
    }

    public static void setComponentVisible(Component component, boolean visible) {
        if (component != null) {
            Component labelComponent = (Component)((JComponent)component).getClientProperty("labeledBy");
            if (labelComponent != null) {
                labelComponent.setVisible(visible);
            }
            component.setVisible(visible);
            Container parentContainer = component.getParent();
            if (parentContainer instanceof Box) {
                parentContainer.setVisible(visible);
                for (Component childComponent : parentContainer.getComponents()) {
                    if (!(childComponent instanceof XmlContextualActionButton)) continue;
                    childComponent.setVisible(visible);
                }
            }
        }
    }

    private static void addPrefBooleanAttrCompBefore(XmlFile fileName, AbstractXmlPanelWrapper panel, XmlComponentWrapper preferenceTree, XmlLayoutOption layoutWithLabel) {
        int i = fileName.getIndex();
        PreferencePanelHelper.addTextAttrEditor((XmlKey)_keys[i].get(PREF_BOOLEAN_LABEL), panel, preferenceTree, layoutWithLabel);
        PreferencePanelHelper.addTextAttrEditor((XmlKey)_keys[i].get(PREF_BOOLEAN_ID), panel, preferenceTree, layoutWithLabel);
    }

    private static void addPrefBooleanAttrCompAfter(XmlFile fileName, AbstractXmlPanelWrapper panel, XmlComponentWrapper preferenceTree, XmlLayoutOption layoutWithLabel) {
        int i = fileName.getIndex();
        ((PanelHelper)panel).addComponent(panel.createXmlComponentWrapper((XmlKey)_keys[i].get(PREF_BOOLEAN_DEFAULT)).setParent(preferenceTree).setPropertyEditor((Object)new PrefBooleanDefaultAttrComboBoxEditor((PropertyEditor)new StringEditor())), layoutWithLabel);
    }

    private static void addPrefGroupAttrCompBefore(XmlFile fileName, AbstractXmlPanelWrapper panel, XmlComponentWrapper preferenceTree, XmlLayoutOption layoutWithLabel) {
        int i = fileName.getIndex();
        PreferencePanelHelper.addTextAttrEditor((XmlKey)_keys[i].get(PREF_GROUP_LABEL), panel, preferenceTree, layoutWithLabel);
        PreferencePanelHelper.addTextAttrEditor((XmlKey)_keys[i].get(PREF_GROUP_ID), panel, preferenceTree, layoutWithLabel);
    }

    private static void addPrefPageAttrCompBefore(XmlFile fileName, AbstractXmlPanelWrapper panel, XmlComponentWrapper preferenceTree, XmlLayoutOption layoutWithLabel) {
        int i = fileName.getIndex();
        PreferencePanelHelper.addTextAttrEditor((XmlKey)_keys[i].get(PREF_PAGE_LABEL), panel, preferenceTree, layoutWithLabel);
        PreferencePanelHelper.addTextAttrEditor((XmlKey)_keys[i].get(PREF_PAGE_ID), panel, preferenceTree, layoutWithLabel);
    }

    private static void addPrefListAttrCompBefore(XmlFile fileName, AbstractXmlPanelWrapper panel, XmlComponentWrapper preferenceTree, XmlLayoutOption layoutWithLabel) {
        int i = fileName.getIndex();
        PreferencePanelHelper.addTextAttrEditor((XmlKey)_keys[i].get(PREF_LIST_LABEL), panel, preferenceTree, layoutWithLabel);
        PreferencePanelHelper.addTextAttrEditor((XmlKey)_keys[i].get(PREF_LIST_ID), panel, preferenceTree, layoutWithLabel);
    }

    private static void addPrefListAttrCompAfter(XmlFile fileName, AbstractXmlPanelWrapper panel, XmlComponentWrapper preferenceTree, XmlLayoutOption layoutWithoutLabel) {
        PreferenceListTableEditor listValueEditor = new PreferenceListTableEditor();
        int i = fileName.getIndex();
        XmlComponentWrapper listValueTable = panel.createXmlComponentWrapper((XmlKey)_keys[i].get(PREF_VALUE)).setParent(preferenceTree).setPropertyEditor((Object)listValueEditor.setShowReorderableRowButtons(true).add(panel.createXmlComponentWrapper(FrameworkXmlKeys.XMLKEY_CUSTOM_PREF_LIST_DEFAULT).setPropertyEditor((Object)new XmlCheckBoxEditor().setRenderAsRadioButton(true).setShowLabel(false))).add((XmlComponentWrapper)panel.createXmlComponentWrapper((XmlKey)_keys[i].get(PREF_VALUE_NAME))).add((XmlComponentWrapper)panel.createXmlComponentWrapper((XmlKey)_keys[i].get(PREF_VALUE_VALUE))));
        ((PanelHelper)panel).addComponent(listValueTable, layoutWithoutLabel);
    }

    private static void addPrefNumberAttrCompBefore(XmlFile fileName, AbstractXmlPanelWrapper panel, XmlComponentWrapper preferenceTree, XmlLayoutOption layoutWithLabel) {
        int i = fileName.getIndex();
        PreferencePanelHelper.addTextAttrEditor((XmlKey)_keys[i].get(PREF_NUMBER_LABEL), panel, preferenceTree, layoutWithLabel);
        PreferencePanelHelper.addTextAttrEditor((XmlKey)_keys[i].get(PREF_NUMBER_ID), panel, preferenceTree, layoutWithLabel);
    }

    private static void addPrefNumberAttrCompAfter(XmlFile fileName, AbstractXmlPanelWrapper panel, XmlComponentWrapper preferenceTree, XmlLayoutOption layoutWithLabel) {
        int i = fileName.getIndex();
        PreferencePanelHelper.addTextAttrEditor((XmlKey)_keys[i].get(PREF_NUMBER_DEFAULT), panel, preferenceTree, layoutWithLabel);
    }

    private static void addPrefTextAttrCompBefore(XmlFile fileName, AbstractXmlPanelWrapper panel, XmlComponentWrapper preferenceTree, XmlLayoutOption layoutWithLabel) {
        int i = fileName.getIndex();
        PreferencePanelHelper.addTextAttrEditor((XmlKey)_keys[i].get(PREF_TEXT_LABEL), panel, preferenceTree, layoutWithLabel);
        PreferencePanelHelper.addTextAttrEditor((XmlKey)_keys[i].get(PREF_TEXT_ID), panel, preferenceTree, layoutWithLabel);
    }

    private static void addPrefTextAttrCompAfter(XmlFile fileName, AbstractXmlPanelWrapper panel, XmlComponentWrapper preferenceTree, XmlLayoutOption layoutWithLabel, XmlLayoutOption layoutWithoutLabel) {
        int i = fileName.getIndex();
        PreferencePanelHelper.addTextAttrEditor((XmlKey)_keys[i].get(PREF_TEXT_DEFAULT), panel, preferenceTree, layoutWithLabel);
        PreferencePanelHelper.addBooleanAttrEditor((XmlKey)_keys[i].get(PREF_TEXT_SECRET), panel, preferenceTree, layoutWithoutLabel);
    }

    private static void addTextAttrEditor(XmlKey xmlKey, AbstractXmlPanelWrapper panel, XmlComponentWrapper preferenceTree, XmlLayoutOption layout) {
        ((PanelHelper)panel).addComponent(panel.createXmlComponentWrapper(xmlKey).setParent(preferenceTree).setPropertyEditor((Object)new PrefTextAttributePropertyEditor()), layout);
    }

    private static void addBooleanAttrEditor(XmlKey xmlKey, AbstractXmlPanelWrapper panel, XmlComponentWrapper preferenceTree, XmlLayoutOption layout) {
        ((PanelHelper)panel).addComponent(panel.createXmlComponentWrapper(xmlKey).setParent(preferenceTree).setPropertyEditor((Object)new PrefBooleanAttributePropertyEditor()), layout);
    }

    static {
        _frameworkHashTable.put(PREFERENCES, FrameworkXmlKeys.XMLKEY_PREFERNCES);
        _featureHashTable.put(PREFERENCES, FrameworkXmlKeys.XMLKEY_PREFERNCES);
        _frameworkHashTable.put(PREF_GROUP, FrameworkXmlKeys.XMLKEY_PREFERNCE_GROUP);
        _featureHashTable.put(PREF_GROUP, FrameworkXmlKeys.XMLKEY_PREFERNCE_GROUP);
        _frameworkHashTable.put(PREF_PAGE, FrameworkXmlKeys.XMLKEY_PREFERNCE_PAGE);
        _featureHashTable.put(PREF_PAGE, FrameworkXmlKeys.XMLKEY_PREFERNCE_PAGE);
        _frameworkHashTable.put(PREF_BOOLEAN, FrameworkXmlKeys.XMLKEY_PREFERNCE_BOOLEAN);
        _featureHashTable.put(PREF_BOOLEAN, FrameworkXmlKeys.XMLKEY_PREFERNCE_BOOLEAN);
        _frameworkHashTable.put(PREF_LIST, FrameworkXmlKeys.XMLKEY_PREFERNCE_LIST);
        _featureHashTable.put(PREF_LIST, FrameworkXmlKeys.XMLKEY_PREFERNCE_LIST);
        _frameworkHashTable.put(PREF_NUMBER, FrameworkXmlKeys.XMLKEY_PREFERNCE_NUMBER);
        _featureHashTable.put(PREF_NUMBER, FrameworkXmlKeys.XMLKEY_PREFERNCE_NUMBER);
        _frameworkHashTable.put(PREF_TEXT, FrameworkXmlKeys.XMLKEY_PREFERNCE_TEXT);
        _featureHashTable.put(PREF_TEXT, FrameworkXmlKeys.XMLKEY_PREFERNCE_TEXT);
        _frameworkHashTable.put(PREF_VALUE, FrameworkXmlKeys.XMLKEY_PREFERNCE_VALUE);
        _featureHashTable.put(PREF_VALUE, FrameworkXmlKeys.XMLKEY_PREFERNCE_VALUE);
        _frameworkHashTable.put(PREF_BOOLEAN_LABEL, FrameworkXmlKeys.XMLKEY_PREF_BOOLEAN_ATTR_LABEL);
        _featureHashTable.put(PREF_BOOLEAN_LABEL, FeatureXmlKeys.XMLKEY_PREF_BOOLEAN_ATTR_LABEL);
        _frameworkHashTable.put(PREF_BOOLEAN_ID, FrameworkXmlKeys.XMLKEY_PREF_BOOLEAN_ATTR_ID);
        _featureHashTable.put(PREF_BOOLEAN_ID, FeatureXmlKeys.XMLKEY_PREF_BOOLEAN_ATTR_ID);
        _frameworkHashTable.put(PREF_BOOLEAN_DEFAULT, FrameworkXmlKeys.XMLKEY_PREF_BOOLEAN_ATTR_DEFAULT);
        _featureHashTable.put(PREF_BOOLEAN_DEFAULT, FeatureXmlKeys.XMLKEY_PREF_BOOLEAN_ATTR_DEFAULT);
        _frameworkHashTable.put(PREF_GROUP_LABEL, FrameworkXmlKeys.XMLKEY_PREF_GROUP_ATTR_LABEL);
        _featureHashTable.put(PREF_GROUP_LABEL, FeatureXmlKeys.XMLKEY_PREF_GROUP_ATTR_LABEL);
        _frameworkHashTable.put(PREF_GROUP_ID, FrameworkXmlKeys.XMLKEY_PREF_GROUP_ATTR_ID);
        _featureHashTable.put(PREF_GROUP_ID, FeatureXmlKeys.XMLKEY_PREF_GROUP_ATTR_ID);
        _frameworkHashTable.put(PREF_PAGE_LABEL, FrameworkXmlKeys.XMLKEY_PREF_PAGE_ATTR_LABEL);
        _featureHashTable.put(PREF_PAGE_LABEL, FeatureXmlKeys.XMLKEY_PREF_PAGE_ATTR_LABEL);
        _frameworkHashTable.put(PREF_PAGE_ID, FrameworkXmlKeys.XMLKEY_PREF_PAGE_ATTR_ID);
        _featureHashTable.put(PREF_PAGE_ID, FeatureXmlKeys.XMLKEY_PREF_PAGE_ATTR_ID);
        _frameworkHashTable.put(PREF_LIST_LABEL, FrameworkXmlKeys.XMLKEY_PREF_LIST_ATTR_LABEL);
        _featureHashTable.put(PREF_LIST_LABEL, FeatureXmlKeys.XMLKEY_PREF_LIST_ATTR_LABEL);
        _frameworkHashTable.put(PREF_LIST_ID, FrameworkXmlKeys.XMLKEY_PREF_LIST_ATTR_ID);
        _featureHashTable.put(PREF_LIST_ID, FeatureXmlKeys.XMLKEY_PREF_LIST_ATTR_ID);
        _frameworkHashTable.put(PREF_LIST_DEFAULT, FrameworkXmlKeys.XMLKEY_PREF_LIST_ATTR_DEFAULT);
        _featureHashTable.put(PREF_LIST_DEFAULT, FeatureXmlKeys.XMLKEY_PREF_LIST_ATTR_DEFAULT);
        _frameworkHashTable.put(PREF_VALUE_NAME, FrameworkXmlKeys.XMLKEY_PREF_VALUE_ATTR_NAME);
        _featureHashTable.put(PREF_VALUE_NAME, FeatureXmlKeys.XMLKEY_PREF_VALUE_ATTR_NAME);
        _frameworkHashTable.put(PREF_VALUE_VALUE, FrameworkXmlKeys.XMLKEY_PREF_VALUE_ATTR_VALUE);
        _featureHashTable.put(PREF_VALUE_VALUE, FeatureXmlKeys.XMLKEY_PREF_VALUE_ATTR_VALUE);
        _frameworkHashTable.put(PREF_NUMBER_LABEL, FrameworkXmlKeys.XMLKEY_PREF_NUMBER_ATTR_LABEL);
        _featureHashTable.put(PREF_NUMBER_LABEL, FeatureXmlKeys.XMLKEY_PREF_NUMBER_ATTR_LABEL);
        _frameworkHashTable.put(PREF_NUMBER_ID, FrameworkXmlKeys.XMLKEY_PREF_NUMBER_ATTR_ID);
        _featureHashTable.put(PREF_NUMBER_ID, FeatureXmlKeys.XMLKEY_PREF_NUMBER_ATTR_ID);
        _frameworkHashTable.put(PREF_NUMBER_DEFAULT, FrameworkXmlKeys.XMLKEY_PREF_NUMBER_ATTR_DEFAULT);
        _featureHashTable.put(PREF_NUMBER_DEFAULT, FeatureXmlKeys.XMLKEY_PREF_NUMBER_ATTR_DEFAULT);
        _frameworkHashTable.put(PREF_TEXT_LABEL, FrameworkXmlKeys.XMLKEY_PREF_TEXT_ATTR_LABEL);
        _featureHashTable.put(PREF_TEXT_LABEL, FeatureXmlKeys.XMLKEY_PREF_TEXT_ATTR_LABEL);
        _frameworkHashTable.put(PREF_TEXT_ID, FrameworkXmlKeys.XMLKEY_PREF_TEXT_ATTR_ID);
        _featureHashTable.put(PREF_TEXT_ID, FeatureXmlKeys.XMLKEY_PREF_TEXT_ATTR_ID);
        _frameworkHashTable.put(PREF_TEXT_DEFAULT, FrameworkXmlKeys.XMLKEY_PREF_TEXT_ATTR_DEFAULT);
        _featureHashTable.put(PREF_TEXT_DEFAULT, FeatureXmlKeys.XMLKEY_PREF_TEXT_ATTR_DEFAULT);
        _frameworkHashTable.put(PREF_TEXT_SECRET, FrameworkXmlKeys.XMLKEY_PREF_TEXT_ATTR_SECRET);
        _featureHashTable.put(PREF_TEXT_SECRET, FeatureXmlKeys.XMLKEY_PREF_TEXT_ATTR_SECRET);
        _frameworkHashTable.put(PREF_TYPE, FrameworkXmlKeys.XMLKEY_CUSTOM_PREF_TYPE);
        _featureHashTable.put(PREF_TYPE, FrameworkXmlKeys.XMLKEY_CUSTOM_PREF_TYPE);
        PreferencePanelHelper._prefTreeUsage[0] = FrameworkXmlEditorConstants.PREFERENCE_TREE_USAGE;
        PreferencePanelHelper._prefTreeUsage[1] = FeatureXmlConstants.FEATURE_PREFERENCE_TREE_USAGE;
    }

    private static class PreferenceNodeFilter
    implements NodeFilter {
        private PreferenceNodeFilter() {
        }

        @Override
        public short acceptNode(Node node) {
            String localName = node.getLocalName();
            if (localName != null && (localName.equals(FrameworkXmlKeys.XMLKEY_PREFERNCE_BOOLEAN.getLocalName()) || localName.equals(FrameworkXmlKeys.XMLKEY_PREFERNCE_GROUP.getLocalName()) || localName.equals(FrameworkXmlKeys.XMLKEY_PREFERNCE_PAGE.getLocalName()) || localName.equals(FrameworkXmlKeys.XMLKEY_PREFERNCE_LIST.getLocalName()) || localName.equals(FrameworkXmlKeys.XMLKEY_PREFERNCE_NUMBER.getLocalName()) || localName.equals(FrameworkXmlKeys.XMLKEY_PREFERNCE_TEXT.getLocalName()))) {
                return 1;
            }
            return 2;
        }
    }

    private static enum XmlFile {
        APPLICATION(0),
        FEATURE(1);

        private int fileIndex;

        private XmlFile(int fileIndex) {
            this.fileIndex = fileIndex;
        }

        public int getIndex() {
            return this.fileIndex;
        }
    }
}

