/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.editor.preference;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import oracle.adfmf.framework.dt.editor.preference.PrefXmlTreePropertyEditor;
import oracle.adfmf.framework.dt.editor.preference.PreferencePanelHelper;
import oracle.bali.xml.gui.swing.xmlComponent.AbstractXmlTableEditor;
import oracle.bali.xml.gui.swing.xmlComponent.XmlTableEditor;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.task.FixedNameTransactionTask;
import oracle.bali.xml.model.task.ReadOnlyTask;
import oracle.javatools.icons.OracleIcons;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PreferenceListTableEditor
extends XmlTableEditor {
    private static final int _DEFAULT_COLUMN_INDEX = 0;
    private static final int _VALUE_COLUMN_INDEX = 2;

    public Component getXmlComponent() {
        if (this.getTablePanel() != null) {
            this.getTableModel().fireTableDataChanged();
            this.updateAddDeleteButtons();
            return this.getTablePanel();
        }
        return super.getXmlComponent();
    }

    public AbstractXmlTableEditor setEnabled(boolean enabled) {
        PrefXmlTreePropertyEditor parentTreeEditor = (PrefXmlTreePropertyEditor)this.getXmlComponentWrapper().getParent().getPropertyEditor();
        String currentType = parentTreeEditor.getCurrentType();
        boolean visible = "preferenceList".equals(currentType);
        PreferencePanelHelper.setComponentVisible(this.getXmlComponent(), visible);
        return super.setEnabled(enabled);
    }

    protected void setTableCellEditors() {
        super.setTableCellEditors();
        TableColumn defaultColumn = this.getTable().getColumnModel().getColumn(0);
        defaultColumn.setCellEditor(new PreferenceListDefaultEditor());
    }

    public Object getCellValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            String defaultValue = (String)this.getPrefListDefault();
            if (defaultValue == null || defaultValue.trim().isEmpty()) {
                return "false";
            }
            String rowValue = (String)this.getPrefValueAttrValue(rowIndex);
            if (rowValue != null && rowValue.equals(defaultValue)) {
                return "true";
            }
            return "false";
        }
        return super.getCellValueAt(rowIndex, columnIndex);
    }

    public void setCellValueAt(Object value, int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            if (((Boolean)value).booleanValue()) {
                this.setPrefListDefault((String)this.getCellValueAt(rowIndex, 2));
            } else {
                String defaultValue = (String)this.getPrefListDefault();
                String rowValue = (String)this.getCellValueAt(rowIndex, 2);
                if (defaultValue != null && rowValue != null && defaultValue.equals(rowValue)) {
                    this.setPrefListDefault("");
                }
            }
            return;
        }
        super.setCellValueAt(value, rowIndex, columnIndex);
    }

    public Action createDeleteAction() {
        final Action deleteRow = super.createDeleteAction();
        AbstractAction deleteRowWithListDefault = new AbstractAction("", OracleIcons.getIcon((String)"delete.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                Node selectedNode;
                int row = PreferenceListTableEditor.this.getTable().getSelectedRow();
                String value = null;
                if (row != -1 && (selectedNode = (Node)PreferenceListTableEditor.this.getXmlComponentModel().getChild((Object)PreferenceListTableEditor.this.getXmlComponentModel().getParentNode(), row)) != null) {
                    value = ((Element)selectedNode).getAttributeNS(null, "value");
                }
                deleteRow.actionPerformed(e);
                if (PreferenceListTableEditor.this.getTableModel().getRowCount() == 0 || value != null && value.trim().length() > 0 && value.equals(PreferenceListTableEditor.this.getPrefListDefault())) {
                    PreferenceListTableEditor.this.setPrefListDefault("");
                }
            }
        };
        return deleteRowWithListDefault;
    }

    private Object getPrefListDefault() {
        return new ReadOnlyTask<Object>(){

            protected Object runImpl(AbstractModel model) {
                Element listNode = (Element)PreferenceListTableEditor.this.getXmlComponentModel().getParentXmlComponentModel().getNode();
                if (listNode != null) {
                    return listNode.getAttributeNS(null, "default");
                }
                return null;
            }
        }.run((AbstractModel)this.getXmlComponentModel().getView());
    }

    private void setPrefListDefault(final String value) {
        new FixedNameTransactionTask("Updating Default value"){

            protected void performTask(AbstractModel model) throws XmlCommitException {
                Element listNode = (Element)PreferenceListTableEditor.this.getXmlComponentModel().getParentXmlComponentModel().getNode();
                if (listNode != null) {
                    if (value != null && value.trim().length() > 0) {
                        listNode.setAttributeNS(null, "default", value);
                    } else {
                        listNode.removeAttributeNS(null, "default");
                    }
                }
            }
        }.run((AbstractModel)this.getXmlComponentModel().getView());
    }

    private Object getPrefValueAttrValue(final int rowIndex) {
        return new ReadOnlyTask<Object>(){

            protected Object runImpl(AbstractModel model) {
                Element elem = (Element)PreferenceListTableEditor.this.getXmlComponentModel().getParentXmlComponentModel().getNode().getChildNodes().item(rowIndex);
                if (elem == null) {
                    return null;
                }
                return elem.getAttributeNS(null, "value");
            }
        }.run((AbstractModel)this.getXmlComponentModel().getView());
    }

    private static class PreferenceListDefaultEditor
    extends DefaultCellEditor {
        public PreferenceListDefaultEditor() {
            super(new JCheckBox());
            this.renderAsRadioButton(new JRadioButton());
        }

        private void renderAsRadioButton(final JRadioButton radioButton) {
            this.editorComponent = radioButton;
            this.delegate = new DefaultCellEditor.EditorDelegate(){

                @Override
                public void setValue(Object value) {
                    boolean selected = false;
                    if (value instanceof Boolean) {
                        selected = (Boolean)value;
                    } else if (value instanceof String) {
                        selected = value.equals("true");
                    }
                    radioButton.setSelected(selected);
                }

                @Override
                public Object getCellEditorValue() {
                    return radioButton.isSelected();
                }
            };
            radioButton.addActionListener(this.delegate);
            radioButton.setRequestFocusEnabled(false);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.delegate.setValue(value);
            TableCellRenderer renderer = table.getCellRenderer(row, column);
            Component c = renderer.getTableCellRendererComponent(table, value, isSelected, true, row, column);
            if (c != null) {
                this.editorComponent.setOpaque(true);
                this.editorComponent.setBackground(c.getBackground());
                if (c instanceof JComponent) {
                    this.editorComponent.setBorder(((JComponent)c).getBorder());
                }
            } else {
                this.editorComponent.setOpaque(false);
            }
            return this.editorComponent;
        }
    }
}

