/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.editor.preference;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyEditor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComboBox;
import oracle.adfmf.framework.dt.editor.preference.PrefXmlTreePropertyEditor;
import oracle.adfmf.framework.dt.editor.preference.PreferencePanelHelper;
import oracle.bali.xml.gui.base.xmlComponent.XmlComponentPropertyEditor;
import oracle.bali.xml.gui.swing.xmlComponent.AbstractXmlComboBoxEditor;

public class PrefTypeComboBoxEditor
extends AbstractXmlComboBoxEditor<String>
implements ItemListener {
    private static final String PREF_BOOLEAN = "Boolean";
    private static final String PREF_GROUP = "Group";
    private static final String PREF_LIST = "List";
    private static final String PREF_NUMBER = "Number";
    private static final String PREF_PAGE = "Page";
    private static final String PREF_TEXT = "Text";
    private static final Map<String, String> _elementMap;
    private String _currentValue = null;

    public PrefTypeComboBoxEditor(PropertyEditor propertyEditor) {
        super(propertyEditor);
    }

    public void addItems() {
        this.getComboBoxModel().asList().addAll(_elementMap.values());
        ((JComboBox)this.getXmlComponent()).addItemListener(this);
    }

    public XmlComponentPropertyEditor setEnabled(boolean enabled) {
        PrefXmlTreePropertyEditor parentTreeEditor = (PrefXmlTreePropertyEditor)this.getXmlComponentWrapper().getParent().getPropertyEditor();
        String currentType = parentTreeEditor.getCurrentType();
        boolean visible = false;
        if (this.setSelectedType(currentType)) {
            visible = true;
            if ("preferenceGroup".equals(currentType)) {
                enabled = false;
            }
        }
        PreferencePanelHelper.setComponentVisible(this.getXmlComponent(), visible);
        return super.setEnabled(enabled);
    }

    private boolean setSelectedType(String currentType) {
        String selectItem;
        if (currentType != null && (selectItem = _elementMap.get(currentType)) != null) {
            if (PREF_GROUP.equals(selectItem) && !this.getComboBoxModel().asList().contains(PREF_GROUP)) {
                this.getComboBoxModel().addElement((Object)PREF_GROUP);
            } else {
                this.getComboBoxModel().asList().remove(PREF_GROUP);
            }
            this._currentValue = selectItem;
            this.getComboBoxModel().setSelectedItem((Object)this._currentValue);
            return true;
        }
        return false;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        String newValue;
        if (e.getStateChange() == 1 && !(newValue = (String)e.getItem()).equals(this._currentValue)) {
            String currentType = this.getElmentName(this._currentValue);
            String newType = this.getElmentName(newValue);
            PrefXmlTreePropertyEditor parentTreeEditor = (PrefXmlTreePropertyEditor)this.getXmlComponentWrapper().getParent().getPropertyEditor();
            parentTreeEditor.changePreferenceType(currentType, newType);
            this._currentValue = newValue;
        }
    }

    private final String getElmentName(String displayName) {
        for (String elementName : _elementMap.keySet()) {
            if (!_elementMap.get(elementName).equals(displayName)) continue;
            return elementName;
        }
        return null;
    }

    static {
        HashMap<String, String> eMap = new HashMap<String, String>();
        eMap.put("preferenceBoolean", PREF_BOOLEAN);
        eMap.put("preferenceGroup", PREF_GROUP);
        eMap.put("preferenceList", PREF_LIST);
        eMap.put("preferenceNumber", PREF_NUMBER);
        eMap.put("preferencePage", PREF_PAGE);
        eMap.put("preferenceText", PREF_TEXT);
        _elementMap = Collections.unmodifiableMap(eMap);
    }
}

