/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.editor.preference;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyEditor;
import javax.swing.JComboBox;
import oracle.adfmf.framework.dt.editor.preference.PrefXmlTreePropertyEditor;
import oracle.adfmf.framework.dt.editor.preference.PreferencePanelHelper;
import oracle.bali.xml.gui.base.xmlComponent.XmlComponentPropertyEditor;
import oracle.bali.xml.gui.swing.xmlComponent.AbstractXmlComboBoxEditor;

public class PrefBooleanDefaultAttrComboBoxEditor
extends AbstractXmlComboBoxEditor<String>
implements ItemListener {
    private static final String DEFAULT_FALSE = "<default> (false)";
    private String _currentValue = null;
    private boolean _updateXmlComponentFlag = false;

    public PrefBooleanDefaultAttrComboBoxEditor(PropertyEditor propertyEditor) {
        super(propertyEditor);
    }

    public JComboBox getXmlComponent() {
        JComboBox comboBox = (JComboBox)super.getXmlComponent();
        comboBox.addItemListener(this);
        this._currentValue = (String)comboBox.getSelectedItem();
        return comboBox;
    }

    public void addItems() {
        this.getComboBoxModel().asList().add(DEFAULT_FALSE);
        this.getComboBoxModel().asList().add("false");
        this.getComboBoxModel().asList().add("true");
    }

    public XmlComponentPropertyEditor setEnabled(boolean enabled) {
        PrefXmlTreePropertyEditor parentTreeEditor = (PrefXmlTreePropertyEditor)this.getXmlComponentWrapper().getParent().getPropertyEditor();
        String currentType = parentTreeEditor.getCurrentType();
        Boolean visible = this.getXmlComponentModel().getXmlKey().getElementQName().getName().equals(currentType);
        PreferencePanelHelper.setComponentVisible(this.getXmlComponent(), visible);
        return super.setEnabled(enabled);
    }

    public void updatePropertyValueFromXmlComponent() {
        if (this.getComboBox().getSelectedItem() != null && DEFAULT_FALSE.equals(this.getComboBox().getSelectedItem())) {
            this.setValue("");
        } else {
            super.updatePropertyValueFromXmlComponent();
        }
    }

    public void updateXmlComponentFromPropertyValue() {
        this._updateXmlComponentFlag = true;
        if ("true".equals(this.getAsText()) || "false".equals(this.getAsText())) {
            super.updateXmlComponentFromPropertyValue();
        } else {
            this.getComboBox().setSelectedItem(DEFAULT_FALSE);
        }
        this._updateXmlComponentFlag = false;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (!this._updateXmlComponentFlag) {
            String newValue;
            if (e.getStateChange() == 1 && !(newValue = (String)e.getItem()).equals(this._currentValue)) {
                this.updatePropertyValueFromXmlComponent();
                this.getXmlComponentWrapper().updateModelFromXmlComponent();
                this.getXmlComponentWrapper().getXmlComponentModel().setSelection();
                this._currentValue = newValue;
            }
        }
    }
}

