/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.editor.feature;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.awt.image.ImageObserver;
import java.beans.PropertyEditor;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.TransferHandler;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import oracle.adfmf.common.util.McAppUtils;
import oracle.adfmf.framework.dt.editor.EditorMetadataMethods;
import oracle.adfmf.framework.dt.editor.feature.FeatureImageEditor;
import oracle.bali.xml.gui.base.xmlComponent.AbstractXmlPropertyEditorDecorator;
import oracle.bali.xml.gui.base.xmlComponent.XmlComponentModel;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.gui.swing.xmlComponent.XmlTextComponentKeyAdapter;
import oracle.bali.xml.model.XmlContext;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.Colors;
import oracle.javatools.ui.plaf.IconicButtonUI;
import oracle.jdevimpl.webapp.util.ImageLoader;
import oracle.jdevimpl.webapp.util.ImageLoaderListener;
import sun.beans.editors.StringEditor;

public class ImageAttributePropertyEditor
extends AbstractXmlPropertyEditorDecorator<String>
implements ImageLoaderListener,
ActionListener {
    private final ImageIcon s_brokenIcon = new ImageIcon(this.getClass().getClassLoader().getResource("oracle/adfmf/framework/dt/editor/images/broken.png"));
    private static final int IMAGE_BOX_WIDTH = 48;
    private static final int IMAGE_BOX_HEIGHT = 48;
    private static final int PREFERRED_TEXTBOX_WIDTH_PX = 160;
    private static final int BORDER_HEIGHT = 2;
    private final XmlContext m_xmlContext;
    private ImageLoader m_imageLoader;
    private JLabel m_label;
    private JTextPane m_noImageLabel;
    private ImageIcon m_image;
    private JButton m_button;
    protected JTextField m_field;
    private JLabel m_hintText;
    private JPanel m_imagePanel;
    private JPanel m_panel = null;

    public ImageAttributePropertyEditor(XmlContext xmlContext) {
        super((PropertyEditor)new StringEditor());
        this.m_xmlContext = xmlContext;
    }

    public Component getXmlComponent() {
        if (this.m_panel == null) {
            XmlComponentModel model = this.getXmlComponentModel();
            this.m_panel = new JPanel();
            this.m_panel.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
            GroupLayout layout = new GroupLayout(this.m_panel);
            this.m_panel.setLayout(layout);
            layout.setAutoCreateGaps(true);
            layout.setAutoCreateContainerGaps(false);
            this.m_image = new ImageIcon();
            this.m_imagePanel = new JPanel(new BorderLayout(), true);
            this.m_imagePanel.add((Component)new JLabel(this.m_image), "Center");
            this.m_imagePanel.setBorder(BorderFactory.createLineBorder(Colors.HINT_TEXT));
            this.m_imagePanel.setMinimumSize(new Dimension(48, 48));
            this.m_imagePanel.setPreferredSize(new Dimension(48, 48));
            this.m_imagePanel.setMaximumSize(new Dimension(48, 48));
            this.m_noImageLabel = new JTextPane();
            SimpleAttributeSet attrs = new SimpleAttributeSet();
            StyleConstants.setAlignment(attrs, 1);
            StyledDocument doc = (StyledDocument)this.m_noImageLabel.getDocument();
            try {
                doc.insertString(0, EditorMetadataMethods.get("NO_IMAGE_SPECIFIED"), attrs);
                doc.setParagraphAttributes(0, doc.getLength(), attrs, false);
            }
            catch (BadLocationException e) {
                // empty catch block
            }
            this.m_noImageLabel.setBorder(BorderFactory.createEmptyBorder());
            this.m_noImageLabel.setEnabled(false);
            this.m_label = new JLabel(model.getXmlMetadataResolver().getShortDisplayName(model.getXmlKey()) + ":");
            this.m_field = new JTextField();
            this.m_field.setTransferHandler(new MyTransferHandler(1));
            this.m_field.addKeyListener((KeyListener)new XmlTextComponentKeyAdapter((JTextComponent)this.m_field, this.getXmlComponentWrapper()));
            this.m_button = new JButton(OracleIcons.getIcon((String)"lov.png"));
            this.m_button.addActionListener(this);
            this.m_button.setToolTipText(EditorMetadataMethods.get("BROWSE_FILE"));
            IconicButtonUI.install((AbstractButton)this.m_button);
            JPanel hintPanel = this.createHintPanel();
            layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(this.m_imagePanel).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.m_label).addComponent(this.m_field, -1, 160, Short.MAX_VALUE).addGap(6).addComponent(this.m_button)).addComponent(hintPanel)));
            layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.m_imagePanel).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.m_label).addComponent(this.m_field).addComponent(this.m_button)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(hintPanel)))));
        }
        this.updateXmlComponentFromPropertyValue();
        return this.m_panel;
    }

    protected JPanel createHintPanel() {
        JPanel hintPanel = new JPanel();
        hintPanel.setLayout(new BoxLayout(hintPanel, 3));
        this.m_hintText = new JLabel();
        this.m_hintText.setForeground(Colors.HINT_TEXT);
        hintPanel.add(this.m_hintText);
        return hintPanel;
    }

    public void updateXmlComponentFromPropertyValue() {
        String value = (String)this.getValue();
        this.m_field.setText(value);
        this.loadImage(value);
    }

    protected void loadImage(String value) {
        if (value == null || value.isEmpty()) {
            this.m_imagePanel.removeAll();
            this.m_imagePanel.add((Component)this.m_noImageLabel, "Center");
            this.m_hintText.setText("");
        } else {
            URL imageURL = this.getValueAsURL(value);
            this.m_imagePanel.removeAll();
            this.m_imagePanel.add((Component)new JLabel(this.m_image), "Center");
            if (URLFileSystem.exists((URL)imageURL)) {
                this.m_imageLoader = new ImageLoader(this.getValueAsURL(value), 48, 48);
                this.m_imageLoader.registerImageLoaderListener((ImageLoaderListener)this);
                this.m_imageLoader.load();
            } else {
                this.m_image.setImage(this.s_brokenIcon.getImage());
                this.m_hintText.setText(EditorMetadataMethods.get("IMAGE_NOT_EXIST"));
            }
        }
    }

    public void updatePropertyValueFromXmlComponent() {
        this.setValue(this.m_field.getText());
    }

    private URL getValueAsURL(String value) {
        if (this.m_xmlContext != null && value != null) {
            URI uri = null;
            try {
                uri = new URI(value);
            }
            catch (URISyntaxException e) {
                uri = null;
            }
            if (uri != null && uri.isAbsolute()) {
                return URLFactory.newURL((String)uri.toString());
            }
            return this.getURLForRelativeImagePath(value);
        }
        return null;
    }

    public void setAsURL(URL url) {
        if (this.m_xmlContext != null) {
            if ("file".equals(url.getProtocol())) {
                this.setValue(this.getRelativeImagePathForURL(url));
            } else {
                this.setValue(url.toString());
            }
            this.getXmlComponentWrapper().updateModelFromXmlComponent();
        }
    }

    public void addChildFocusListener(FocusListener focusListener) {
        this.m_field.addFocusListener(focusListener);
        this.m_button.addFocusListener(focusListener);
    }

    public void removeChildFocusListener(FocusListener focusListener) {
        this.m_field.removeFocusListener(focusListener);
        this.m_button.removeFocusListener(focusListener);
    }

    public ImageAttributePropertyEditor setEnabled(boolean enabled) {
        this.m_field.setEnabled(enabled);
        this.m_hintText.setEnabled(enabled);
        this.m_button.setEnabled(enabled);
        this.m_panel.setEnabled(enabled);
        return this;
    }

    public void imageLoadUpdate(int status) {
        Image newImage;
        if (status == 1 && (newImage = this.m_imageLoader.getImage()) != null) {
            int height = newImage.getHeight((ImageObserver)this.m_imageLoader);
            int width = newImage.getWidth((ImageObserver)this.m_imageLoader);
            if (width > 48 || height > 48) {
                this.m_image.setImage(newImage.getScaledInstance(48, 48, 0));
            } else {
                this.m_image.setImage(newImage);
            }
            this.m_hintText.setText(width + " x " + height);
            this.m_panel.repaint();
            return;
        }
        if (status == 4 || status == 5 || status == 1) {
            this.m_image.setImage(this.s_brokenIcon.getImage());
            this.m_hintText.setText(EditorMetadataMethods.get("IMAGE_LOAD_ERR"));
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        URL selectedUrl;
        URLChooser urlChooser;
        int iStatus;
        if (event.getSource() == this.m_button && this.m_xmlContext instanceof JDevXmlContext && (iStatus = (urlChooser = FeatureImageEditor.getURLChooser((JDevXmlContext)this.m_xmlContext)).showOpenDialog(this.getXmlComponent())) == 0 && (selectedUrl = urlChooser.getSelectedURL()) != null) {
            this.setAsURL(selectedUrl);
        }
    }

    protected boolean isSupportedFileType(String filename) {
        return McAppUtils.isImageFile(filename);
    }

    private String getRelativeImagePathForURL(URL url) {
        String projectPath = this.m_xmlContext.getRelativePathForURL(url);
        if (projectPath.indexOf("../../public_html/") == 0) {
            return projectPath.substring("../../public_html/".length());
        }
        return projectPath;
    }

    private URL getURLForRelativeImagePath(String value) {
        String projectPath = "../../public_html/" + value;
        return this.m_xmlContext.getURLForRelativePath(projectPath);
    }

    private class MyTransferHandler
    extends TransferHandler {
        private final int _action;

        public MyTransferHandler(int action) {
            this._action = action;
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            boolean actionSupported;
            if (!support.isDrop()) {
                return false;
            }
            if (!support.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                return false;
            }
            boolean bl = actionSupported = (this._action & support.getSourceDropActions()) == this._action;
            if (actionSupported) {
                support.setDropAction(this._action);
            }
            return actionSupported;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            String filename;
            if (!this.canImport(support)) {
                return false;
            }
            try {
                filename = (String)support.getTransferable().getTransferData(DataFlavor.stringFlavor);
                if (!ImageAttributePropertyEditor.this.isSupportedFileType(filename)) {
                    return false;
                }
            }
            catch (UnsupportedFlavorException e) {
                return false;
            }
            catch (IOException e) {
                return false;
            }
            URL fileURL = URLFactory.newURL((String)filename);
            ImageAttributePropertyEditor.this.setAsURL(fileURL);
            return true;
        }
    }
}

