/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.editor.feature;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.ide.Context;
import oracle.ide.config.DTCache;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.Wizard;
import oracle.jdeveloper.builder.file.FileBuilderModel;
import oracle.jdevimpl.webapp.html.wizards.HtmlFusionWizard;

public class HtmlFileWizard
extends HtmlFusionWizard {
    private final Logger _logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    private URL _fileURL = null;

    protected void saveSettings(Namespace namespace, DTCache dtcache) {
        super.saveSettings(namespace, dtcache);
        FileBuilderModel fileBuilderModel = (FileBuilderModel)namespace.get("AbstractWebAppTraversablePanel.FILE_BUILDER_MODEL_KEY");
        if (fileBuilderModel != null) {
            this._fileURL = fileBuilderModel.getURL();
        }
    }

    protected URL getFileURL() {
        return this._fileURL;
    }

    protected HtmlFusionWizard.HtmlFileBuilderModel getHtmlFileBuilderModel(Context context, URL defaultURL, Namespace ns) {
        return new ADFMobileHtmlFileBuilderModel(context, defaultURL, ns);
    }

    private final class ADFMobileHtmlFileBuilderModel
    extends HtmlFusionWizard.HtmlFileBuilderModel {
        private ADFMobileHtmlFileBuilderModel(Context context, URL url, Namespace namespace) {
            super((HtmlFusionWizard)HtmlFileWizard.this, context, url, namespace);
        }

        protected void initializeFromContext(Context ctx) {
            super.initializeFromContext(ctx);
            String[] wizardParameters = Wizard.getLegacyParams((Context)ctx);
            try {
                URL fileURL;
                if (wizardParameters != null && wizardParameters.length > 0 && URLFileSystem.isDirectoryPath((URL)(fileURL = new URL(wizardParameters[0])))) {
                    this.setDirectory(fileURL);
                }
            }
            catch (MalformedURLException e) {
                HtmlFileWizard.this._logger.log(Level.WARNING, MobileResourceUtils.getMsg("ADF-MBL-10011", wizardParameters[0], e));
            }
        }
    }
}

