/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.editor.feature;

import java.net.URL;
import oracle.adfmf.common.util.McAppUtils;
import oracle.adfmf.framework.dt.editor.EditorMetadataMethods;
import oracle.adfmf.framework.dt.editor.feature.FiletypeAttributePropertyEditor;
import oracle.adfmf.framework.dt.editor.feature.HtmlFileWizard;
import oracle.bali.xml.gui.base.xmlComponent.XmlComponentPropertyEditor;
import oracle.bali.xml.model.XmlContext;
import oracle.ide.Context;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLFilter;

public class HtmlAttributePropertyEditor
extends FiletypeAttributePropertyEditor {
    private static final String[] _HTML_EXT = new String[]{".html", ".htm"};

    public HtmlAttributePropertyEditor(XmlContext xmlContext) {
        super(xmlContext);
    }

    @Override
    public XmlComponentPropertyEditor setEnabled(boolean enabled) {
        super.featureLevelEnabled(enabled);
        super.setEnabled(enabled);
        return this;
    }

    @Override
    protected URLFilter getURLFilter() {
        if (super.getURLFilter() == null) {
            this.setURLFilter((URLFilter)new DefaultURLFilter(EditorMetadataMethods.get("HTML_PAGE"), _HTML_EXT));
        }
        return super.getURLFilter();
    }

    @Override
    protected boolean isSupportedFileType(String filename) {
        return McAppUtils.isHtmlFile(filename);
    }

    @Override
    protected URL popNewFileDialog() {
        boolean ok;
        HtmlFileWizard wizard = new HtmlFileWizard();
        Context context = this.getIdeContext();
        URL dirURL = this.getFeatureDirURL(context);
        if (dirURL != null) {
            String[] params = new String[]{dirURL.toString()};
            HtmlFileWizard.setLegacyParams((Context)context, (String[])params);
        }
        if (ok = wizard.invoke(context)) {
            return wizard.getFileURL();
        }
        return null;
    }
}

