/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.editor.feature;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.beans.PropertyEditor;
import java.io.IOException;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.TransferHandler;
import javax.swing.text.JTextComponent;
import oracle.adfmf.common.util.McAppUtils;
import oracle.adfmf.framework.dt.editor.EditorMetadataMethods;
import oracle.adfmf.framework.dt.editor.feature.ContentTableEditor;
import oracle.adfmf.framework.dt.editor.feature.HtmlFileWizard;
import oracle.bali.xml.gui.base.xmlComponent.AbstractXmlPropertyEditorDecorator;
import oracle.bali.xml.gui.base.xmlComponent.XmlComponentModel;
import oracle.bali.xml.gui.base.xmlComponent.XmlComponentPropertyEditor;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.gui.swing.xmlComponent.XmlTextComponentKeyAdapter;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.task.ReadOnlyTask;
import oracle.ide.Context;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.plaf.IconicButtonUI;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sun.beans.editors.StringEditor;

public class FiletypeAttributePropertyEditor
extends AbstractXmlPropertyEditorDecorator<String>
implements ActionListener {
    private boolean _isDialogOn = false;
    private final XmlContext _xmlContext;
    private JPanel _panel;
    private JButton _addButton = null;
    private JButton _button;
    private JTextField _field;
    private URLFilter _urlFilter = null;

    public FiletypeAttributePropertyEditor(XmlContext xmlContext) {
        super((PropertyEditor)new StringEditor());
        this._xmlContext = xmlContext;
    }

    public Component getXmlComponent() {
        if (this._panel == null) {
            this._panel = new JPanel();
            this._panel.setLayout(new BoxLayout(this._panel, 2));
            this._field = new JTextField();
            this._field.setTransferHandler(new MyTransferHandler(1));
            this._field.addKeyListener((KeyListener)new XmlTextComponentKeyAdapter((JTextComponent)this._field, this.getXmlComponentWrapper()));
            this._panel.add((Component)this._field, "Center");
            this._panel.add(Box.createHorizontalStrut(6));
            this._addButton = new JButton(OracleIcons.getIcon((String)"add.png"));
            this._addButton.addActionListener(this);
            this._addButton.setToolTipText(this.getAddButtonTooltip());
            IconicButtonUI.install((AbstractButton)this._addButton);
            this._panel.add((Component)this._addButton, "East");
            this._button = new JButton(OracleIcons.getIcon((String)"lov.png"));
            this._button.addActionListener(this);
            this._button.setToolTipText(this.getBrowseButtonTooltip());
            IconicButtonUI.install((AbstractButton)this._button);
            this._panel.add((Component)this._button, "East");
        }
        this.updateXmlComponentFromPropertyValue();
        return this._panel;
    }

    public void updateXmlComponentFromPropertyValue() {
        String value = (String)this.getValue();
        this._field.setText(value);
    }

    public void updatePropertyValueFromXmlComponent() {
        if (this.isDialogOn()) {
            return;
        }
        this.setValue(this._field.getText());
    }

    public XmlComponentPropertyEditor setEnabled(boolean enabled) {
        this._field.setEnabled(enabled);
        this._addButton.setEnabled(enabled);
        this._button.setEnabled(enabled);
        this._panel.setEnabled(enabled);
        return this;
    }

    public void addChildFocusListener(FocusListener focusListener) {
        this._field.addFocusListener(focusListener);
        this._addButton.addFocusListener(focusListener);
        this._button.addFocusListener(focusListener);
    }

    public void removeChildFocusListener(FocusListener focusListener) {
        this._field.removeFocusListener(focusListener);
        this._addButton.removeFocusListener(focusListener);
        this._button.removeFocusListener(focusListener);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.getBrowseButton()) {
            this.setDialogOn(true);
            URL url = this.popFileDialog();
            this.setDialogOn(false);
            this.setUrlValue(url);
        } else if (source == this.getAddButton()) {
            this.setDialogOn(true);
            URL url = this.popNewFileDialog();
            this.setDialogOn(false);
            this.setUrlValue(url);
        }
    }

    public String getAddButtonTooltip() {
        return EditorMetadataMethods.get("CREATE_FILE");
    }

    public String getBrowseButtonTooltip() {
        return EditorMetadataMethods.get("BROWSE_FILE");
    }

    protected void setVisible(boolean visible) {
        this._panel.setVisible(visible);
    }

    protected void featureLevelEnabled(boolean enabled) {
        ContentTableEditor parentTableEditor = (ContentTableEditor)this.getXmlComponentWrapper().getParent().getPropertyEditor();
        String currentType = parentTableEditor.getCurrentType(enabled);
        Boolean visible = this.getXmlComponentModel().getXmlKey().getElementQName().getName().equals(currentType);
        this.getXmlComponent().setVisible(visible);
        ((JComponent)((JComponent)this.getXmlComponent()).getClientProperty("labeledBy")).setVisible(visible);
    }

    protected JButton getBrowseButton() {
        return this._button;
    }

    protected JButton getAddButton() {
        return this._addButton;
    }

    protected URL popFileDialog() {
        if (this._xmlContext instanceof JDevXmlContext) {
            URL rootURL = this._xmlContext.getURLForRelativePath(this.getRelativePath());
            URLChooser urlChooser = DialogUtil.newURLChooser((URL)rootURL);
            urlChooser.setSelectionScope(0);
            urlChooser.setSelectionMode(0);
            urlChooser.removeShortcutButtons();
            if (this.getURLFilter() != null) {
                urlChooser.clearChooseableURLFilters();
                urlChooser.setURLFilter(this.getURLFilter());
            }
            urlChooser.setRoots(new URL[]{rootURL});
            int iStatus = urlChooser.showOpenDialog(this.getXmlComponent());
            if (iStatus == 0) {
                return urlChooser.getSelectedURL();
            }
        }
        return null;
    }

    protected URL popNewFileDialog() {
        HtmlFileWizard wizard = new HtmlFileWizard();
        Context context = this.getIdeContext();
        boolean ok = wizard.invoke(context);
        if (ok) {
            return wizard.getFileURL();
        }
        return null;
    }

    protected Context getIdeContext() {
        return ((JDevXmlContext)this._xmlContext).createContext();
    }

    protected URL getDefaultDirURL(Context context) {
        return McAppUtils.getHtmlRootDirectory(context.getProject());
    }

    protected void setURLFilter(URLFilter filter) {
        this._urlFilter = filter;
    }

    protected URLFilter getURLFilter() {
        return this._urlFilter;
    }

    protected String getRelativePathForURL(URL url) {
        String projectPath = this._xmlContext.getRelativePathForURL(url);
        if (projectPath.indexOf(this.getRelativePath()) == 0) {
            return projectPath.substring(this.getRelativePath().length());
        }
        return projectPath;
    }

    protected XmlContext getXmlContext() {
        return this._xmlContext;
    }

    protected String getRelativePath() {
        return "../../public_html/";
    }

    protected void setUrlValue(URL url) {
        if (url == null) {
            return;
        }
        if (this._xmlContext != null) {
            if ("file".equals(url.getProtocol())) {
                this.setValue(this.getRelativePathForURL(url));
            } else {
                this.setValue(url.toString());
            }
            this.getXmlComponentWrapper().updateModelFromXmlComponent();
        }
    }

    protected void setDialogOn(boolean dialogOn) {
        this._isDialogOn = dialogOn;
    }

    protected boolean isDialogOn() {
        return this._isDialogOn;
    }

    protected boolean isSupportedFileType(String filename) {
        return true;
    }

    protected URL getFeatureDirURL(Context context) {
        URL publicHtmlURL = McAppUtils.getHtmlRootDirectory(context.getProject());
        URL dirURL = null;
        String featureId = this.getParentFeatureId();
        if (featureId != null && featureId.trim().length() > 0) {
            dirURL = URLFactory.newURL((String)(publicHtmlURL.toString() + featureId.trim() + "/"));
        }
        if (URLFileSystem.exists(dirURL)) {
            return dirURL;
        }
        return publicHtmlURL;
    }

    protected String getParentFeatureId() {
        return (String)new ReadOnlyTask<String>(){

            protected String runImpl(AbstractModel model) {
                XmlComponentModel xmlComponentModel = FiletypeAttributePropertyEditor.this.getXmlComponentModel();
                XmlComponentModel parentXmlComponentModel = xmlComponentModel.getParentXmlComponentModel();
                if (parentXmlComponentModel == null) {
                    return null;
                }
                Node contentNode = parentXmlComponentModel.getNode();
                Node featureNode = null;
                if (contentNode != null) {
                    featureNode = contentNode.getParentNode();
                }
                if (featureNode != null) {
                    return ((Element)featureNode).getAttributeNS(null, "id");
                }
                return null;
            }
        }.run((AbstractModel)this.getXmlComponentModel().getView());
    }

    private class MyTransferHandler
    extends TransferHandler {
        private final int _action;

        public MyTransferHandler(int action) {
            this._action = action;
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            boolean actionSupported;
            if (!support.isDrop()) {
                return false;
            }
            if (!support.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                return false;
            }
            boolean bl = actionSupported = (this._action & support.getSourceDropActions()) == this._action;
            if (actionSupported) {
                support.setDropAction(this._action);
            }
            return actionSupported;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            String filename;
            if (!this.canImport(support)) {
                return false;
            }
            try {
                filename = (String)support.getTransferable().getTransferData(DataFlavor.stringFlavor);
                if (!FiletypeAttributePropertyEditor.this.isSupportedFileType(filename)) {
                    return false;
                }
            }
            catch (UnsupportedFlavorException e) {
                return false;
            }
            catch (IOException e) {
                return false;
            }
            URL fileURL = URLFactory.newURL((String)filename);
            FiletypeAttributePropertyEditor.this.setUrlValue(fileURL);
            return true;
        }
    }
}

