/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.editor.feature;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import oracle.adfmf.common.util.McAppUtils;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.editor.LabelledXmlTableEditor;
import oracle.adfmf.framework.dt.ide.FeatureBuilder;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.ide.Context;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;

public class FeatureTableEditor
extends LabelledXmlTableEditor {
    private static final int _COLUMN_NAME = 1;
    private static final int _COLUMN_ID = 0;

    public FeatureTableEditor(String label) {
        super(label);
    }

    public Action createAddAction() {
        AbstractAction addAction = new AbstractAction("", OracleIcons.getIcon((String)"add.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeatureBuilder w = new FeatureBuilder();
                Context context = Context.newIdeContext();
                boolean ok = w.invoke(context);
                if (ok) {
                    FeatureTableEditor.this.updateTableUIAfterRowInsert();
                }
            }
        };
        return addAction;
    }

    public Action createDeleteAction() {
        final Action action = super.createDeleteAction();
        AbstractAction deleteAction = new AbstractAction("", OracleIcons.getIcon((String)"delete.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object name = FeatureTableEditor.this.getTable().getValueAt(FeatureTableEditor.this.getTable().getSelectedRow(), 1);
                String featureName = "";
                if (name instanceof String) {
                    featureName = (String)name;
                }
                Object id = FeatureTableEditor.this.getTable().getValueAt(FeatureTableEditor.this.getTable().getSelectedRow(), 0);
                String featureId = "";
                if (id instanceof String) {
                    featureId = (String)id;
                }
                JCheckBox optionalCheckBox = new JCheckBox();
                Component component = FeatureTableEditor._createDialog(optionalCheckBox, featureName);
                boolean toDelete = MessageDialog.confirm((Component)FeatureTableEditor.this.getTablePanel(), (Object)component, (String)MobileResourceUtils.getText("CONFIRM_DELETE", featureName), null);
                if (toDelete) {
                    action.actionPerformed(e);
                    if (optionalCheckBox.isSelected()) {
                        McAppUtils.removeFeatureReference(FeatureTableEditor.this.getWorkspace(), featureId);
                    }
                }
            }
        };
        return deleteAction;
    }

    private static final Component _createDialog(JCheckBox box, String featureName) {
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout(0, 10));
        MultiLineLabel text = new MultiLineLabel();
        text.setTextWrapper(WordWrapper.getTextWrapper());
        text.setPreferredAspectRatio(5.0f);
        text.setText(MobileResourceUtils.getText("DELETE_FEATURE", featureName));
        p.add((Component)text, "Center");
        box.setSelected(true);
        box.setText(MobileResourceUtils.getText("DELETE_FEATURE_REF"));
        box.setMnemonic(MobileResourceUtils.getText("DELETE_FEATURE_REF_MNEMONIC").charAt(0));
        p.add((Component)box, "South");
        return p;
    }
}

