/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.editor.feature;

import java.util.Map;
import java.util.Set;
import oracle.adfmf.framework.dt.editor.SecureFeatureChangeManager;
import oracle.bali.xml.dom.NodeChangeDetails;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.event.XmlModelAdapter;
import oracle.ide.model.Workspace;
import org.w3c.dom.Node;

public class FeatureModelListener
extends XmlModelAdapter {
    private final Workspace _workspace;

    public FeatureModelListener(Workspace workspace) {
        this._workspace = workspace;
    }

    public void modelChanged(XmlModelEvent event) {
        if (this._isCredentialChanged(event)) {
            SecureFeatureChangeManager.getInstance().fireSecureFeatureChange(this._workspace);
        }
    }

    private boolean _isCredentialChanged(XmlModelEvent event) {
        if (event.matchesFlags(8)) {
            Set changedNodes;
            NodeChangeDetails changeDetails = event.getNodeChangeDetails();
            if (changeDetails == NodeChangeDetails.NO_DETAILS_AVAILABLE) {
                return true;
            }
            if (changeDetails != null && !(changedNodes = changeDetails.getChangedNodes()).isEmpty()) {
                for (Node changedNode : changedNodes) {
                    Map changeMap = changeDetails.getPriorAttributeValues(changedNode);
                    if (changeMap.get(QualifiedName.getQualifiedName((String)"credentials")) == null) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

