/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.editor.feature;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.adfmf.common.util.McAppUtils;
import oracle.adfmf.framework.dt.editor.feature.FeatureIdDeclaration;
import oracle.adfmf.framework.dt.editor.feature.WorkspaceLibrariesDependency;
import oracle.adfmf.framework.dt.ide.FeatureArchive;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.gui.jdev.audit.xdf.DependencyProvider;
import oracle.bali.xml.gui.jdev.dependency.XmlIndexReference;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.dependency.Declaration;
import oracle.bali.xml.model.dependency.DependencyContext;
import oracle.bali.xml.model.traversal.TraversalData;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.jdeveloper.audit.model.Dependency;
import oracle.jdeveloper.audit.model.FileDependency;

public class FeatureIdReference
extends XmlIndexReference
implements DependencyProvider {
    public static final String FEATURE_ID_REF_KEY = "ADF_MOBILE_FEATURE_ID_REF";
    private URL _declURL = null;
    private Project _declProject = null;
    private boolean _declFAR = false;

    public FeatureIdReference(XmlContext xmlContext, org.w3c.dom.Node node, int start, int end) {
        super(xmlContext, node, start, end);
    }

    public Declaration findDeclaration(DependencyContext context) {
        this._declURL = null;
        this._declFAR = false;
        Workspace workspace = Ide.getActiveWorkspace();
        List<Project> projects = McAppUtils.findProjectsWithFeatures(workspace);
        for (Project project : projects) {
            URL featureXmlUrl = McAppUtils.getProjectFeatureXmlUrl(project);
            Declaration decl = this._findDeclarationFromFeatureXml(context, featureXmlUrl);
            if (decl == null) continue;
            this._declURL = featureXmlUrl;
            this._declProject = project;
            return decl;
        }
        List<URL> farUrls = McAppUtils.getFeatureArchiveURLs(workspace);
        for (URL farUrl : farUrls) {
            FeatureArchive far = new FeatureArchive(farUrl);
            URL jarFeatureXmlUrl = far.getJarFeatureXmlUrl();
            Declaration decl = this._findDeclarationFromFeatureXml(context, jarFeatureXmlUrl);
            if (decl == null) continue;
            this._declFAR = true;
            return decl;
        }
        return null;
    }

    public boolean isReferenceFor(DependencyContext context, Declaration declaration) {
        if (declaration instanceof FeatureIdDeclaration) {
            FeatureIdDeclaration featureIdDecl = (FeatureIdDeclaration)declaration;
            if (this.getValue(context).equals(featureIdDecl.getReferenceValue(context))) {
                return true;
            }
        }
        return false;
    }

    public List<Dependency> getDependencies(Workspace workspace, Project project, boolean isBroken) {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        if (this._declFAR || isBroken) {
            dependencies.add(new WorkspaceLibrariesDependency(workspace));
        }
        if (this._declURL != null) {
            FileDependency dependency = new FileDependency(this._declURL, this._declProject, workspace);
            dependencies.add((Dependency)dependency);
        } else if (isBroken) {
            List<Project> projects = McAppUtils.findProjectsWithFeatures(workspace);
            for (Project proj : projects) {
                URL url = McAppUtils.getProjectFeatureXmlUrl(proj);
                if (url == null) continue;
                FileDependency dependency = new FileDependency(url, proj, workspace);
                dependencies.add((Dependency)dependency);
            }
        }
        return dependencies;
    }

    protected String getDisplayNameImpl(DependencyContext context) {
        return "Feature Id Ref: '" + this.getValue(context) + "'";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Declaration _findDeclarationFromFeatureXml(DependencyContext context, URL featureXmlUrl) {
        String value = this.getValue(context);
        Node node = null;
        try {
            node = NodeFactory.findOrCreate((URL)featureXmlUrl);
        }
        catch (Exception e) {
            node = null;
        }
        if (node != null) {
            Context ideContext = Context.newIdeContext((Node)node);
            Workspace ws = ideContext.getWorkspace();
            if (ws != null) {
                for (Project project : ws.projects()) {
                    if (!project.containsChild((Element)node)) continue;
                    ideContext.setProject(project);
                    break;
                }
            }
            JDevXmlContext xmlContext = JDevXmlContext.getXmlContext((Context)ideContext);
            XmlModel model = xmlContext.getModel();
            model.acquireReadLock();
            try {
                String decl;
                HashMap map;
                TraversalData data = context.getTraversalData(model.getContext());
                if (data.containsKey((Object)"ADF_MOBILE_FEATURE_ID_DECLS") && (map = (HashMap)data.get((Object)"ADF_MOBILE_FEATURE_ID_DECLS")).containsKey(decl = value)) {
                    Declaration declaration = (Declaration)map.get(decl);
                    return declaration;
                }
            }
            finally {
                model.releaseReadLock();
            }
        }
        return null;
    }
}

