/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.editor.feature;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyEditor;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.adfmf.framework.dt.editor.EditorMetadataMethods;
import oracle.bali.xml.gui.base.xmlComponent.AbstractXmlPropertyEditorDecorator;
import oracle.bali.xml.gui.base.xmlComponent.XmlComponentPropertyEditor;
import sun.beans.editors.StringEditor;

public class CredentialPropertyEditor
extends AbstractXmlPropertyEditorDecorator<String> {
    private static final int _BORDER_LEFT = 12;
    private static final int _BORDER_WIDTH = 2;
    private JPanel _panel;
    private JPanel _subPanel;
    private JCheckBox _checkBox;
    private JLabel _label;
    private JComboBox _comboBox;
    private String _comboValue;
    private boolean _setSelectedCalled = false;

    public CredentialPropertyEditor() {
        super((PropertyEditor)new StringEditor());
    }

    public Component getXmlComponent() {
        if (this._panel == null) {
            this._panel = new JPanel();
            this._panel.setLayout(new BoxLayout(this._panel, 3));
            this._checkBox = new JCheckBox(){

                @Override
                public void setSelected(boolean b) {
                    CredentialPropertyEditor.this._setSelectedCalled = true;
                    super.setSelected(b);
                    CredentialPropertyEditor.this._setSelectedCalled = false;
                }
            };
            this._checkBox.setAlignmentX(0.0f);
            this._checkBox.setText(EditorMetadataMethods.get("FEATURE_SECURITY_LABEL"));
            this._checkBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (!CredentialPropertyEditor.this._setSelectedCalled) {
                        CredentialPropertyEditor.this.getXmlComponentWrapper().updateModelFromXmlComponent();
                    }
                }
            });
            this._panel.add(this._checkBox);
            this._subPanel = new JPanel();
            this._subPanel.setBorder(BorderFactory.createEmptyBorder(2, 12, 2, 2));
            this._subPanel.setAlignmentX(0.0f);
            this._subPanel.setLayout(new FlowLayout(0));
            this._label = new JLabel(EditorMetadataMethods.get("AUTHENTICATION_LABEL") + ":");
            this._subPanel.add(this._label);
            this._comboBox = new JComboBox<String>(new String[]{"remote", "local"});
            this._comboValue = (String)this._comboBox.getSelectedItem();
            this._comboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    String newValue = (String)CredentialPropertyEditor.this._comboBox.getSelectedItem();
                    if (newValue != null && !newValue.equals(CredentialPropertyEditor.this._comboValue)) {
                        CredentialPropertyEditor.this._comboValue = newValue;
                        CredentialPropertyEditor.this.getXmlComponentWrapper().updateModelFromXmlComponent();
                    }
                }
            });
            this._subPanel.add(this._comboBox);
            this._panel.add(this._subPanel);
        }
        this.updateXmlComponentFromPropertyValue();
        return this._panel;
    }

    public void updateXmlComponentFromPropertyValue() {
        String value = (String)this.getValue();
        if (value == null || value.trim().length() == 0 || "none".equals(this.getValue())) {
            this._checkBox.setSelected(false);
            this._label.setEnabled(false);
            this._comboBox.setEnabled(false);
        } else {
            this._checkBox.setSelected(true);
            this._label.setEnabled(true);
            this._comboBox.setEnabled(true);
            this._comboBox.setSelectedItem(this.getValue());
        }
    }

    public void updatePropertyValueFromXmlComponent() {
        if (!this._checkBox.isSelected()) {
            this.setValue("none");
        } else {
            this.setValue((String)this._comboBox.getSelectedItem());
        }
    }

    public void addChildFocusListener(FocusListener focusListener) {
        this._checkBox.addFocusListener(focusListener);
        this._comboBox.addFocusListener(focusListener);
    }

    public void removeChildFocusListener(FocusListener focusListener) {
        this._checkBox.removeFocusListener(focusListener);
        this._comboBox.removeFocusListener(focusListener);
    }

    public XmlComponentPropertyEditor setEnabled(boolean enabled) {
        this._checkBox.setEnabled(enabled);
        return this;
    }
}

