/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.editor.feature;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableColumn;
import oracle.adfmf.common.UniqueValueGenerator;
import oracle.adfmf.common.util.McAppUtils;
import oracle.adfmf.framework.dt.editor.EditorMetadataMethods;
import oracle.adfmf.framework.dt.editor.feature.ContentTableAdapter;
import oracle.adfmf.framework.dt.editor.feature.FeatureXmlKeys;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.gui.base.xmlComponent.XmlComponentModel;
import oracle.bali.xml.gui.base.xmlComponent.XmlComponentWrapper;
import oracle.bali.xml.gui.swing.xmlComponent.AbstractXmlTableAdapter;
import oracle.bali.xml.gui.swing.xmlComponent.AbstractXmlTableEditor;
import oracle.bali.xml.gui.swing.xmlComponent.XmlTableEditor;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.model.task.FixedNameTransactionTask;
import oracle.bali.xml.model.task.ReadOnlyTask;
import oracle.javatools.icons.OracleIcons;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ContentTableEditor
extends XmlTableEditor {
    private static final int TYPE_COLUMN_INDEX = 1;

    public Component getXmlComponent() {
        super.getXmlComponent();
        if (this.getTable().getSelectedRow() == -1 && this.getTable().getModel().getRowCount() > 0) {
            this.getTable().changeSelection(0, 0, false, false);
        }
        return this.getTablePanel();
    }

    protected AbstractXmlTableAdapter createTableAdapter() {
        return new ContentTableAdapter(this);
    }

    public String getTableColumnTitle(int column) {
        if (column == 1) {
            return EditorMetadataMethods.get("TYPE_COLUMN_HEADER");
        }
        return super.getTableColumnTitle(column);
    }

    public Object getCellValueAt(final int rowIndex, int columnIndex) {
        if (columnIndex == 1) {
            XmlComponentWrapper columnXmlComponentWrapper = (XmlComponentWrapper)this.getColumnXmlComponentWrapperList().get(columnIndex);
            return new ReadOnlyTask<Object>(){

                protected Object runImpl(AbstractModel model) {
                    Node parentNode;
                    XmlComponentModel tableXmlComponentModel = ContentTableEditor.this.getXmlComponentModel();
                    Node foundNode = (Node)tableXmlComponentModel.getChild((Object)(parentNode = tableXmlComponentModel.getParentXmlComponentModel().getNode()), rowIndex);
                    if (foundNode != null) {
                        NodeList childNodes = foundNode.getChildNodes();
                        int count = childNodes.getLength();
                        for (int i = 0; i < count; ++i) {
                            Node child = childNodes.item(i);
                            String localname = child.getLocalName();
                            for (String elementName : FeatureXmlKeys.VIEW_MAP.keySet()) {
                                if (!elementName.equals(localname)) continue;
                                XmlKey key = FeatureXmlKeys.VIEW_MAP.get(elementName);
                                return ContentTableEditor.this.getShortDisplayName(key);
                            }
                        }
                    }
                    return null;
                }
            }.run((AbstractModel)columnXmlComponentWrapper.getXmlComponentModel().getView());
        }
        return super.getCellValueAt(rowIndex, columnIndex);
    }

    protected void setTableCellEditors() {
        super.setTableCellEditors();
        TableColumn typeColumn = this.getTable().getColumnModel().getColumn(1);
        typeColumn.setCellEditor(new TypeColumnCellEditor());
    }

    public final String getShortDisplayName(XmlKey key) {
        return this.getXmlComponentModel().getXmlMetadataResolver().getShortDisplayName(key);
    }

    public Action createAddAction() {
        AbstractAction addAction = new AbstractAction("", OracleIcons.getIcon((String)"add.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContentTableEditor.this.insertView("amx");
            }
        };
        return addAction;
    }

    public void reorderContent(final int start, int end, final int to) {
        assert (start == end);
        new FixedNameTransactionTask("Reorder content elements..."){

            protected void performTask(AbstractModel model) throws XmlCommitException {
                XmlComponentModel xmlComponentModel = ContentTableEditor.this.getXmlComponentModel();
                Node parentNode = xmlComponentModel.getParentNode();
                Node NodetoMove = (Node)xmlComponentModel.getChild((Object)parentNode, start);
                DomPosition position = null;
                if (to < start) {
                    Node NodeAfter = (Node)xmlComponentModel.getChild((Object)parentNode, to);
                    xmlComponentModel.deleteNode(NodetoMove);
                    position = DomPositionFactory.before((Node)NodeAfter);
                } else {
                    Node NodeBefore = (Node)xmlComponentModel.getChild((Object)parentNode, to);
                    xmlComponentModel.deleteNode(NodetoMove);
                    position = DomPositionFactory.after((Node)NodeBefore);
                }
                XmlView view = ContentTableEditor.this.getXmlComponentModel().getView();
                view.insertNode(NodetoMove, position);
            }
        }.run((AbstractModel)this.getXmlComponentModel().getView());
        this.getTableModel().fireTableDataChanged();
    }

    public final void insertView(final String viewType) {
        new FixedNameTransactionTask("insert View Element..."){

            protected void performTask(AbstractModel model) throws XmlCommitException {
                XmlComponentModel xmlComponentModel = ContentTableEditor.this.getXmlComponentModel();
                XmlComponentModel parentXmlComponentModel = xmlComponentModel.getParentXmlComponentModel();
                Node parentNode = parentXmlComponentModel.getNode();
                String contentId = ContentTableEditor.this.generateDefaultContentId(parentNode);
                DomPosition position = DomPositionFactory.createInsideOrAfterPosition((Node)parentNode);
                XmlView view = ContentTableEditor.this.getXmlComponentModel().getView();
                Document doc = view.getDocument();
                Element content = doc.createElementNS("http://xmlns.oracle.com/adf/mf", McAppUtils.getQualifiedName("content"));
                content.setAttributeNS(null, "id", contentId);
                Element element = ContentTableEditor.this.createContent(doc, viewType);
                content.appendChild(element);
                view.insertNode((Node)content, position);
            }
        }.run((AbstractModel)this.getXmlComponentModel().getView());
        this.getTableModel().newRowsAdded(new TableModelEvent(this.getTableModel()));
        this.updateAddDeleteButtons();
        int row = this.getTable().getRowCount() - 1;
        this.getTable().changeSelection(row, 0, false, false);
        this.getTable().requestFocusInWindow();
        this.getTable().scrollRectToVisible(this.getTable().getCellRect(row, 0, true));
    }

    public final void changeContentType(final String currentType, final String newType) {
        new FixedNameTransactionTask("change View Element..."){

            protected void performTask(AbstractModel model) throws XmlCommitException {
                XmlComponentModel xmlComponentModel = ContentTableEditor.this.getXmlComponentModel();
                Node node = xmlComponentModel.getNode();
                if (currentType != null) {
                    NodeList childNodes = node.getChildNodes();
                    int count = childNodes.getLength();
                    for (int i = 0; i < count; ++i) {
                        Node child = childNodes.item(i);
                        String localname = child.getLocalName();
                        if (!currentType.equals(localname)) continue;
                        ContentTableEditor.this.getXmlComponentModel().deleteNode(child);
                        ContentTableEditor.this.getXmlComponentModel().invalidateNode();
                    }
                }
                XmlView view = ContentTableEditor.this.getXmlComponentModel().getView();
                Document doc = view.getDocument();
                Element element = ContentTableEditor.this.createContent(doc, newType);
                node.appendChild(element);
            }
        }.run((AbstractModel)this.getXmlComponentModel().getView());
    }

    public final String getCurrentType(boolean enabled) {
        String displayName;
        int rowIndex = this.getTable().getSelectedRow();
        if (this.getTable().getModel().getRowCount() == 0) {
            return "";
        }
        if (rowIndex < 0) {
            rowIndex = 0;
            if (enabled) {
                this.getTable().changeSelection(0, 0, false, false);
            }
        }
        if ((displayName = (String)this.getCellValueAt(rowIndex, 1)) != null) {
            return this.getElmentName(displayName);
        }
        return "";
    }

    public AbstractXmlTableEditor setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            int rowIndex = this.getTable().getSelectedRow();
            if (this.getXmlComponentModel().getSelectedIndex() != rowIndex) {
                this.getXmlComponentModel().setSelectedIndex(rowIndex);
            }
        }
        return this;
    }

    private final String getElmentName(String displayName) {
        for (String elementName : FeatureXmlKeys.VIEW_MAP.keySet()) {
            if (!this.getShortDisplayName(FeatureXmlKeys.VIEW_MAP.get(elementName)).equals(displayName)) continue;
            return elementName;
        }
        return null;
    }

    private String generateDefaultContentId(Node parentNode) {
        String featureId = ((Element)parentNode).getAttributeNS(null, "id");
        HashSet<String> contentIdSet = new HashSet<String>();
        NodeList childNodes = parentNode.getChildNodes();
        if (childNodes != null) {
            for (int i = 0; i < childNodes.getLength(); ++i) {
                String id;
                Node child = childNodes.item(i);
                if (!(child instanceof Element) || !"content".equals(child.getLocalName()) || (id = ((Element)child).getAttributeNS(null, "id")) == null || id.trim().length() <= 0) continue;
                contentIdSet.add(id.trim());
            }
        }
        UniqueValueGenerator generator = new UniqueValueGenerator(featureId + ".", contentIdSet);
        return generator.getUniqueValue();
    }

    private Element createContent(Document doc, String newType) {
        Element element = doc.createElementNS("http://xmlns.oracle.com/adf/mf", McAppUtils.getQualifiedName(newType));
        if ("localHTML".equals(newType)) {
            element.setAttributeNS(null, "url", "");
        } else if ("remoteURL".equals(newType)) {
            element.setAttributeNS(null, "connection", "");
        } else if ("amx".equals(newType)) {
            element.setAttributeNS(null, "file", "");
        } else if ("nativeview".equals(newType)) {
            Element param = doc.createElementNS("http://xmlns.oracle.com/adf/mf", McAppUtils.getQualifiedName("parameter"));
            param.setAttributeNS(null, "name", "");
            param.setAttributeNS(null, "value", "");
            element.appendChild(param);
        }
        return element;
    }

    protected class TypeColumnCellEditor
    extends DefaultCellEditor
    implements ItemListener {
        private final String[] types;
        private JComboBox m_comboBox;
        private Object m_currentValue;

        public TypeColumnCellEditor() {
            super(new JComboBox());
            this.types = this.getViewTypes();
        }

        @Override
        public Object getCellEditorValue() {
            return this.m_comboBox.getSelectedItem();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (this.m_comboBox == null) {
                this.m_comboBox = new JComboBox<String>(this.types);
                this.m_comboBox.addItemListener(this);
            }
            this.m_currentValue = value;
            this.m_comboBox.setSelectedItem(value);
            return this.m_comboBox;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            Object newValue = this.m_comboBox.getSelectedItem();
            if (newValue != null && !newValue.equals(this.m_currentValue)) {
                String currentType = this.m_currentValue != null ? ContentTableEditor.this.getElmentName(this.m_currentValue.toString()) : null;
                String newType = ContentTableEditor.this.getElmentName(newValue.toString());
                ContentTableEditor.this.changeContentType(currentType, newType);
                ContentTableEditor.this.getXmlComponent();
            }
            this.m_currentValue = newValue;
            super.stopCellEditing();
        }

        private String[] getViewTypes() {
            ArrayList<String> list = new ArrayList<String>();
            for (String viewElement : FeatureXmlKeys.VIEW_ELEMENTS) {
                if ("nativeview".equals(viewElement)) continue;
                list.add(ContentTableEditor.this.getShortDisplayName(FeatureXmlKeys.VIEW_MAP.get(viewElement)));
            }
            return list.toArray(new String[list.size()]);
        }
    }
}

