/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.editor.feature;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableModel;
import oracle.adfmf.framework.dt.editor.EditorMetadataMethods;
import oracle.adfmf.framework.dt.editor.feature.ContentTableEditor;
import oracle.adfmf.framework.dt.editor.feature.FeatureXmlKeys;
import oracle.bali.xml.gui.base.xmlComponent.XmlComponentModel;
import oracle.bali.xml.gui.base.xmlComponent.XmlComponentWrapper;
import oracle.bali.xml.gui.swing.xmlComponent.XmlGenericTableAdapter;
import oracle.bali.xml.gui.swing.xmlComponent.XmlTableEditor;
import oracle.bali.xml.metadata.XmlKey;
import oracle.javatools.ui.ResizeComponent;
import oracle.javatools.ui.table.EditableTableModel;
import oracle.javatools.ui.table.GenericTableModel;
import oracle.javatools.ui.table.ReorderableTableModel;
import oracle.javatools.ui.table.ReorderableTableWithTitleBar;
import org.w3c.dom.Node;

public class ContentTableAdapter
extends XmlGenericTableAdapter {
    public ContentTableAdapter(XmlTableEditor xmlTableEditor) {
        super(xmlTableEditor);
    }

    protected JPanel createTablePanel() {
        JScrollPane tableScrollPane = new JScrollPane(this.getTable());
        ResizeComponent rc = new ResizeComponent((JComponent)tableScrollPane);
        ReorderableTableWithTitleBar tablePanel = new ReorderableTableWithTitleBar(this.getXmlTableEditor().getTable(), (JComponent)rc, true, true);
        this.configureGenericTable();
        this.configureToolbar(tablePanel);
        this.getToolBar().setLabel(EditorMetadataMethods.get("CONTENT_SUBTAB") + ":");
        this.getToolBar().setAddMenuActions((Action[])this.getViewActions());
        return tablePanel;
    }

    private final String getShortDisplayName(XmlKey key) {
        return ((ContentTableEditor)this.getXmlTableEditor()).getShortDisplayName(key);
    }

    private final ImplAction[] getViewActions() {
        ArrayList<ImplAction> actionList = new ArrayList<ImplAction>();
        for (String elementName : FeatureXmlKeys.VIEW_ELEMENTS) {
            if ("nativeview".equals(elementName)) continue;
            actionList.add(new ImplAction(elementName, this.getShortDisplayName(FeatureXmlKeys.VIEW_MAP.get(elementName))));
        }
        return actionList.toArray(new ImplAction[actionList.size()]);
    }

    protected DefaultTableModel createTableModel() {
        return new ContentTableModel();
    }

    protected class ContentTableModel
    extends DefaultTableModel
    implements EditableTableModel,
    GenericTableModel,
    ReorderableTableModel {
        @Override
        public void moveRow(int start, int end, int to) {
            ((ContentTableEditor)ContentTableAdapter.this.getXmlTableEditor()).reorderContent(start, end, to);
            super.moveRow(start, end, to);
        }

        @Override
        public int getRowCount() {
            XmlComponentModel xmlComponentModel = ContentTableAdapter.this.getXmlTableEditor().getXmlComponentModel();
            Node parentNode = xmlComponentModel.getParentNode();
            int rowCount = xmlComponentModel.getChildCount((Object)parentNode);
            return rowCount;
        }

        @Override
        public int getColumnCount() {
            return ContentTableAdapter.this.getXmlTableEditor().getTableColumnCount();
        }

        @Override
        public String getColumnName(int column) {
            return ContentTableAdapter.this.getXmlTableEditor().getTableColumnTitle(column);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return ContentTableAdapter.this.getXmlTableEditor().getCellValueAt(rowIndex, columnIndex);
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            ContentTableAdapter.this.getXmlTableEditor().setCellValueAt(value, rowIndex, columnIndex);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            XmlComponentWrapper columnUiComponentWrapper = (XmlComponentWrapper)ContentTableAdapter.this.getXmlTableEditor().getColumnXmlComponentWrapperList().get(columnIndex);
            return columnUiComponentWrapper.isEditable();
        }

        public void insertColumn(int column, Object columnName, Object[] columnData) {
        }

        public void removeColumn(int column) {
        }

        public int duplicateRow(int row, int nCopy) {
            Object[] rowData = new Object[this.getColumnCount()];
            for (int i = 0; i < rowData.length; ++i) {
                rowData[i] = i == 0 ? "Copy of " + this.getValueAt(row, i) : this.getValueAt(row, i);
            }
            this.insertRow(row + 1, rowData);
            return row + 1;
        }

        public int duplicateColumn(int col, int nCopy) {
            return -1;
        }

        public int getColumnAlignment(int column) {
            return 2;
        }

        public boolean canHide(int column) {
            return false;
        }
    }

    private class ImplAction
    extends AbstractAction {
        public ImplAction(String actionCommand, String name) {
            super(name);
            this.putValue("ActionCommandKey", actionCommand);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String viewType = e.getActionCommand();
            ((ContentTableEditor)ContentTableAdapter.this.getXmlTableEditor()).insertView(viewType);
        }
    }
}

