/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.editor.feature;

import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JPanel;
import oracle.adfmf.framework.dt.editor.EditorMetadataMethods;
import oracle.adfmf.framework.dt.editor.feature.ImageAttributePropertyEditor;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.task.ReadOnlyTask;
import oracle.javatools.ui.Colors;
import org.w3c.dom.Element;

public class ContentImageAttributePropertyEditor
extends ImageAttributePropertyEditor
implements FocusListener {
    private static final String DEFAULT_TEXT = EditorMetadataMethods.get("DEFAULT_FROM_GENERAL");

    public ContentImageAttributePropertyEditor(XmlContext xmlContext) {
        super(xmlContext);
    }

    @Override
    public void updateXmlComponentFromPropertyValue() {
        String value = (String)this.getValue();
        this.m_field.setText(value);
        this.m_field.setForeground(Color.BLACK);
        if ((value == null || value.isEmpty()) && this.isParentNodeValid() && (value = (String)this.getParentAttrValue()) != null && !value.isEmpty()) {
            this.m_field.setText(DEFAULT_TEXT);
            this.m_field.setForeground(Colors.HINT_TEXT);
        }
        super.loadImage(value);
    }

    private Object getParentAttrValue() {
        final String attrName = this.getXmlComponentModel().getXmlKey().getLocalName();
        return new ReadOnlyTask<Object>(){

            protected Object runImpl(AbstractModel model) {
                if (ContentImageAttributePropertyEditor.this.isParentNodeValid()) {
                    return ((Element)ContentImageAttributePropertyEditor.this.getXmlComponentModel().getParentXmlComponentModel().getParentNode()).getAttributeNS(null, attrName);
                }
                return null;
            }
        }.run((AbstractModel)this.getXmlComponentModel().getView());
    }

    private boolean isParentNodeValid() {
        return this.getXmlComponentModel().getParentXmlComponentModel().getParentNode() != null;
    }

    @Override
    protected JPanel createHintPanel() {
        JPanel hintPanel = super.createHintPanel();
        this.m_field.addFocusListener(this);
        return hintPanel;
    }

    @Override
    public void updatePropertyValueFromXmlComponent() {
        String typed = this.m_field.getText();
        this.setValue(DEFAULT_TEXT.equals(typed) ? "" : typed);
    }

    @Override
    public void focusGained(FocusEvent e) {
        String value = (String)this.getValue();
        if (value == null || value.isEmpty()) {
            this.m_field.setText("");
            this.m_field.setForeground(Color.BLACK);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
    }
}

