/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.editor.feature;

import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.adfdtinternal.controller.mobile.gallery.AdfMobileBoundedTaskFlowWizard;
import oracle.adfdtinternal.controller.mobile.interactions.AdfMobileDTInteractions;
import oracle.adfmf.amx.dt.editor.AMXFileBuilder;
import oracle.adfmf.common.util.McAppUtils;
import oracle.adfmf.framework.dt.editor.EditorMetadataMethods;
import oracle.adfmf.framework.dt.editor.feature.FiletypeAttributePropertyEditor;
import oracle.bali.xml.gui.base.xmlComponent.XmlComponentPropertyEditor;
import oracle.bali.xml.model.XmlContext;
import oracle.ide.Context;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;
import oracle.jdeveloper.builder.file.FileBuilder;

public class AmxAttributePropertyEditor
extends FiletypeAttributePropertyEditor {
    private JPopupMenu _popup = new JPopupMenu();
    private JPopupMenu _newFilePopup;
    private JMenuItem _menuItemTaskflow;
    private JMenuItem _menuItemAmxPage = new JMenuItem(EditorMetadataMethods.get("AMX_PAGE_MENU_ITEM"));
    private JMenuItem _menuItemNewTaskflow;
    private JMenuItem _menuItemNewAmxPage;
    private static final int _OFFSET = 8;
    private static final String _AMX_EXT = ".amx";
    private static final String _NO_TASKFLOW = "<" + EditorMetadataMethods.get("NO_TASKFLOW") + ">";

    public AmxAttributePropertyEditor(XmlContext xmlContext) {
        super(xmlContext);
        this._menuItemAmxPage.addActionListener(this);
        this._popup.add(this._menuItemAmxPage);
        this._menuItemTaskflow = new JMenuItem(EditorMetadataMethods.get("TASK_FLOW_MENU_ITEM"));
        this._menuItemTaskflow.addActionListener(this);
        this._popup.add(this._menuItemTaskflow);
        this._newFilePopup = new JPopupMenu();
        this._menuItemNewAmxPage = new JMenuItem(EditorMetadataMethods.get("AMX_PAGE_MENU_ITEM"));
        this._menuItemNewAmxPage.addActionListener(this);
        this._newFilePopup.add(this._menuItemNewAmxPage);
        this._menuItemNewTaskflow = new JMenuItem(EditorMetadataMethods.get("TASK_FLOW_MENU_ITEM"));
        this._menuItemNewTaskflow.addActionListener(this);
        this._newFilePopup.add(this._menuItemNewTaskflow);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.getBrowseButton()) {
            this._popup.show(this.getBrowseButton(), 8, 8);
        } else if (source == this.getAddButton()) {
            this._newFilePopup.show(this.getAddButton(), 8, 8);
        } else if (source == this._menuItemTaskflow) {
            this._popTaskFlowDialog();
        } else if (source == this._menuItemAmxPage) {
            this.setDialogOn(true);
            URL url = this.popFileDialog();
            this.setDialogOn(false);
            this.setUrlValue(url);
        } else if (source == this._menuItemNewTaskflow) {
            AdfMobileBoundedTaskFlowWizard wizard = new AdfMobileBoundedTaskFlowWizard();
            this.setDialogOn(true);
            URL url = this._invokeNewFileWizard((FileBuilder)wizard);
            this.setDialogOn(false);
            this.setUrlValue(url);
        } else if (source == this._menuItemNewAmxPage) {
            AMXFileBuilder wizard = new AMXFileBuilder();
            this.setDialogOn(true);
            URL url = this._invokeNewFileWizard(wizard);
            this.setDialogOn(false);
            this.setUrlValue(url);
        }
    }

    @Override
    public XmlComponentPropertyEditor setEnabled(boolean enabled) {
        super.featureLevelEnabled(enabled);
        super.setEnabled(enabled);
        return this;
    }

    @Override
    public String getAddButtonTooltip() {
        return EditorMetadataMethods.get("CREATE_AMX");
    }

    @Override
    public String getBrowseButtonTooltip() {
        return EditorMetadataMethods.get("BROWSE_AMX");
    }

    @Override
    protected URLFilter getURLFilter() {
        if (super.getURLFilter() == null) {
            this.setURLFilter((URLFilter)new DefaultURLFilter(EditorMetadataMethods.get("AMX_PAGE"), _AMX_EXT));
        }
        return super.getURLFilter();
    }

    @Override
    protected boolean isSupportedFileType(String filename) {
        return McAppUtils.isAmxFile(filename);
    }

    private void _popTaskFlowDialog() {
        JPopupMenu taskflowPopup = new JPopupMenu();
        List<String> taskflows = this._getList();
        if (taskflows.size() > 0) {
            for (String value : taskflows) {
                taskflowPopup.add(new TaskflowAction(value));
            }
        } else {
            taskflowPopup.add(new TaskflowAction(_NO_TASKFLOW));
        }
        taskflowPopup.show(this.getBrowseButton(), 8, 8);
    }

    private URL _invokeNewFileWizard(FileBuilder wizard) {
        boolean ok;
        Context context = this.getIdeContext();
        URL dirURL = this.getFeatureDirURL(context);
        URL url = null;
        if (dirURL != null) {
            String[] params = new String[]{dirURL.toString()};
            FileBuilder.setLegacyParams((Context)context, (String[])params);
        }
        if (ok = wizard.invoke(context)) {
            String[] returnParams = FileBuilder.getLegacyParams((Context)context);
            if (returnParams != null && returnParams.length > 0) {
                url = URLFactory.newURL((String)returnParams[0]);
            }
        }
        return url;
    }

    private List<String> _getList() {
        AdfMobileDTInteractions dti = AdfMobileDTInteractions.getInstance();
        Context context = Context.newIdeContext();
        return dti.getTaskFlowTargets(context);
    }

    private class TaskflowAction
    extends AbstractAction {
        public TaskflowAction(String value) {
            super(value);
            this.putValue("ActionCommandKey", value);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String value = e.getActionCommand();
            if (!_NO_TASKFLOW.equals(value)) {
                AmxAttributePropertyEditor.this.setValue(value);
                AmxAttributePropertyEditor.this.getXmlComponentWrapper().updateModelFromXmlComponent();
            }
        }
    }
}

