/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.editor;

import java.awt.Component;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.adfmf.common.util.McAppUtils;
import oracle.adfmf.framework.dt.editor.ChildPropertyEditor;
import oracle.adfmf.framework.dt.editor.EditorMetadataMethods;
import oracle.adfmf.framework.dt.editor.SpringboardFeatureRefPropertyEditor;
import oracle.bali.xml.gui.base.inspector.editors.BooleanEditor;
import oracle.bali.xml.gui.base.xmlComponent.AbstractXmlPropertyEditorDecorator;
import oracle.bali.xml.gui.base.xmlComponent.XmlComponentPropertyEditor;
import oracle.bali.xml.gui.base.xmlComponent.XmlComponentWrapper;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.task.FixedNameTransactionTask;
import oracle.bali.xml.model.task.ReadOnlyTask;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SpringboardButtonsEditor
extends AbstractXmlPropertyEditorDecorator<Boolean> {
    private boolean _setSelectedCalled = false;
    private XmlComponentWrapper _peerComponentWrapper;
    private final List<XmlComponentWrapper> _childWrapperList = new ArrayList<XmlComponentWrapper>();
    private JPanel _panel;
    private JRadioButton _bNone;
    private JRadioButton _bDefault;
    private JRadioButton _bCustom;
    private ButtonGroup _group;

    public SpringboardButtonsEditor() {
        super((PropertyEditor)new BooleanEditor());
    }

    public Component getXmlComponent() {
        if (this._panel == null) {
            this._panel = new JPanel();
            this._panel.setLayout(new BoxLayout(this._panel, 3));
            this._panel.add(new JLabel(EditorMetadataMethods.get("SB_LABEL")));
            ButtonListener listener = new ButtonListener();
            this._bNone = new CustomPageRadioButton();
            this._bNone.addItemListener(listener);
            this._bNone.setText(EditorMetadataMethods.get("NONE"));
            this._panel.add(this._bNone);
            this._bDefault = new CustomPageRadioButton();
            this._bDefault.addItemListener(listener);
            this._bDefault.setText(EditorMetadataMethods.get("DEFAULT"));
            this._panel.add(this._bDefault);
            this._bCustom = new CustomPageRadioButton();
            this._bCustom.addItemListener(listener);
            this._bCustom.setText(EditorMetadataMethods.get("CUSTOM"));
            this._panel.add(this._bCustom);
            this._group = new ButtonGroup();
            this._group.add(this._bNone);
            this._group.add(this._bDefault);
            this._group.add(this._bCustom);
        }
        this.updateXmlComponentFromPropertyValue();
        return this._panel;
    }

    public void updatePropertyValueFromXmlComponent() {
        this.setValue(this._bNone.isSelected() ? "false" : "true");
    }

    public void updateXmlComponentFromPropertyValue() {
        if ("true".equals(this.getAsText())) {
            if (this._hasFeatureRefElement().booleanValue()) {
                this._bCustom.setSelected(true);
            } else {
                this._bDefault.setSelected(true);
                this._enablePeerComponent(false);
            }
            this._enableChildComponents(true);
        } else {
            this._bNone.setSelected(true);
            this._enableChildComponents(false);
            this._enablePeerComponent(false);
        }
    }

    public void addChildFocusListener(FocusListener focusListener) {
        this._bNone.addFocusListener(focusListener);
        this._bDefault.addFocusListener(focusListener);
        this._bCustom.addFocusListener(focusListener);
    }

    public void removeChildFocusListener(FocusListener focusListener) {
        this._bNone.removeFocusListener(focusListener);
        this._bDefault.removeFocusListener(focusListener);
        this._bCustom.removeFocusListener(focusListener);
    }

    public SpringboardButtonsEditor setPeerComponentWrapper(XmlComponentWrapper peerWrapper) {
        this._peerComponentWrapper = peerWrapper;
        return this;
    }

    public void addChildWrapper(XmlComponentWrapper childWrapper) {
        this._childWrapperList.add(childWrapper);
    }

    public boolean isCustomButtonSelected() {
        if (this._bCustom != null) {
            return this._bCustom.isSelected();
        }
        return false;
    }

    private void _enableChildComponents(boolean enabled) {
        for (XmlComponentWrapper childWrapper : this._childWrapperList) {
            XmlComponentPropertyEditor editor = childWrapper.getPropertyEditor();
            if (!(editor instanceof ChildPropertyEditor)) continue;
            ((ChildPropertyEditor)editor).enabledByParent(enabled);
        }
    }

    private void _enablePeerComponent(boolean enabled) {
        if (this._peerComponentWrapper != null) {
            ((SpringboardFeatureRefPropertyEditor)this._peerComponentWrapper.getPropertyEditor()).setEnabledByPeerComponent(enabled);
        }
    }

    private Boolean _hasFeatureRefElement() {
        return (Boolean)new ReadOnlyTask<Boolean>(){

            protected Boolean runImpl(AbstractModel model) {
                Element parentNode = (Element)SpringboardButtonsEditor.this.getXmlComponentModel().getParentAttrNode();
                if (parentNode != null) {
                    NodeList list = parentNode.getElementsByTagNameNS("http://xmlns.oracle.com/adf/mf", "springboardFeatureReference");
                    return list != null && list.getLength() > 0;
                }
                return false;
            }
        }.run((AbstractModel)this.getXmlComponentModel().getView());
    }

    private void _createChildElement() {
        new FixedNameTransactionTask("Create the springboard feature reference element..."){

            protected void performTask(AbstractModel model) throws XmlCommitException {
                if (SpringboardButtonsEditor.this._hasFeatureRefElement().booleanValue()) {
                    return;
                }
                Node parentNode = SpringboardButtonsEditor.this.getXmlComponentModel().getParentAttrNode();
                Element element = SpringboardButtonsEditor.this._getDocument().createElementNS("http://xmlns.oracle.com/adf/mf", McAppUtils.getQualifiedName("springboardFeatureReference"));
                element.setAttributeNS(null, "id", "");
                parentNode.appendChild(element);
            }
        }.run((AbstractModel)this.getXmlComponentModel().getView());
    }

    private void _deleteChildElement() {
        new FixedNameTransactionTask("delete the springboard feature reference element..."){

            protected void performTask(AbstractModel model) throws XmlCommitException {
                Node child;
                Node parentNode = SpringboardButtonsEditor.this.getXmlComponentModel().getParentAttrNode();
                if (parentNode != null && (child = parentNode.getFirstChild()) != null) {
                    parentNode.removeChild(child);
                }
            }
        }.run((AbstractModel)this.getXmlComponentModel().getView());
    }

    private Document _getDocument() {
        return this.getXmlComponentModel().getView().getDocument();
    }

    private final class ButtonListener
    implements ItemListener {
        private ButtonListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (!SpringboardButtonsEditor.this._setSelectedCalled && itemEvent.getStateChange() == 1) {
                Object source = itemEvent.getSource();
                if (source == SpringboardButtonsEditor.this._bDefault || source == SpringboardButtonsEditor.this._bNone) {
                    SpringboardButtonsEditor.this._deleteChildElement();
                    SpringboardButtonsEditor.this._enablePeerComponent(false);
                } else if (source == SpringboardButtonsEditor.this._bCustom) {
                    SpringboardButtonsEditor.this._createChildElement();
                    SpringboardButtonsEditor.this._enablePeerComponent(true);
                }
                SpringboardButtonsEditor.this.getXmlComponentWrapper().updateModelFromXmlComponent();
            }
        }
    }

    private final class CustomPageRadioButton
    extends JRadioButton {
        private CustomPageRadioButton() {
        }

        @Override
        public void setSelected(boolean b) {
            SpringboardButtonsEditor.this._setSelectedCalled = true;
            super.setSelected(b);
            SpringboardButtonsEditor.this._setSelectedCalled = false;
        }
    }
}

