/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.editor;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.CellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import oracle.adfmf.framework.dt.connection.dialogs.LoginConnectionWizard;
import oracle.adfmf.framework.dt.editor.EditorMetadataMethods;
import oracle.adfmf.framework.dt.editor.FrameworkXmlKeys;
import oracle.adfmf.framework.dt.editor.SecureFeatureChangeListener;
import oracle.adfmf.framework.dt.editor.SecureFeatureChangeManager;
import oracle.adfmf.framework.dt.editor.SecureFeatureRefTableAdapter;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.gui.swing.xmlComponent.AbstractXmlTableAdapter;
import oracle.bali.xml.gui.swing.xmlComponent.XmlTableEditor;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.util.AttributeValueItem;
import oracle.bali.xml.util.ContextualAttributeValueItemProvider;
import oracle.ide.Context;
import oracle.ide.dialogs.ExceptionDialog;
import oracle.ide.model.Workspace;
import oracle.javatools.icons.OracleIcons;

public class SecureFeatureRefTableEditor
extends XmlTableEditor
implements SecureFeatureChangeListener {
    private static final int _ID_COLUMN_IDNEX = 0;
    private static final int _LOGIN_SERVER_COLUMN_IDNEX = 1;
    private static final String _DEFAULT_LOGIN_SERVER_VALUE = "<application login server>";
    private boolean _wizardOn = false;

    protected void setupTable() {
        super.setupTable();
        SecureFeatureChangeManager.getInstance().addListener(this._getWorkspace(), this);
    }

    public void dispose() {
        SecureFeatureChangeManager.getInstance().removeListener(this._getWorkspace(), this);
        super.dispose();
    }

    protected AbstractXmlTableAdapter createTableAdapter() {
        return new SecureFeatureRefTableAdapter(this);
    }

    protected void setTableCellEditors() {
        super.setTableCellEditors();
        TableColumn columnId = this.getTable().getColumnModel().getColumn(0);
        columnId.setHeaderValue(EditorMetadataMethods.get("ID_COLUMN_HEADER"));
        TableColumn columnLoginServer = this.getTable().getColumnModel().getColumn(1);
        columnLoginServer.setCellEditor(new LoginServerCellEditor());
        columnLoginServer.setCellRenderer(new DefaultLoginServerTableCellRenderer());
    }

    public void handleFocusLeavesTable(CellEditor cellEditor) {
        if (this._wizardOn) {
            return;
        }
        super.handleFocusLeavesTable(cellEditor);
    }

    protected void setupSelectionListener() {
        this.getTableModel().fireTableDataChanged();
    }

    @Override
    public void secureFeatureChanged() {
        this.getTableModel().fireTableDataChanged();
    }

    private Workspace _getWorkspace() {
        XmlContext xmlContext = this.getXmlComponentModel().getView().getContext();
        return ((JDevXmlContext)xmlContext).getWorkspace();
    }

    private class LoginServerCellEditor
    extends DefaultCellEditor
    implements ActionListener,
    ItemListener {
        private ContextualAttributeValueItemProvider _cavip;
        private static final int _BUTTON_BORDER = 2;
        private JPanel _panel;
        private JButton _addButton;
        private JButton _editButton;
        private JComboBox _comboBox;

        public LoginServerCellEditor() {
            super(new JComboBox());
            this._cavip = null;
            this._panel = null;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (this._panel == null) {
                this._panel = new JPanel();
                this._panel.setLayout(new FlowLayout(0, 5, 0));
                this._panel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
                this._comboBox = new JComboBox();
                this._comboBox.addItemListener(this);
                this._panel.add(this._comboBox);
                this._addButton = new JButton(OracleIcons.getIcon((String)"add.png"));
                this._addButton.setBorderPainted(false);
                this._addButton.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
                this._addButton.addActionListener(this);
                this._panel.add(this._addButton);
                this._editButton = new JButton(OracleIcons.getIcon((String)"edit.png"));
                this._editButton.setBorderPainted(false);
                this._editButton.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
                this._editButton.addActionListener(this);
                this._panel.add(this._editButton);
                this._cavip = SecureFeatureRefTableEditor.this.getXmlComponentModel().getXmlMetadataResolver().getContextualAttributeValueItemProvider(FrameworkXmlKeys.XMLKEY_FEATUREREF_ATTR_LOGIN_CONN);
            }
            this._addItems();
            if (value == null || "".equals((String)value)) {
                this._comboBox.setSelectedItem(SecureFeatureRefTableEditor._DEFAULT_LOGIN_SERVER_VALUE);
                this._editButton.setEnabled(false);
            } else {
                this._comboBox.setSelectedItem(value);
                this._editButton.setEnabled(true);
            }
            return this._panel;
        }

        @Override
        public Object getCellEditorValue() {
            String value = (String)this._comboBox.getSelectedItem();
            if (SecureFeatureRefTableEditor._DEFAULT_LOGIN_SERVER_VALUE.equals(value)) {
                return "";
            }
            return value;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            SecureFeatureRefTableEditor.this._wizardOn = true;
            if (source == this._addButton) {
                String Id = this.invokeWizard();
                if (Id != null) {
                    this._comboBox.addItem(Id);
                    this._comboBox.setSelectedItem(Id);
                }
            } else if (source == this._editButton) {
                String Id = (String)this._comboBox.getSelectedItem();
                this.invokeWizardInEditMode(Id);
            }
            SecureFeatureRefTableEditor.this._wizardOn = false;
            super.stopCellEditing();
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            super.stopCellEditing();
        }

        private void _addItems() {
            this._comboBox.removeAllItems();
            this._comboBox.addItem(SecureFeatureRefTableEditor._DEFAULT_LOGIN_SERVER_VALUE);
            if (this._cavip != null) {
                List items = this._cavip.getAttributeValueItems();
                for (int i = 0; i < items.size(); ++i) {
                    this._comboBox.addItem(((AttributeValueItem)items.get(i)).toString());
                }
            }
        }

        private String invokeWizard() {
            LoginConnectionWizard wizard = new LoginConnectionWizard();
            Context context = Context.newIdeContext();
            boolean ok = wizard.invoke(context);
            if (ok) {
                return wizard.getConnectionId();
            }
            return null;
        }

        private void invokeWizardInEditMode(String connId) {
            Context context = Context.newIdeContext();
            context.setProperty("oracle.jdeveloper.rescat2.connectionId", (Object)connId);
            LoginConnectionWizard wizard = new LoginConnectionWizard();
            try {
                wizard.invoke(context);
            }
            catch (Exception e) {
                ExceptionDialog.showExceptionDialog((Context)context, (Throwable)e);
            }
        }
    }

    private static class DefaultLoginServerTableCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JComponent comp = (JComponent)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (comp instanceof JLabel && (value == null || value.equals(""))) {
                ((JLabel)comp).setText(SecureFeatureRefTableEditor._DEFAULT_LOGIN_SERVER_VALUE);
            }
            return comp;
        }
    }
}

