/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.editor;

import java.util.HashMap;
import java.util.Map;
import oracle.adfmf.framework.dt.editor.SecureFeatureChangeListener;
import oracle.ide.model.Workspace;

public class SecureFeatureChangeManager {
    private static final SecureFeatureChangeManager _INSTANCE = new SecureFeatureChangeManager();
    private static final Map<Workspace, SecureFeatureChangeListener> _LISTENER_MAP = new HashMap<Workspace, SecureFeatureChangeListener>();

    public static SecureFeatureChangeManager getInstance() {
        return _INSTANCE;
    }

    public void fireSecureFeatureChange(Workspace workspace) {
        SecureFeatureChangeListener listener = _LISTENER_MAP.get(workspace);
        if (listener != null) {
            listener.secureFeatureChanged();
        }
    }

    public void addListener(Workspace workspace, SecureFeatureChangeListener listener) {
        _LISTENER_MAP.put(workspace, listener);
    }

    public void removeListener(Workspace workspace, SecureFeatureChangeListener listener) {
        SecureFeatureChangeListener listenerInMap = _LISTENER_MAP.get(workspace);
        assert (listenerInMap.equals(listener));
        _LISTENER_MAP.remove(workspace);
    }

    private SecureFeatureChangeManager() {
    }
}

