/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.editor;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.adfmf.framework.dt.editor.EditorMetadataMethods;
import oracle.bali.xml.grammar.AttributeDef;
import oracle.bali.xml.grammar.GrammarComponent;
import oracle.bali.xml.grammar.SimpleType;
import oracle.bali.xml.grammar.util.AttributeValueUtils;
import oracle.bali.xml.gui.base.xmlComponent.AbstractXmlPropertyEditorDecorator;
import oracle.bali.xml.gui.base.xmlComponent.XmlComponentModel;
import oracle.bali.xml.gui.base.xmlComponent.XmlComponentPropertyEditor;
import oracle.bali.xml.metadata.XmlKey;
import sun.beans.editors.StringEditor;

public class RadioButtonsEditor
extends AbstractXmlPropertyEditorDecorator<String> {
    private JPanel _panel;
    private ButtonGroup _group;
    private List<JRadioButton> _buttonList = new ArrayList<JRadioButton>();
    private List<String> _valueList = new ArrayList<String>();
    private boolean _setSelectedCalled = false;
    private String _defaultValue = null;

    public RadioButtonsEditor() {
        super((PropertyEditor)new StringEditor());
    }

    public Component getXmlComponent() {
        if (this._panel == null) {
            this._panel = new JPanel();
            this._panel.setLayout(new FlowLayout(0, 5, 0));
            this._panel.setBorder(BorderFactory.createEmptyBorder(1, 0, 2, 0));
            this._group = new ButtonGroup();
            XmlComponentModel model = this.getXmlComponentModel();
            XmlKey xmlKey = model.getXmlKey();
            GrammarComponent gc = model.getXmlMetadataResolver().getGrammarComponent(xmlKey);
            AttributeDef attrDef = null;
            if (gc instanceof AttributeDef) {
                attrDef = (AttributeDef)gc;
                Set enumValues = AttributeValueUtils.getAttributeValues((SimpleType)attrDef.getType());
                this._defaultValue = attrDef.getDefaultValue();
                for (String val : enumValues) {
                    CustomRadioButton button = new CustomRadioButton();
                    button.setMargin(new Insets(0, 0, 0, 0));
                    button.setText(EditorMetadataMethods.getDisplayValue(val));
                    this._buttonList.add(button);
                    this._valueList.add(val);
                    this._panel.add(button);
                    button.addItemListener(new ButtonListener());
                    this._group.add(button);
                }
            }
        }
        this.updateXmlComponentFromPropertyValue();
        return this._panel;
    }

    public void updateXmlComponentFromPropertyValue() {
        String value = (String)this.getValue();
        if (value == null || value.trim().length() == 0) {
            value = this._defaultValue;
        }
        for (int i = 0; i < this._valueList.size(); ++i) {
            if (value == null || !value.equals(this._valueList.get(i))) continue;
            this._buttonList.get(i).setSelected(true);
            break;
        }
    }

    public void updatePropertyValueFromXmlComponent() {
        for (int i = 0; i < this._buttonList.size(); ++i) {
            if (!this._buttonList.get(i).isSelected()) continue;
            this.setValue(this._valueList.get(i));
            break;
        }
    }

    public void addChildFocusListener(FocusListener focusListener) {
        for (JRadioButton button : this._buttonList) {
            button.addFocusListener(focusListener);
        }
    }

    public void removeChildFocusListener(FocusListener focusListener) {
        for (JRadioButton button : this._buttonList) {
            button.removeFocusListener(focusListener);
        }
    }

    public XmlComponentPropertyEditor setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (JRadioButton button : this._buttonList) {
            button.setEnabled(enabled);
        }
        return this;
    }

    private final class ButtonListener
    implements ItemListener {
        private ButtonListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (!RadioButtonsEditor.this._setSelectedCalled && itemEvent.getStateChange() == 1) {
                RadioButtonsEditor.this.getXmlComponentWrapper().updateModelFromXmlComponent();
            }
        }
    }

    private final class CustomRadioButton
    extends JRadioButton {
        private CustomRadioButton() {
        }

        @Override
        public void setSelected(boolean b) {
            RadioButtonsEditor.this._setSelectedCalled = true;
            super.setSelected(b);
            RadioButtonsEditor.this._setSelectedCalled = false;
        }
    }
}

