/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.editor;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.ListCellRenderer;
import oracle.adfmf.common.util.McAppUtils;
import oracle.adfmf.framework.dt.ide.FeatureArchive;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.model.metadata.PropertyEditorContext;
import oracle.bali.xml.util.AttributeValueItem;
import oracle.bali.xml.util.ContextualAttributeValueItemProvider;
import oracle.bali.xml.util.DefaultAttributeValueItem;
import oracle.ide.Ide;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;

public class FeatureRefIdContextualAttributeValueItemProvider
extends ContextualAttributeValueItemProvider {
    private JDevXmlContext _xmlContext = null;

    public List<AttributeValueItem> getAttributeValueItems() {
        ArrayList<DefaultAttributeValueItem> featureRefIdList = new ArrayList<DefaultAttributeValueItem>();
        Workspace workspace = this._getWorkspace();
        List<Project> projects = McAppUtils.findProjectsWithFeatures(workspace);
        for (Project project : projects) {
            List<String> featureIds = McAppUtils.getFeatureIdList(project);
            for (String featureId : featureIds) {
                featureRefIdList.add(new DefaultAttributeValueItem(featureId));
            }
        }
        List<URL> farUrls = McAppUtils.getFeatureArchiveURLs(workspace);
        for (URL farUrl : farUrls) {
            FeatureArchive far = new FeatureArchive(farUrl);
            List<String> featureIds = far.getFeatureIds();
            for (String featureId : featureIds) {
                featureRefIdList.add(new DefaultAttributeValueItem(featureId));
            }
        }
        return Collections.unmodifiableList(featureRefIdList);
    }

    public boolean hasCustomRenderer() {
        return false;
    }

    public ListCellRenderer getCustomListCellRenderer(AttributeValueItem item) {
        return null;
    }

    public boolean isConstrainedToEnumeration() {
        return false;
    }

    public void setContext(PropertyEditorContext context) {
        if (context.getXmlContext() instanceof JDevXmlContext) {
            this._xmlContext = (JDevXmlContext)context.getXmlContext();
        } else {
            this.clearContext();
        }
    }

    public void clearContext() {
        this._xmlContext = null;
    }

    protected Workspace _getWorkspace() {
        if (this._xmlContext != null) {
            return this._xmlContext.getWorkspace();
        }
        return Ide.getActiveWorkspace();
    }
}

