/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.editor;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.reflect.Method;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import oracle.adfmf.framework.dt.editor.ErrorTableAdapter;
import oracle.bali.xml.gui.swing.xmlComponent.AbstractXmlTableAdapter;
import oracle.bali.xml.gui.swing.xmlComponent.XmlTableEditor;

public class ErrorTableEditor
extends XmlTableEditor {
    private static final int CLASS_NAME_COLUMN_INDEX = 1;
    private static final int METHOD_COLUMN_INDEX = 2;

    protected AbstractXmlTableAdapter createTableAdapter() {
        return new ErrorTableAdapter(this);
    }

    protected void setTableCellEditors() {
        super.setTableCellEditors();
        TableColumn methodColumn = this.getTable().getColumnModel().getColumn(2);
        methodColumn.setCellEditor(new MethodNamesTableCellEditor());
    }

    private String getSelectedClass() {
        int rowIndex = this.getTable().getSelectedRow();
        if (rowIndex < 0) {
            return "";
        }
        return (String)this.getCellValueAt(this.getTable().getSelectedRow(), 1);
    }

    public void setCellValueAt(Object value, int rowIndex, int columnIndex) {
        if (columnIndex == 1) {
            this.setCellValueAt(null, rowIndex, 2);
        }
        super.setCellValueAt(value, rowIndex, columnIndex);
    }

    private final class MethodNamesTableCellEditor
    extends DefaultCellEditor
    implements ItemListener {
        private JComboBox m_comboBox;
        private String m_currentClassName;

        public MethodNamesTableCellEditor() {
            super(new JComboBox());
        }

        @Override
        public Object getCellEditorValue() {
            return this.m_comboBox.getSelectedItem();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            String currentClassName = ErrorTableEditor.this.getSelectedClass();
            if (this.m_comboBox == null) {
                this.m_comboBox = new JComboBox();
                this.m_comboBox.addItemListener(this);
            } else if (currentClassName == null) {
                this.m_comboBox.removeAllItems();
            }
            if (currentClassName != null && !currentClassName.equals(this.m_currentClassName)) {
                this.m_comboBox.removeAllItems();
                Class<?> selectedClass = null;
                try {
                    Method[] methods;
                    selectedClass = Class.forName(ErrorTableEditor.this.getSelectedClass());
                    for (Method method : methods = selectedClass.getDeclaredMethods()) {
                        this.m_comboBox.addItem(method.getName());
                    }
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
            this.m_comboBox.setSelectedItem(value);
            this.m_currentClassName = currentClassName;
            return this.m_comboBox;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            super.stopCellEditing();
        }
    }
}

