/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.editor;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.bali.xml.metadata.XmlKey;

public class EditorMetadataMethods {
    private static final Map<String, String> _RESOURCE_MAP;
    private static final Map<String, String> _APP_DISPLAY_NAME_MAP;
    private static final Map<String, String> _FEATURE_DISPLAY_NAME_MAP;
    private static final String _APPLICATION_BUNDLE = "oracle.adfmf.framework.dt.editor.resource.ApplicationDescriptions";
    private static final String _FEATURE_BUNDLE = "oracle.adfmf.framework.dt.editor.resource.FeatureDescriptions";
    private static final String _EDITOR_UI_BUNDLE = "oracle.adfmf.framework.dt.editor.resource.EditorUIBundle";

    public static String helpTopic(XmlKey xmlKey) {
        return MobileResourceUtils.getHelpTopic(xmlKey);
    }

    public static String getFeatureShortDescription(XmlKey xmlKey) {
        return MobileResourceUtils.getShortDescription(xmlKey, _FEATURE_BUNDLE);
    }

    public static String getApplicationShortDescription(XmlKey xmlKey) {
        return MobileResourceUtils.getShortDescription(xmlKey, _APPLICATION_BUNDLE);
    }

    public static String getApplicationDisplayName(XmlKey key) {
        return MobileResourceUtils.getDisplayName(_APP_DISPLAY_NAME_MAP, key.getLocalName());
    }

    public static String getFeatureDisplayName(XmlKey key) {
        return MobileResourceUtils.getDisplayName(_FEATURE_DISPLAY_NAME_MAP, key.getLocalName());
    }

    public static String get(String resKey) {
        return MobileResourceUtils.getLocalizedString(resKey, _EDITOR_UI_BUNDLE, true);
    }

    public static String getDisplayValue(String value) {
        String key = _RESOURCE_MAP.get(value);
        return MobileResourceUtils.getLocalizedString(key, _EDITOR_UI_BUNDLE, true);
    }

    static {
        HashMap<String, String> resourceMap = new HashMap<String, String>();
        resourceMap.put("none", "SB_ANIMATION_NONE");
        resourceMap.put("slideright", "SB_ANIMATION_SLIDE_RIGHT");
        _RESOURCE_MAP = Collections.unmodifiableMap(resourceMap);
        HashMap<String, String> displayNameMap = new HashMap<String, String>();
        displayNameMap.put("preferenceBoolean", "Boolean Preference");
        displayNameMap.put("preferenceText", "Text Preference");
        displayNameMap.put("preferenceNumber", "Number Preference");
        displayNameMap.put("navigationBar", "Navigation Bar");
        displayNameMap.put("amx", "ADF Mobile AMX");
        displayNameMap.put("remoteURLWhiteList", "Remote URL White List");
        displayNameMap.put("showOnSpringboard", "Show on Springboard");
        displayNameMap.put("showOnNavigationBar", "Show on Navigation Bar");
        displayNameMap.put("exception", "Exception Type");
        displayNameMap.put("classname", "Handler Class");
        displayNameMap.put("loginConnRefId", "Login Server Connection");
        displayNameMap.put("defaultConnRefId", "Application Login Server");
        displayNameMap.put("appControllerFolder", "Application Controller Folder");
        displayNameMap.put("displayHideShowNavigationBarControl", "Show Navigation Bar Toggle Button");
        displayNameMap.put("displayGotoSpringboardControl", "Show Springboard Toggle Button");
        displayNameMap.put("showSpringboardAtStartup", "Show Springboard on Application Launch");
        displayNameMap.put("animation", "Springboard Animation");
        displayNameMap.put("width", "Slideout Width");
        _APP_DISPLAY_NAME_MAP = Collections.unmodifiableMap(displayNameMap);
        displayNameMap = new HashMap();
        displayNameMap.put("preferenceBoolean", "Boolean Preference");
        displayNameMap.put("preferenceText", "Text Preference");
        displayNameMap.put("preferenceNumber", "Number Preference");
        displayNameMap.put("amx", "ADF Mobile AMX");
        displayNameMap.put("nativeview", "Native View");
        displayNameMap.put("icon", "Navigation Bar Icon");
        displayNameMap.put("image", "Springboard Image");
        displayNameMap.put("listener-class", "Lifecycle Event Listener");
        displayNameMap.put("url", "URL");
        displayNameMap.put("connection", "URL Connection");
        displayNameMap.put("showNavButtons", "Show Browser Navigation Buttons");
        _FEATURE_DISPLAY_NAME_MAP = Collections.unmodifiableMap(displayNameMap);
    }
}

