/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.editor;

import oracle.adfmf.framework.dt.editor.AMXContentPagePropertyEditor;
import oracle.adfmf.framework.dt.editor.ContentPagePropertyEditor;
import oracle.adfmf.framework.dt.editor.FrameworkXmlKeys;
import oracle.adfmf.framework.dt.editor.HtmlContentPagePropertyEditor;
import oracle.adfmf.framework.dt.editor.preference.PanelHelper;
import oracle.bali.xml.gui.base.xmlComponent.XmlComponentWrapper;
import oracle.bali.xml.gui.jdev.xmlComponent.AbstractXmlPanelWrapper;
import oracle.bali.xml.gui.swing.xmlComponent.XmlLayoutOption;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.XmlContext;

public class CustomContentHelper {
    private final AbstractXmlPanelWrapper _panelWrapper;
    private final XmlKey _amxNavigationKey;
    private final XmlKey _htmlNavigationKey;
    private final ContentPagePropertyEditor _amxContentPropertyEditor;
    private final ContentPagePropertyEditor _htmlContentPropertyEditor;

    public CustomContentHelper(AbstractXmlPanelWrapper panelWrapper, XmlKey amxNavigationKey, XmlKey htmlNavigationKey, boolean addNoneButton) {
        this._panelWrapper = panelWrapper;
        this._amxNavigationKey = amxNavigationKey;
        this._htmlNavigationKey = htmlNavigationKey;
        XmlContext xmlContext = this._panelWrapper.getXmlGui().getView().getContext();
        this._amxContentPropertyEditor = new AMXContentPagePropertyEditor(xmlContext, addNoneButton);
        this._htmlContentPropertyEditor = new HtmlContentPagePropertyEditor(xmlContext, addNoneButton);
    }

    public void addComponents() {
        XmlComponentWrapper amxContentWrapper = this._panelWrapper.createXmlComponentWrapper(FrameworkXmlKeys.XMLKEY_FILE_ATTR_AMX).setNavigationXmlKey(this._amxNavigationKey).setPropertyEditor((Object)this._amxContentPropertyEditor);
        XmlComponentWrapper htmlContentWrapper = this._panelWrapper.createXmlComponentWrapper(FrameworkXmlKeys.XMLKEY_URL_ATTR_LOCALHTML).setNavigationXmlKey(this._htmlNavigationKey).setPropertyEditor((Object)this._htmlContentPropertyEditor);
        this._amxContentPropertyEditor.setPeerComponentWrapper(htmlContentWrapper);
        this._htmlContentPropertyEditor.setPeerComponentWrapper(amxContentWrapper);
        if (this._panelWrapper instanceof PanelHelper) {
            ((PanelHelper)this._panelWrapper).addComponent(amxContentWrapper, new XmlLayoutOption().setAddLabel(false).setSpanEntireRow(true));
            ((PanelHelper)this._panelWrapper).addComponent(htmlContentWrapper, new XmlLayoutOption().setAddLabel(false).setSpanEntireRow(true));
        }
    }

    public void addChildWrapper(XmlComponentWrapper childWrapper) {
        this._amxContentPropertyEditor.addChildWrapper(childWrapper);
        this._htmlContentPropertyEditor.addChildWrapper(childWrapper);
    }
}

