/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.editor;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.adfmf.common.util.McAppUtils;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.editor.ChildPropertyEditor;
import oracle.adfmf.framework.dt.editor.EditorMetadataMethods;
import oracle.adfmf.framework.dt.editor.FrameworkXmlEditorConstants;
import oracle.adfmf.framework.dt.editor.feature.FiletypeAttributePropertyEditor;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.gui.base.xmlComponent.XmlComponentPropertyEditor;
import oracle.bali.xml.gui.base.xmlComponent.XmlComponentWrapper;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.task.FixedNameTransactionTask;
import oracle.bali.xml.model.task.ReadOnlyTask;
import oracle.ide.Context;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ContentPagePropertyEditor
extends FiletypeAttributePropertyEditor {
    private JPanel _panel;
    private JPanel _subPanel;
    private JRadioButton _bNone = null;
    private JRadioButton _bDefault;
    private JRadioButton _bCustom;
    private ButtonGroup _group;
    private JComboBox _comboBox;
    private JLabel _label;
    private boolean _addNoneButton = false;
    private boolean _setSelectedCalled = false;
    private boolean _customSelected = false;
    private XmlComponentWrapper _peerComponentWrapper;
    private final List<XmlComponentWrapper> _childWrapperList = new ArrayList<XmlComponentWrapper>();
    private static final int _BORDER_LEFT = 22;
    private static final int _BORDER_WIDTH = 2;
    private static final String _TYPE = "undefined";
    private static final String _PATH_PREFIX = "../../";
    private static final String _PATH_POSTFIX = "/public_html/";
    private static final Logger _LOGGER = Logger.getLogger(ContentPagePropertyEditor.class.getName());

    public ContentPagePropertyEditor(XmlContext xmlContext) {
        super(xmlContext);
    }

    public ContentPagePropertyEditor(XmlContext xmlContext, boolean addNoneButton) {
        super(xmlContext);
        this._addNoneButton = addNoneButton;
    }

    @Override
    public Component getXmlComponent() {
        if (this._panel == null) {
            this._panel = new JPanel();
            this._panel.setLayout(new BoxLayout(this._panel, 3));
            this._group = new ButtonGroup();
            if (this._addNoneButton) {
                this._bNone = new CustomPageRadioButton();
                this._bNone.setText(EditorMetadataMethods.get("NONE"));
                this._panel.add(this._bNone);
                this._bNone.addItemListener(new ButtonListener());
                this._group.add(this._bNone);
            }
            this._bDefault = new CustomPageRadioButton();
            this._bDefault.setText(EditorMetadataMethods.get("DEFAULT"));
            this._panel.add(this._bDefault);
            this._bDefault.addItemListener(new ButtonListener());
            this._bCustom = new CustomPageRadioButton();
            this._bCustom.setText(EditorMetadataMethods.get("CUSTOM"));
            this._panel.add(this._bCustom);
            this._bCustom.addItemListener(new ButtonListener());
            this._group.add(this._bDefault);
            this._group.add(this._bCustom);
            this._subPanel = new JPanel();
            this._subPanel.setBorder(BorderFactory.createEmptyBorder(2, 22, 2, 2));
            this._subPanel.setAlignmentX(0.0f);
            this._subPanel.setLayout(new BoxLayout(this._subPanel, 2));
            this._label = new JLabel(EditorMetadataMethods.get("CONTENT_LABEL"));
            this._comboBox = new JComboBox<String>(new String[]{FrameworkXmlEditorConstants.HTML_TYPE, FrameworkXmlEditorConstants.AMX_TYPE});
            this._comboBox.setSelectedItem(this.getContentType());
            this._comboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    String newValue = (String)ContentPagePropertyEditor.this._comboBox.getSelectedItem();
                    if (newValue != null && !newValue.equals(ContentPagePropertyEditor.this.getContentType())) {
                        ContentPagePropertyEditor.this._changeChildContentElement(newValue);
                        if (ContentPagePropertyEditor.this._peerComponentWrapper != null) {
                            ContentPagePropertyEditor.this._peerComponentWrapper.updateXmlComponentFromModel();
                        }
                        ContentPagePropertyEditor.this.updateXmlComponentFromPropertyValue();
                    }
                }
            });
            this._subPanel.add(this._label);
            this._subPanel.add(Box.createHorizontalStrut(8));
            this._subPanel.add(this._comboBox);
            this._subPanel.add(Box.createHorizontalStrut(8));
            this._subPanel.add(super.getXmlComponent(), "Center");
            this._panel.add(this._subPanel);
        }
        this.updateXmlComponentFromPropertyValue();
        return this._panel;
    }

    @Override
    public void updateXmlComponentFromPropertyValue() {
        String myType = this.getContentType();
        this._comboBox.setSelectedItem(myType);
        String existingElement = this._getChildContentElement();
        this._setButtons(existingElement);
        boolean visible = this.getElementName().equals(existingElement) || myType.equals(FrameworkXmlEditorConstants.HTML_TYPE) && !"amx".equals(existingElement);
        this.setVisible(visible);
        super.updateXmlComponentFromPropertyValue();
    }

    @Override
    public XmlComponentPropertyEditor setEnabled(boolean enabled) {
        boolean myEnabled = enabled && this._customSelected;
        super.setEnabled(myEnabled);
        this._comboBox.setEnabled(myEnabled);
        this._label.setEnabled(myEnabled);
        return this;
    }

    public ContentPagePropertyEditor setPeerComponentWrapper(XmlComponentWrapper peerWrapper) {
        this._peerComponentWrapper = peerWrapper;
        return this;
    }

    public void addChildWrapper(XmlComponentWrapper childWrapper) {
        this._childWrapperList.add(childWrapper);
    }

    @Override
    protected String getRelativePath() {
        String appControllerFolder = this._getAppControllerFolderName();
        return _PATH_PREFIX + appControllerFolder + _PATH_POSTFIX;
    }

    @Override
    protected void setVisible(boolean visible) {
        this._panel.setVisible(visible);
    }

    @Override
    protected Context getIdeContext() {
        Context context = Context.newIdeContext();
        Project project = this._getAppControllerProject();
        if (project != null) {
            context.setProject(project);
        }
        return context;
    }

    protected String getContentType() {
        return _TYPE;
    }

    protected JComboBox getComboBox() {
        return this._comboBox;
    }

    protected String getElementName() {
        return ((QualifiedName)this.getXmlComponentModel().getXmlKey().getElementQNamePath().get(0)).getName();
    }

    private Project _getAppControllerProject() {
        assert (this.getXmlContext() instanceof JDevXmlContext);
        Workspace workspace = ((JDevXmlContext)this.getXmlContext()).getWorkspace();
        String appControllerFolder = this._getAppControllerFolderName();
        return McAppUtils.findApplicationControllerProject(workspace, null, appControllerFolder);
    }

    private String _getAppControllerFolderName() {
        return (String)new ReadOnlyTask<String>(){

            protected String runImpl(AbstractModel model) {
                Element root = ContentPagePropertyEditor.this.getXmlContext().getModel().getDocument().getDocumentElement();
                String appControllerAttr = root.getAttributeNS(null, "appControllerFolder");
                if (appControllerAttr != null && appControllerAttr.trim().length() > 0) {
                    return appControllerAttr;
                }
                return "ApplicationController";
            }
        }.run((AbstractModel)this.getXmlComponentModel().getView());
    }

    private Node _createSpringboardNode() {
        Node navigation = this._findOrCreateNavigationNode();
        Element element = this._getDocument().createElementNS("http://xmlns.oracle.com/adf/mf", McAppUtils.getQualifiedName("springboard"));
        navigation.appendChild(element);
        return element;
    }

    private Node _findOrCreateNavigationNode() {
        int count;
        Document doc = this._getDocument();
        Element root = doc.getDocumentElement();
        NodeList parent = root.getElementsByTagNameNS("http://xmlns.oracle.com/adf/mf", "navigation");
        int n = count = parent != null ? parent.getLength() : 0;
        if (count == 1) {
            return parent.item(0);
        }
        return this._createNavigationNode();
    }

    private Node _createNavigationNode() {
        Document doc = this._getDocument();
        Element root = doc.getDocumentElement();
        Element element = this._getDocument().createElementNS("http://xmlns.oracle.com/adf/mf", McAppUtils.getQualifiedName("navigation"));
        try {
            this.getXmlComponentModel().getView().getBaseModel().insertNode((Node)element, DomPositionFactory.inside((Node)root), false);
        }
        catch (Exception e) {
            _LOGGER.log(Level.SEVERE, MobileResourceUtils.getMsg("ADF-MBL-00080", e));
        }
        return element;
    }

    private Node _createErrorNode() {
        Document doc = this._getDocument();
        Element root = doc.getDocumentElement();
        Element element = this._getDocument().createElementNS("http://xmlns.oracle.com/adf/mf", McAppUtils.getQualifiedName("error"));
        try {
            this.getXmlComponentModel().getView().getBaseModel().insertNode((Node)element, DomPositionFactory.inside((Node)root), false);
        }
        catch (Exception e) {
            _LOGGER.log(Level.SEVERE, MobileResourceUtils.getMsg("ADF-MBL-00081", e));
        }
        return element;
    }

    private Node _createLoginNode() {
        Document doc = this._getDocument();
        Element root = doc.getDocumentElement();
        Element element = this._getDocument().createElementNS("http://xmlns.oracle.com/adf/mf", McAppUtils.getQualifiedName("login"));
        try {
            this.getXmlComponentModel().getView().getBaseModel().insertNode((Node)element, DomPositionFactory.inside((Node)root), false);
        }
        catch (Exception e) {
            _LOGGER.log(Level.SEVERE, MobileResourceUtils.getMsg("ADF-MBL-00082", e));
        }
        return element;
    }

    private Node _createParentNode(String elementName) {
        if ("login".equals(elementName)) {
            return this._createLoginNode();
        }
        if ("error".equals(elementName)) {
            return this._createErrorNode();
        }
        if ("navigation".equals(elementName)) {
            return this._createNavigationNode();
        }
        if ("springboard".equals(elementName)) {
            return this._createSpringboardNode();
        }
        return null;
    }

    private Node _getParentNode(boolean createIfNotExist) {
        int count;
        int index = this.getXmlComponentModel().getNavigationXmlKey().getElementQNamePath().size() - 2;
        String parentElementName = ((QualifiedName)this.getXmlComponentModel().getNavigationXmlKey().getElementQNamePath().get(index)).getName();
        Document doc = this._getDocument();
        Element root = doc.getDocumentElement();
        NodeList parent = root.getElementsByTagNameNS("http://xmlns.oracle.com/adf/mf", parentElementName);
        int n = count = parent != null ? parent.getLength() : 0;
        if (count == 1) {
            return parent.item(0);
        }
        if (createIfNotExist) {
            return this._createParentNode(parentElementName);
        }
        return null;
    }

    private void _changeChildContentElement(final String newType) {
        new FixedNameTransactionTask("set attribute values..."){

            protected void performTask(AbstractModel model) throws XmlCommitException {
                Node parentNode = ContentPagePropertyEditor.this._getParentNode(false);
                if (parentNode != null) {
                    Node child = parentNode.getFirstChild();
                    String elementName = ContentPagePropertyEditor.this._getElementNameByType(newType);
                    if (child != null && child instanceof Element) {
                        if (elementName.equals(child.getLocalName())) {
                            return;
                        }
                        parentNode.removeChild(child);
                    }
                    Element element = ContentPagePropertyEditor.this._getDocument().createElementNS("http://xmlns.oracle.com/adf/mf", McAppUtils.getQualifiedName(elementName));
                    parentNode.appendChild(element);
                }
            }
        }.run((AbstractModel)this.getXmlComponentModel().getView());
    }

    private void _deleteChildContentElement() {
        new FixedNameTransactionTask("set attribute values..."){

            protected void performTask(AbstractModel model) throws XmlCommitException {
                Node child;
                Node parentNode = ContentPagePropertyEditor.this._getParentNode(false);
                if (parentNode != null && (child = parentNode.getFirstChild()) != null) {
                    parentNode.removeChild(child);
                }
            }
        }.run((AbstractModel)this.getXmlComponentModel().getView());
    }

    private void _createChildContentElement() {
        new FixedNameTransactionTask("set attribute values..."){

            protected void performTask(AbstractModel model) throws XmlCommitException {
                Node parentNode = ContentPagePropertyEditor.this._getParentNode(true);
                if (parentNode != null) {
                    Node child = parentNode.getFirstChild();
                    String elementName = ContentPagePropertyEditor.this.getElementName();
                    if (child != null && child instanceof Element && elementName.equals(child.getLocalName())) {
                        return;
                    }
                    Element element = ContentPagePropertyEditor.this._getDocument().createElementNS("http://xmlns.oracle.com/adf/mf", McAppUtils.getQualifiedName(elementName));
                    parentNode.appendChild(element);
                }
            }
        }.run((AbstractModel)this.getXmlComponentModel().getView());
    }

    private String _getChildContentElement() {
        return (String)new ReadOnlyTask<String>(){

            protected String runImpl(AbstractModel model) {
                Node child;
                Node parentNode = ContentPagePropertyEditor.this._getParentNode(false);
                if (parentNode != null && (child = parentNode.getFirstChild()) instanceof Element) {
                    return child.getLocalName();
                }
                return null;
            }
        }.run((AbstractModel)this.getXmlComponentModel().getView());
    }

    private Boolean _isEnabled() {
        return (Boolean)new ReadOnlyTask<Boolean>(){

            protected Boolean runImpl(AbstractModel model) {
                if (ContentPagePropertyEditor.this._addNoneButton) {
                    Node parentNode = ContentPagePropertyEditor.this._getParentNode(false);
                    if (parentNode != null) {
                        return "true".equals(((Element)parentNode).getAttributeNS(null, "enabled"));
                    }
                    return false;
                }
                return true;
            }
        }.run((AbstractModel)this.getXmlComponentModel().getView());
    }

    private void _setEnabledAttribute(final boolean enabled) {
        new FixedNameTransactionTask("set attribute values..."){

            protected void performTask(AbstractModel model) throws XmlCommitException {
                boolean createParent;
                Node parentNode;
                if (ContentPagePropertyEditor.this._addNoneButton && (parentNode = ContentPagePropertyEditor.this._getParentNode(createParent = enabled)) != null) {
                    if (enabled) {
                        ((Element)parentNode).setAttributeNS(null, "enabled", "true");
                    } else {
                        ((Element)parentNode).setAttributeNS(null, "enabled", "false");
                    }
                }
            }
        }.run((AbstractModel)this.getXmlComponentModel().getView());
    }

    private void _setButtons(String existingElement) {
        if (this._addNoneButton && !this._isEnabled().booleanValue()) {
            this._bNone.setSelected(true);
            this._customSelected = false;
            this._enableChildComponents(false);
            return;
        }
        this._enableChildComponents(true);
        if (existingElement != null && existingElement.trim().length() > 0) {
            this._bCustom.setSelected(true);
            this._customSelected = true;
        } else {
            this._bDefault.setSelected(true);
            this._customSelected = false;
        }
    }

    private void _enableChildComponents(boolean enabled) {
        for (XmlComponentWrapper childWrapper : this._childWrapperList) {
            XmlComponentPropertyEditor editor = childWrapper.getPropertyEditor();
            if (!(editor instanceof ChildPropertyEditor)) continue;
            ((ChildPropertyEditor)editor).enabledByParent(enabled);
        }
    }

    private Document _getDocument() {
        return this.getXmlComponentModel().getView().getDocument();
    }

    private String _getElementNameByType(String type) {
        if (FrameworkXmlEditorConstants.AMX_TYPE.equals(type)) {
            return "amx";
        }
        return "localHTML";
    }

    private final class ButtonListener
    implements ItemListener {
        private ButtonListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (!ContentPagePropertyEditor.this._setSelectedCalled && itemEvent.getStateChange() == 1) {
                Object source = itemEvent.getSource();
                if (source == ContentPagePropertyEditor.this._bNone) {
                    ContentPagePropertyEditor.this._setEnabledAttribute(false);
                } else {
                    ContentPagePropertyEditor.this._setEnabledAttribute(true);
                }
                if (source == ContentPagePropertyEditor.this._bDefault || source == ContentPagePropertyEditor.this._bNone) {
                    ContentPagePropertyEditor.this._deleteChildContentElement();
                    ContentPagePropertyEditor.this._customSelected = false;
                } else if (source == ContentPagePropertyEditor.this._bCustom) {
                    ContentPagePropertyEditor.this._createChildContentElement();
                    ContentPagePropertyEditor.this._customSelected = true;
                }
                if (ContentPagePropertyEditor.this._peerComponentWrapper != null) {
                    ContentPagePropertyEditor.this._peerComponentWrapper.updateXmlComponentFromModel();
                }
                ContentPagePropertyEditor.this.getXmlComponentWrapper().updateXmlComponentFromModel();
            }
        }
    }

    private final class CustomPageRadioButton
    extends JRadioButton {
        private CustomPageRadioButton() {
        }

        @Override
        public void setSelected(boolean b) {
            ContentPagePropertyEditor.this._setSelectedCalled = true;
            super.setSelected(b);
            ContentPagePropertyEditor.this._setSelectedCalled = false;
        }
    }
}

