/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.editor;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.ListCellRenderer;
import oracle.adfmf.common.util.McAppUtils;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.metadata.PropertyEditorContext;
import oracle.bali.xml.util.AttributeValueItem;
import oracle.bali.xml.util.ContextualAttributeValueItemProvider;
import oracle.bali.xml.util.DefaultAttributeValueItem;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class ConnectionContextualAttrValueItemProvider
extends ContextualAttributeValueItemProvider {
    private JDevXmlContext _xmlContext = null;
    private static final String _ATTR_REFERENCE = "Reference";
    private static final String _ATTR_NAME = "name";
    private static final String _ATTR_CLASSNAME = "className";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AttributeValueItem> getAttributeValueItems() {
        ArrayList<DefaultAttributeValueItem> loginConnIdList = new ArrayList<DefaultAttributeValueItem>();
        URL connectionsXmlUrl = McAppUtils.getConnectionsXmlURL(this._getWorkspace());
        Node node = null;
        if (URLFileSystem.exists((URL)connectionsXmlUrl)) {
            try {
                node = NodeFactory.findOrCreate((URL)connectionsXmlUrl);
            }
            catch (Exception e) {
                node = null;
            }
        }
        if (node != null) {
            Context ideContext = new Context(null, this._getWorkspace(), null, node);
            JDevXmlContext xmlContext = JDevXmlContext.getXmlContext((Context)ideContext);
            XmlModel model = xmlContext.getModel();
            model.acquireReadLock();
            try {
                Element rootNode = model.getDocument().getDocumentElement();
                NodeList childNodes = rootNode.getChildNodes();
                if (childNodes != null) {
                    for (int i = 0; i < childNodes.getLength(); ++i) {
                        org.w3c.dom.Node child = childNodes.item(i);
                        if (!(child instanceof Element) || !_ATTR_REFERENCE.equals(child.getNodeName())) continue;
                        String name = ((Element)child).getAttributeNS(null, _ATTR_NAME);
                        String className = ((Element)child).getAttributeNS(null, _ATTR_CLASSNAME);
                        if (name == null || name.trim().length() <= 0 || !this.isSupportedConnType(className)) continue;
                        loginConnIdList.add(new DefaultAttributeValueItem(name));
                    }
                }
            }
            finally {
                model.releaseReadLock();
            }
        }
        return Collections.unmodifiableList(loginConnIdList);
    }

    public boolean hasCustomRenderer() {
        return false;
    }

    public ListCellRenderer getCustomListCellRenderer(AttributeValueItem item) {
        return null;
    }

    public boolean isConstrainedToEnumeration() {
        return false;
    }

    public void setContext(PropertyEditorContext context) {
        if (context.getXmlContext() instanceof JDevXmlContext) {
            this._xmlContext = (JDevXmlContext)context.getXmlContext();
        } else {
            this.clearContext();
        }
    }

    public void clearContext() {
        this._xmlContext = null;
    }

    public void setXmlContext(JDevXmlContext xmlContext) {
        this._xmlContext = xmlContext;
    }

    protected Workspace _getWorkspace() {
        if (this._xmlContext != null) {
            return this._xmlContext.getWorkspace();
        }
        return Ide.getActiveWorkspace();
    }

    protected abstract boolean isSupportedConnType(String var1);
}

