/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.editor;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import oracle.adfmf.framework.dt.editor.ComboBoxEditor;
import oracle.adfmf.framework.dt.editor.ConnectionContextualAttrValueItemProvider;
import oracle.adfmf.framework.dt.editor.EditorMetadataMethods;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.util.AttributeValueItem;
import oracle.bali.xml.util.ContextualAttributeValueItemProvider;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.plaf.IconicButtonUI;

public abstract class ConnectionAttributePropertyEditor
extends ComboBoxEditor
implements ActionListener {
    private JPanel _panel = null;
    private JButton _addButton = null;
    private JButton _editButton = null;
    protected static final String _DEFAULT = "          ";

    @Override
    public Component getXmlComponent() {
        JComboBox comboBox = (JComboBox)super.getXmlComponent();
        if (this._panel == null) {
            this._panel = new JPanel();
            this._panel.setLayout(new BoxLayout(this._panel, 2));
            this._panel.add((Component)comboBox, "Center");
            this._panel.add(Box.createHorizontalStrut(6));
            this._addButton = new JButton(OracleIcons.getIcon((String)"add.png"));
            this._addButton.addActionListener(this);
            this._addButton.setToolTipText(EditorMetadataMethods.get("CREATE_CONN"));
            IconicButtonUI.install((AbstractButton)this._addButton);
            this._panel.add((Component)this._addButton, "East");
            this._editButton = new JButton(OracleIcons.getIcon((String)"edit.png"));
            this._editButton.addActionListener(this);
            this._editButton.setToolTipText(EditorMetadataMethods.get("EDIT_CONN"));
            IconicButtonUI.install((AbstractButton)this._editButton);
            this._panel.add((Component)this._editButton, "East");
        }
        return this._panel;
    }

    @Override
    public void updateXmlComponentFromPropertyValue() {
        super.updateXmlComponentFromPropertyValue();
        String value = this.getAsText();
        if (value == null || "".equals(value)) {
            this.enableEditButton(false);
        } else {
            this.enableEditButton(true);
        }
    }

    public void addItems() {
        XmlContext xmlContext;
        this.getComboBoxModel().removeAll();
        this.getComboBoxModel().addElement((Object)_DEFAULT);
        ContextualAttributeValueItemProvider cavip = this.getXmlComponentModel().getXmlMetadataResolver().getContextualAttributeValueItemProvider(this.getXmlComponentModel().getXmlKey());
        if (cavip instanceof ConnectionContextualAttrValueItemProvider && (xmlContext = this.getXmlComponentModel().getView().getContext()) instanceof JDevXmlContext) {
            ((ConnectionContextualAttrValueItemProvider)cavip).setXmlContext((JDevXmlContext)xmlContext);
            List connIdList = cavip.getAttributeValueItems();
            for (int i = 0; i < connIdList.size(); ++i) {
                this.getComboBoxModel().addElement((Object)((AttributeValueItem)connIdList.get(i)).toString());
            }
            cavip.clearContext();
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String connId;
        Object source = event.getSource();
        if (source == this._addButton) {
            String connId2 = this.invokeWizardInAddMode();
            if (connId2 != null) {
                this.getComboBoxModel().addElement((Object)connId2);
                this.getComboBox().setSelectedItem(connId2);
            }
        } else if (source == this._editButton && (connId = (String)this.getComboBox().getSelectedItem()) != null && !_DEFAULT.equals(connId) && connId.trim().length() > 0) {
            this.invokeWizardInEditMode(connId);
        }
    }

    public void setVisible(boolean visible) {
        this._panel.setVisible(visible);
        ((JComponent)this._panel.getClientProperty("labeledBy")).setVisible(visible);
    }

    @Override
    protected String getDefaultValue() {
        return _DEFAULT;
    }

    private void enableEditButton(boolean enabled) {
        if (this._editButton != null) {
            this._editButton.setEnabled(enabled);
        }
    }

    protected abstract String invokeWizardInAddMode();

    protected abstract void invokeWizardInEditMode(String var1);
}

