/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.editor;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyEditor;
import javax.swing.JCheckBox;
import oracle.adfmf.framework.dt.editor.ChildPropertyEditor;
import oracle.bali.xml.gui.base.inspector.editors.BooleanEditor;
import oracle.bali.xml.gui.base.xmlComponent.AbstractXmlPropertyEditorDecorator;
import oracle.bali.xml.gui.base.xmlComponent.XmlComponentModel;
import oracle.bali.xml.gui.base.xmlComponent.XmlComponentPropertyEditor;

public class CheckBoxEditor
extends AbstractXmlPropertyEditorDecorator<Boolean>
implements ChildPropertyEditor {
    private boolean _setSelectedCalled = false;
    private JCheckBox _checkBox;
    private String _label = null;
    private boolean _enabledByParent = true;

    public CheckBoxEditor() {
        super((PropertyEditor)new BooleanEditor());
    }

    public CheckBoxEditor(String customLabel) {
        super((PropertyEditor)new BooleanEditor());
        this._label = customLabel;
    }

    public Component getXmlComponent() {
        if (this._checkBox == null) {
            this._checkBox = new CustomCheckBox();
            this._checkBox.setMargin(new Insets(-1, 0, 0, 0));
            if (this._label != null) {
                this._checkBox.setText(this._label);
            } else {
                this._checkBox.setText(this.getXmlComponentWrapper().getXmlComponentModel().getShortDisplayName());
            }
            this._checkBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (!CheckBoxEditor.this._setSelectedCalled) {
                        CheckBoxEditor.this.getXmlComponentWrapper().updateModelFromXmlComponent();
                    }
                }
            });
        }
        this.updateXmlComponentFromPropertyValue();
        return this._checkBox;
    }

    public void updateXmlComponentFromPropertyValue() {
        XmlComponentModel model = this.getXmlComponentModel();
        String defaultVal = model.getXmlMetadataResolver().getDefaultValue(model.getXmlKey());
        boolean defaultTrue = "true".equals(defaultVal);
        if (defaultTrue && "false".equals(this.getAsText()) || !defaultTrue && !"true".equals(this.getAsText())) {
            this._checkBox.setSelected(false);
        } else {
            this._checkBox.setSelected(true);
        }
    }

    public void updatePropertyValueFromXmlComponent() {
        this.setValue(this._checkBox.isSelected() ? "true" : "false");
    }

    public XmlComponentPropertyEditor setEnabled(boolean enabled) {
        boolean myenabled = enabled & this._enabledByParent;
        super.setEnabled(myenabled);
        return this;
    }

    @Override
    public void enabledByParent(boolean enabled) {
        this._enabledByParent = enabled;
        this.setEnabled(enabled);
    }

    private final class CustomCheckBox
    extends JCheckBox {
        private CustomCheckBox() {
        }

        @Override
        public void setSelected(boolean b) {
            CheckBoxEditor.this._setSelectedCalled = true;
            super.setSelected(b);
            CheckBoxEditor.this._setSelectedCalled = false;
        }
    }
}

