/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.editor;

import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.adfmf.common.util.McAppUtils;
import oracle.adfmf.framework.dt.editor.ApplicationUrlReference;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.gui.jdev.dependency.url.UrlReferenceFactory;
import oracle.bali.xml.indexing.IndexingFactory;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.dependency.Reference;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import org.w3c.dom.Node;

public final class ApplicationUrlReferenceFactory
extends UrlReferenceFactory {
    public Collection<Reference> getReferences(XmlContext context, Node node, String value) {
        if (!(context instanceof JDevXmlContext)) {
            return null;
        }
        JDevXmlContext jdevXmlContext = (JDevXmlContext)context;
        Project project = McAppUtils.getApplicationControllerProject(jdevXmlContext.getWorkspace(), null);
        if (project == null) {
            return null;
        }
        URL publicHtmlDir = McAppUtils.getProjectPublicHtmlDir(project);
        URL fileUrl = URLFileSystem.canonicalize((URL)URLFactory.newURL((URL)publicHtmlDir, (String)value));
        return Collections.singletonList(new ApplicationUrlReference(context, node, 0, value.length(), fileUrl, project));
    }

    public List<IndexingFactory.IndexEntry> getIndexEntries(QualifiedName elementQN, QualifiedName attrQN, String value) {
        String indexValue = value.trim();
        int lastSlash = indexValue.lastIndexOf("/");
        if (lastSlash >= 0) {
            indexValue = indexValue.substring(lastSlash + 1);
        }
        IndexingFactory.IndexEntry entry = new IndexingFactory.IndexEntry(this.getIndexKey(), indexValue, 0, value.length());
        return Collections.singletonList(entry);
    }
}

