/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.editor;

import java.net.URL;
import oracle.adfmf.amx.dt.editor.AMXFileBuilder;
import oracle.adfmf.common.util.McAppUtils;
import oracle.adfmf.framework.dt.editor.ContentPagePropertyEditor;
import oracle.adfmf.framework.dt.editor.EditorMetadataMethods;
import oracle.adfmf.framework.dt.editor.FrameworkXmlEditorConstants;
import oracle.bali.xml.model.XmlContext;
import oracle.ide.Context;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;

public class AMXContentPagePropertyEditor
extends ContentPagePropertyEditor {
    private static final String _AMX_EXT = ".amx";

    public AMXContentPagePropertyEditor(XmlContext xmlContext) {
        super(xmlContext);
    }

    public AMXContentPagePropertyEditor(XmlContext xmlContext, boolean addNoneButton) {
        super(xmlContext, addNoneButton);
    }

    @Override
    protected URL popNewFileDialog() {
        boolean ok;
        AMXFileBuilder wizard = new AMXFileBuilder();
        Context context = this.getIdeContext();
        URL dirURL = this.getDefaultDirURL(context);
        if (dirURL != null) {
            String[] params = new String[]{dirURL.toString()};
            AMXFileBuilder.setLegacyParams((Context)context, (String[])params);
        }
        if (ok = wizard.invoke(context)) {
            String[] returnParams = AMXFileBuilder.getLegacyParams((Context)context);
            if (returnParams != null && returnParams.length > 0) {
                return URLFactory.newURL((String)returnParams[0]);
            }
        }
        return null;
    }

    @Override
    protected URLFilter getURLFilter() {
        if (super.getURLFilter() == null) {
            this.setURLFilter((URLFilter)new DefaultURLFilter(EditorMetadataMethods.get("AMX_PAGE"), _AMX_EXT));
        }
        return super.getURLFilter();
    }

    @Override
    protected String getContentType() {
        return FrameworkXmlEditorConstants.AMX_TYPE;
    }

    @Override
    protected boolean isSupportedFileType(String filename) {
        return McAppUtils.isAmxFile(filename);
    }
}

