/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.ios.wizard;

import java.net.URL;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.deploy.cmd.McAppProfileDeployCommand;
import oracle.adfmf.framework.dt.deploy.ios.McIosFrameworkProfile;
import oracle.adfmf.framework.dt.deploy.ios.core.IosDeployUtil;
import oracle.adfmf.framework.dt.deploy.ios.core.IosFileUtils;
import oracle.adfmf.framework.dt.deploy.ios.ui.editor.options.DeploymentOptions;
import oracle.adfmf.framework.dt.deploy.ios.wizard.commands.DeployToIosDeviceCmd;
import oracle.adfmf.framework.dt.deploy.ios.wizard.commands.DeployToIosEmulatorCmd;
import oracle.adfmf.framework.dt.deploy.ios.wizard.commands.DeployToIosPackageCmd;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.TraversableContext;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.deploy.Profile;
import oracle.jdeveloper.deploy.cmd.DeployCommand;
import oracle.jdeveloper.deploy.dt.wizard.spi.AbstractDeploySummaryProvider;
import oracle.jdeveloper.deploy.spi.Cookie;
import oracle.jdeveloper.deploy.tk.spi.ToolkitContext;

public class IosDeploySummaryBuilder
extends AbstractDeploySummaryProvider {
    private Workspace _workspace;

    protected boolean shouldCreateFor(DeployCommand deployCommand, ToolkitContext context, Cookie cookie) {
        if (deployCommand instanceof DeployToIosDeviceCmd || deployCommand instanceof DeployToIosEmulatorCmd || deployCommand instanceof DeployToIosPackageCmd) {
            this._workspace = context.getIdeContext().getWorkspace();
            return true;
        }
        return false;
    }

    public Class getTypeForNarrow() {
        return McIosFrameworkProfile.class;
    }

    protected TreeNode buildSummary(DeployCommand deployCommand, TraversableContext tc, Cookie cookie) {
        assert (deployCommand instanceof McAppProfileDeployCommand);
        McAppProfileDeployCommand cmd = (McAppProfileDeployCommand)deployCommand;
        Profile profile = cmd.getProfile();
        assert (profile instanceof McIosFrameworkProfile);
        McIosFrameworkProfile iosFrameworkProfile = (McIosFrameworkProfile)profile;
        String appDetailDescription = MobileResourceUtils.getText("DEPLOY_SUMMARY_APPLICATION_DETAIL_DESCRIPTION");
        DefaultMutableTreeNode appDetail = new DefaultMutableTreeNode(appDetailDescription);
        if (null != this._workspace) {
            try {
                IosFileUtils iosFileUtils = new IosFileUtils(this._workspace, iosFrameworkProfile);
                DeploymentOptions options = iosFrameworkProfile.getDeploymentOptions();
                String appBundleIdInfo = MobileResourceUtils.getText("DEPLOY_SUMMARY_APPLICATION_BUNDLE_ID_DESCRIPTION", options.getAppBundleId());
                appDetail.add(new DefaultMutableTreeNode(appBundleIdInfo));
                String deployFileName = URLFileSystem.getFileName((URL)iosFileUtils.getBuiltApplicationUrl());
                String fileNameInfo = MobileResourceUtils.getText("DEPLOY_SUMMARY_FILE_DESCRIPTION", deployFileName);
                appDetail.add(new DefaultMutableTreeNode(fileNameInfo));
                String deploySummarySignature = IosDeployUtil.getCertificate();
                if (!ModelUtil.hasLength((String)deploySummarySignature)) {
                    deploySummarySignature = MobileResourceUtils.getText("DEPLOY_SUMMARY_OPTION_NOT_SPECIFIED_DESCRIPTION");
                }
                String signatureInfo = MobileResourceUtils.getText("IOS_DEPLOY_SUMMARY_SIGNATURE_DESCRIPTION", deploySummarySignature);
                appDetail.add(new DefaultMutableTreeNode(signatureInfo));
                String provisioningProfile = IosDeployUtil.getProvisioningProfile();
                if (!ModelUtil.hasLength((String)provisioningProfile)) {
                    provisioningProfile = MobileResourceUtils.getText("DEPLOY_SUMMARY_OPTION_NOT_SPECIFIED_DESCRIPTION");
                }
                String provisioningProfileInfo = MobileResourceUtils.getText("IOS_DEPLOY_SUMMARY_PROVISIONING_PROFILE_DESCRIPTION", provisioningProfile);
                appDetail.add(new DefaultMutableTreeNode(provisioningProfileInfo));
            }
            catch (DeployException e) {
                // empty catch block
            }
        }
        return appDetail;
    }
}

