/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.ios.ui.editor.panels;

import java.awt.Component;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.JCheckBox;
import oracle.adfmf.common.ControlGroupPanel;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.deploy.editor.McArchiveEditor;
import oracle.adfmf.framework.dt.deploy.editor.options.ImageOptions;
import oracle.adfmf.framework.dt.deploy.editor.panels.ImagePanel;
import oracle.adfmf.framework.dt.deploy.ios.core.IosImageUtil;
import oracle.adfmf.framework.dt.deploy.ios.ui.editor.IosArchiveEditor;
import oracle.adfmf.framework.dt.deploy.ios.ui.editor.options.DeploymentOptions;
import oracle.adfmf.framework.dt.deploy.ios.ui.editor.panels.ITunesArtworkOptionsPanel;
import oracle.adfmf.framework.dt.deploy.ios.ui.editor.panels.IosDeviceImageOptionsPanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;

public class IosImagePanel
extends ImagePanel {
    protected static final String HELP_ID = "f1_adfmf_deployment_iosicon_html";
    private static final long serialVersionUID = 1L;
    private JCheckBox _usePrerenderedIconCheckBox;
    private ITunesArtworkOptionsPanel _iTunesArtworkOptionsPanel;

    public IosImagePanel() {
        this.setHelpID(HELP_ID);
        this.setPanelHint(MobileResourceUtils.getText("IMAGE_OPTIONS_OVERRIDE_DEFAULTS_LABEL"));
        this.createControls();
    }

    @Override
    public void onEntry(TraversableContext context) {
        DeploymentOptions opts;
        super.onEntry(context);
        ImageOptions imageOptions = McArchiveEditor.getImageOptions((Namespace)context);
        if (null != imageOptions) {
            IosImageUtil.addDefaultsToImageOptions(imageOptions);
            this.getDeviceImageOptionsPanel().onEntry(context);
            this._iTunesArtworkOptionsPanel.initializeImageControlsData(imageOptions);
        }
        if (null != (opts = IosArchiveEditor.getDeploymentOptions((Namespace)context))) {
            this._usePrerenderedIconCheckBox.setSelected(opts.getUsePrerenderedIcons());
        }
    }

    @Override
    public void onExit(TraversableContext tc) throws TraversalException {
        DeploymentOptions opts;
        super.onExit(tc);
        ImageOptions imageOptions = McArchiveEditor.getImageOptions((Namespace)tc);
        if (null != imageOptions) {
            this._iTunesArtworkOptionsPanel.getImageControlsData(imageOptions);
        }
        if ((opts = IosArchiveEditor.getDeploymentOptions((Namespace)tc)) != null) {
            opts.setUsePrerenderedIcons(this._usePrerenderedIconCheckBox.isSelected());
        }
    }

    @Override
    protected void createControls() {
        ControlGroupPanel parentPanel = new ControlGroupPanel();
        this.setDeviceImageOptionsPanel(new IosDeviceImageOptionsPanel());
        boolean gridX = false;
        int gridY = 0;
        this.addHintLabel(parentPanel, 0, gridY++);
        this._usePrerenderedIconCheckBox = parentPanel.addCheckbox(MobileResourceUtils.getText("APP_PRERENDERED_ICON_LABEL"), 0, gridY++, false);
        this._iTunesArtworkOptionsPanel = new ITunesArtworkOptionsPanel(new String[]{".png"});
        parentPanel.addPanel(this._iTunesArtworkOptionsPanel.getPanel(), 0, gridY++);
        this.addDeviceImageOptionsPanel(parentPanel, 0, gridY++);
        boolean containerGridX = false;
        int containerGridY = 0;
        int HORIZONTAL_INDENT_PANEL = 6;
        this.add((Component)((Object)parentPanel), this.gbc(0, containerGridY++, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 6, 0, 0)));
        this.add(Box.createGlue(), this.gbc(0, containerGridY, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0)));
    }
}

