/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.ios.ui.editor.panels;

import java.awt.Component;
import java.awt.Insets;
import javax.swing.Box;
import oracle.adfmf.common.ControlGroupPanel;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.deploy.editor.panels.DeviceImageOptionsPanel;
import oracle.adfmf.framework.dt.deploy.editor.panels.ImageOptionsChooserPanel;

public class IosDeviceImageOptionsPanel
extends DeviceImageOptionsPanel {
    private static final String[][] _deviceTypes = new String[][]{{"iPhone", MobileResourceUtils.getText("IOS_DEVICE_IPHONE3")}, {"iPhone Retina", MobileResourceUtils.getText("IOS_DEVICE_IPHONE4S")}, {"iPhone 5", MobileResourceUtils.getText("IOS_DEVICE_IPHONE5")}, {"iPad", MobileResourceUtils.getText("IOS_DEVICE_IPAD")}, {"iPad Retina", MobileResourceUtils.getText("IOS_DEVICE_IPAD3")}, {"iPad Mini", MobileResourceUtils.getText("IOS_DEVICE_IPAD_MINI")}};
    private static final long serialVersionUID = 1L;
    private static final String HELP_ID = "f1_adfmf_deployment_iosicon_html";

    public IosDeviceImageOptionsPanel() {
        this.setHelpID(HELP_ID);
        this.setPanelHint(MobileResourceUtils.getText("IMAGE_OPTIONS_OVERRIDE_DEFAULTS_LABEL"));
        this.createPlatformDisplayTypes();
        this.createControls();
    }

    @Override
    protected void createPlatformDisplayTypes() {
        for (int index = 0; index < _deviceTypes.length; ++index) {
            String deviceType = _deviceTypes[index][0];
            String translatedDeviceType = _deviceTypes[index][0];
            this._imageOptionsChooserPanelMap.put(deviceType, new ImageOptionsChooserPanel(deviceType, translatedDeviceType, new String[]{".png"}));
        }
    }

    @Override
    protected void createControls() {
        ControlGroupPanel parentPanel = new ControlGroupPanel();
        boolean gridX = false;
        int gridY = 0;
        parentPanel.addLabeledSeparator(MobileResourceUtils.getText("APPLICATION_IMAGE"), 0, gridY++);
        this.addPlatformListPanel(parentPanel, 0, gridY++);
        this.addImageOptionsChooserPanel(parentPanel, 0, gridY++);
        boolean containerGridX = false;
        int containerGridY = 0;
        int HORIZONTAL_INDENT_SDK_PANEL = 6;
        this.add((Component)((Object)parentPanel), this.gbc(0, containerGridY++, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 6, 0, 0)));
        this.add(Box.createGlue(), this.gbc(0, containerGridY, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0)));
    }
}

