/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.ios.ui.editor.panels;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import oracle.adfmf.common.ControlGroupPanel;
import oracle.adfmf.common.McTwoColumnPanel;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.deploy.ios.ui.editor.IosArchiveEditor;
import oracle.adfmf.framework.dt.deploy.ios.ui.editor.options.DeploymentOptions;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;

public class DeviceOrientationsPanel
extends McTwoColumnPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static final String HELP_ID = "f1_adfmf_deployment_iosorientation_html";
    private JButton _iPhonePortraitOrientation;
    private JButton _iPhonePortraitUpsideDownOrientation;
    private JButton _iPhoneLandscapeLeftOrientation;
    private JButton _iPhoneLandscapeRightOrientation;
    private JButton _iPadPortraitOrientation;
    private JButton _iPadPortraitUpsideDownOrientation;
    private JButton _iPadLandscapeLeftOrientation;
    private JButton _iPadLandscapeRightOrientation;
    private final transient Border _loweredBorder = BorderFactory.createLoweredBevelBorder();
    private final transient Border _raisedBorder = BorderFactory.createRaisedBevelBorder();
    private final ImageIcon _iPhonePortraitImage = new ImageIcon(this.getClass().getClassLoader().getResource("oracle/adfmf/framework/dt/deploy/ios/ui/editor/panels/iPhone-portrait.png"));
    private final ImageIcon _iPhonePortraitUpsideDownImage = new ImageIcon(this.getClass().getClassLoader().getResource("oracle/adfmf/framework/dt/deploy/ios/ui/editor/panels/iPhone-upside-down.png"));
    private final ImageIcon _iPhoneLandscapeLeftImage = new ImageIcon(this.getClass().getClassLoader().getResource("oracle/adfmf/framework/dt/deploy/ios/ui/editor/panels/iPhone-landscape-left.png"));
    private final ImageIcon _iPhoneLandscapeRightImage = new ImageIcon(this.getClass().getClassLoader().getResource("oracle/adfmf/framework/dt/deploy/ios/ui/editor/panels/iPhone-landscape-right.png"));
    private final ImageIcon _iPadPortraitImage = new ImageIcon(this.getClass().getClassLoader().getResource("oracle/adfmf/framework/dt/deploy/ios/ui/editor/panels/iPad-portrait.png"));
    private final ImageIcon _iPadPortraitUpsideDownImage = new ImageIcon(this.getClass().getClassLoader().getResource("oracle/adfmf/framework/dt/deploy/ios/ui/editor/panels/iPad-upside-down.png"));
    private final ImageIcon _iPadLandscapeLeftImage = new ImageIcon(this.getClass().getClassLoader().getResource("oracle/adfmf/framework/dt/deploy/ios/ui/editor/panels/iPad-landscape-left.png"));
    private final ImageIcon _iPadLandscapeRightImage = new ImageIcon(this.getClass().getClassLoader().getResource("oracle/adfmf/framework/dt/deploy/ios/ui/editor/panels/iPad-landscape-right.png"));

    public DeviceOrientationsPanel() {
        this.setHelpID(HELP_ID);
        this.createControls();
    }

    public void onEntry(TraversableContext context) {
        super.onEntry(context);
        DeploymentOptions opts = IosArchiveEditor.getDeploymentOptions((Namespace)context);
        if (!opts.getIphoneOrientationSupportPortrait()) {
            this._iPhonePortraitOrientation.setBorder(this._raisedBorder);
        }
        if (!opts.getIphoneOrientationSupportPortraitUpsideDown()) {
            this._iPhonePortraitUpsideDownOrientation.setBorder(this._raisedBorder);
        }
        if (!opts.getIphoneOrientationSupportLandscapeLeft()) {
            this._iPhoneLandscapeLeftOrientation.setBorder(this._raisedBorder);
        }
        if (!opts.getIphoneOrientationSupportLandscapeRight()) {
            this._iPhoneLandscapeRightOrientation.setBorder(this._raisedBorder);
        }
        if (!opts.getIpadOrientationSupportPortrait()) {
            this._iPadPortraitOrientation.setBorder(this._raisedBorder);
        }
        if (!opts.getIpadOrientationSupportPortraitUpsideDown()) {
            this._iPadPortraitUpsideDownOrientation.setBorder(this._raisedBorder);
        }
        if (!opts.getIpadOrientationSupportLandscapeLeft()) {
            this._iPadLandscapeLeftOrientation.setBorder(this._raisedBorder);
        }
        if (!opts.getIpadOrientationSupportLandscapeRight()) {
            this._iPadLandscapeRightOrientation.setBorder(this._raisedBorder);
        }
    }

    public void onExit(TraversableContext context) throws TraversalException {
        super.onExit(context);
        DeploymentOptions opts = IosArchiveEditor.getDeploymentOptions((Namespace)context);
        assert (this._iPhonePortraitOrientation.getBorder() instanceof BevelBorder);
        BevelBorder bevBorder = (BevelBorder)this._iPhonePortraitOrientation.getBorder();
        opts.setIphoneOrientationSupportPortrait(bevBorder.getBevelType() == 1);
        assert (this._iPhonePortraitUpsideDownOrientation.getBorder() instanceof BevelBorder);
        bevBorder = (BevelBorder)this._iPhonePortraitUpsideDownOrientation.getBorder();
        opts.setIphoneOrientationSupportPortraitUpsideDown(bevBorder.getBevelType() == 1);
        assert (this._iPhoneLandscapeLeftOrientation.getBorder() instanceof BevelBorder);
        bevBorder = (BevelBorder)this._iPhoneLandscapeLeftOrientation.getBorder();
        opts.setIphoneOrientationSupportLandscapeLeft(bevBorder.getBevelType() == 1);
        assert (this._iPhoneLandscapeRightOrientation.getBorder() instanceof BevelBorder);
        bevBorder = (BevelBorder)this._iPhoneLandscapeRightOrientation.getBorder();
        opts.setIphoneOrientationSupportLandscapeRight(bevBorder.getBevelType() == 1);
        assert (this._iPadPortraitOrientation.getBorder() instanceof BevelBorder);
        bevBorder = (BevelBorder)this._iPadPortraitOrientation.getBorder();
        opts.setIpadOrientationSupportPortrait(bevBorder.getBevelType() == 1);
        assert (this._iPadPortraitUpsideDownOrientation.getBorder() instanceof BevelBorder);
        bevBorder = (BevelBorder)this._iPadPortraitUpsideDownOrientation.getBorder();
        opts.setIpadOrientationSupportPortraitUpsideDown(bevBorder.getBevelType() == 1);
        assert (this._iPadLandscapeLeftOrientation.getBorder() instanceof BevelBorder);
        bevBorder = (BevelBorder)this._iPadLandscapeLeftOrientation.getBorder();
        opts.setIpadOrientationSupportLandscapeLeft(bevBorder.getBevelType() == 1);
        assert (this._iPadLandscapeRightOrientation.getBorder() instanceof BevelBorder);
        bevBorder = (BevelBorder)this._iPadLandscapeRightOrientation.getBorder();
        opts.setIpadOrientationSupportLandscapeRight(bevBorder.getBevelType() == 1);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object oSource = event.getSource();
        if (oSource == this._iPhonePortraitOrientation) {
            this.doOrientationButtonAction(this._iPhonePortraitOrientation);
        } else if (oSource == this._iPhonePortraitUpsideDownOrientation) {
            this.doOrientationButtonAction(this._iPhonePortraitUpsideDownOrientation);
        } else if (oSource == this._iPhoneLandscapeLeftOrientation) {
            this.doOrientationButtonAction(this._iPhoneLandscapeLeftOrientation);
        } else if (oSource == this._iPhoneLandscapeRightOrientation) {
            this.doOrientationButtonAction(this._iPhoneLandscapeRightOrientation);
        } else if (oSource == this._iPadPortraitOrientation) {
            this.doOrientationButtonAction(this._iPadPortraitOrientation);
        } else if (oSource == this._iPadPortraitUpsideDownOrientation) {
            this.doOrientationButtonAction(this._iPadPortraitUpsideDownOrientation);
        } else if (oSource == this._iPadLandscapeLeftOrientation) {
            this.doOrientationButtonAction(this._iPadLandscapeLeftOrientation);
        } else if (oSource == this._iPadLandscapeRightOrientation) {
            this.doOrientationButtonAction(this._iPadLandscapeRightOrientation);
        }
    }

    private void doOrientationButtonAction(JButton button) {
        assert (button.getBorder() instanceof BevelBorder);
        BevelBorder bevBorder = (BevelBorder)button.getBorder();
        if (bevBorder.getBevelType() == 1) {
            button.setBorder(this._raisedBorder);
        } else {
            button.setBorder(this._loweredBorder);
        }
        button.repaint();
    }

    private void createControls() {
        boolean gridX = false;
        int gridY = 0;
        ControlGroupPanel parentPanel = new ControlGroupPanel();
        parentPanel.addHintLabel(MobileResourceUtils.getText("DEVICE_ORIENTATION_HINT_LABEL"), 0, gridY++, 3);
        ControlGroupPanel iPhoneOrientationPanel = this.createIPhoneOrientationPanel();
        parentPanel.addPanel(iPhoneOrientationPanel, 0, gridY++);
        ControlGroupPanel iPadOrientationPanel = this.createIPadOrientationPanel();
        parentPanel.addPanel(iPadOrientationPanel, 0, gridY++);
        this.add((Component)((Object)parentPanel), this.gbc(this._lastX, this._lastY++, 1, 1, 0.0, 0.0, 17, 1, this._insets));
        this.addGlue();
    }

    private ControlGroupPanel createIPhoneOrientationPanel() {
        int gridX = 0;
        int gridY = 0;
        ControlGroupPanel iPhoneOrientationPanel = new ControlGroupPanel();
        iPhoneOrientationPanel.setWeightX(1.0);
        iPhoneOrientationPanel.addLabeledSeparator(MobileResourceUtils.getText("DEVICE_ORIENTATIONS_IPHONE"), gridX, gridY++);
        ControlGroupPanel subPanel = new ControlGroupPanel();
        subPanel.setWeightX(1.0);
        ControlGroupPanel subPanel1 = new ControlGroupPanel();
        subPanel1.setWeightX(1.0);
        int subGridX = 0;
        boolean subGridY = false;
        this._iPhonePortraitOrientation = subPanel.addImageIconButtonWithToolTip(this._iPhonePortraitImage, this._loweredBorder, subGridX++, 0, MobileResourceUtils.getText("DEVICE_TOOL_TIP_IPHONE_PORTRAIT"));
        this._iPhonePortraitUpsideDownOrientation = subPanel.addImageIconButtonWithToolTip(this._iPhonePortraitUpsideDownImage, this._loweredBorder, subGridX++, 0, MobileResourceUtils.getText("DEVICE_TOOL_TIP_IPHONE_UPSIDE_DOWN"));
        this._iPhoneLandscapeLeftOrientation = subPanel.addImageIconButtonWithToolTip(this._iPhoneLandscapeLeftImage, this._loweredBorder, subGridX++, 0, MobileResourceUtils.getText("DEVICE_TOOL_TIP_IPHONE_LANDSCAPE_LEFT"));
        this._iPhoneLandscapeRightOrientation = subPanel.addImageIconButtonWithToolTip(this._iPhoneLandscapeRightImage, this._loweredBorder, subGridX++, 0, MobileResourceUtils.getText("DEVICE_TOOL_TIP_IPHONE_LANDSCAPE_RIGHT"));
        this._iPhonePortraitOrientation.addActionListener(this);
        this._iPhonePortraitUpsideDownOrientation.addActionListener(this);
        this._iPhoneLandscapeLeftOrientation.addActionListener(this);
        this._iPhoneLandscapeRightOrientation.addActionListener(this);
        iPhoneOrientationPanel.addPanel(subPanel, gridX++, gridY);
        iPhoneOrientationPanel.addPanel(subPanel1, gridX++, gridY);
        return iPhoneOrientationPanel;
    }

    private ControlGroupPanel createIPadOrientationPanel() {
        int gridX = 0;
        int gridY = 0;
        ControlGroupPanel iPadOrientationPanel = new ControlGroupPanel();
        iPadOrientationPanel.setWeightX(1.0);
        iPadOrientationPanel.addLabeledSeparator(MobileResourceUtils.getText("DEVICE_ORIENTATIONS_IPAD"), gridX, gridY++);
        iPadOrientationPanel.setWeightX(0.0);
        ControlGroupPanel subPanel = new ControlGroupPanel();
        subPanel.setWeightX(1.0);
        ControlGroupPanel subPanel1 = new ControlGroupPanel();
        subPanel1.setWeightX(1.0);
        int subGridX = 0;
        boolean subGridY = false;
        this._iPadPortraitOrientation = subPanel.addImageIconButtonWithToolTip(this._iPadPortraitImage, this._loweredBorder, subGridX++, 0, MobileResourceUtils.getText("DEVICE_TOOL_TIP_IPAD_PORTRAIT"));
        this._iPadPortraitUpsideDownOrientation = subPanel.addImageIconButtonWithToolTip(this._iPadPortraitUpsideDownImage, this._loweredBorder, subGridX++, 0, MobileResourceUtils.getText("DEVICE_TOOL_TIP_IPAD_UPSIDE_DOWN"));
        this._iPadLandscapeLeftOrientation = subPanel.addImageIconButtonWithToolTip(this._iPadLandscapeLeftImage, this._loweredBorder, subGridX++, 0, MobileResourceUtils.getText("DEVICE_TOOL_TIP_IPAD_LANDSCAPE_LEFT"));
        this._iPadLandscapeRightOrientation = subPanel.addImageIconButtonWithToolTip(this._iPadLandscapeRightImage, this._loweredBorder, subGridX++, 0, MobileResourceUtils.getText("DEVICE_TOOL_TIP_IPAD_LANDSCAPE_RIGHT"));
        this._iPadPortraitOrientation.addActionListener(this);
        this._iPadPortraitUpsideDownOrientation.addActionListener(this);
        this._iPadLandscapeLeftOrientation.addActionListener(this);
        this._iPadLandscapeRightOrientation.addActionListener(this);
        iPadOrientationPanel.addPanel(subPanel, gridX++, gridY);
        iPadOrientationPanel.addPanel(subPanel1, gridX++, gridY);
        return iPadOrientationPanel;
    }
}

