/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.dt.deploy.ios.ui.editor.panels;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.adfmf.common.ControlGroupPanel;
import oracle.adfmf.common.DelayedListComboBox;
import oracle.adfmf.common.McTwoColumnPanel;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.adfmf.framework.dt.deploy.common.util.DeployUtil;
import oracle.adfmf.framework.dt.deploy.ios.core.IosDeployUtil;
import oracle.adfmf.framework.dt.deploy.ios.ui.editor.IosArchiveEditor;
import oracle.adfmf.framework.dt.deploy.ios.ui.editor.options.DeploymentOptions;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ide.util.VersionNumber;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.javatools.ui.Borders;
import oracle.javatools.util.ModelUtil;

public class DeploymentOptionsPanel
extends McTwoColumnPanel
implements ActionListener,
DocumentListener {
    private static final String DEPLOYOPTIONS_HELP_TOPIC = "f1_adfmf_deployment_iosoptions_html";
    private static final long serialVersionUID = 1L;
    private JTextField m_appBundleId;
    private JTextField m_appArchiveName;
    private JRadioButton m_debugRadio;
    private JRadioButton m_releaseRadio;
    private transient DelayedListComboBox m_simulatorVersionComboBox;
    private final List<String> m_simulatorVersionList;
    private static final int _POPUP_WAIT_TIME_MS = 1000;
    private static final int _HIGHEST_AVAILABLE_SIMULATOR_INDEX = 0;
    private JComboBox m_earliestTargetVersionComboBox;
    private JComboBox m_targetFamilyVersionComboBox;

    public DeploymentOptionsPanel() {
        ControlGroupPanel parentPanel = new ControlGroupPanel();
        ControlGroupPanel appDetailsPanel = new ControlGroupPanel();
        ControlGroupPanel buildOptionstPanel = new ControlGroupPanel();
        this.createApplicationDetailsPanel(appDetailsPanel);
        this.createBuildOptionsPanel(buildOptionstPanel);
        boolean parentGridX = false;
        int parentGridY = 0;
        parentPanel.addPanel(appDetailsPanel, 0, parentGridY++);
        parentPanel.addPanel(buildOptionstPanel, 0, parentGridY++);
        this.add((Component)((Object)parentPanel), this.gbc(this._lastX, this._lastY++, 1, 1, 0.0, 0.0, 17, 1, this._insets));
        this.addGlue();
        this.setHelpID(DEPLOYOPTIONS_HELP_TOPIC);
        this.m_simulatorVersionList = new ArrayList<String>();
    }

    private void createApplicationDetailsPanel(ControlGroupPanel parentPanel) {
        boolean groupPanelGridX = false;
        int groupPanelGridY = 0;
        parentPanel.addLabeledSeparator(MobileResourceUtils.getText("APPLICATION_DETAILS_SEPARATOR"), 0, groupPanelGridY++);
        ControlGroupPanel appDetailsPanel = new ControlGroupPanel();
        this.m_appBundleId = appDetailsPanel.addLabeledTextField(MobileResourceUtils.getText("APP_BUNDLE_ID_LABEL"), 0, 0, groupPanelGridY++, false, false, false);
        this.m_appBundleId.getDocument().addDocumentListener(this);
        this.m_appArchiveName = appDetailsPanel.addLabeledTextField(MobileResourceUtils.getText("APP_ARCHIVE_NAME_LABEL"), 0, 0, groupPanelGridY, false, false, false);
        FileNameListener nameListener = new FileNameListener();
        this.m_appArchiveName.addKeyListener(nameListener);
        this.m_appArchiveName.getDocument().addDocumentListener(this);
        parentPanel.addPanel(appDetailsPanel, 0, groupPanelGridY++);
    }

    private void createBuildOptionsPanel(ControlGroupPanel parentPanel) {
        boolean panelGridX = false;
        int groupPanelGridY = 0;
        parentPanel.addLabeledSeparator(MobileResourceUtils.getText("BUILD_OPTIONS_LABEL"), 0, groupPanelGridY++);
        ControlGroupPanel deployTargetPanel = new ControlGroupPanel();
        int sdkLocationPanelGridY = 0;
        this.m_earliestTargetVersionComboBox = deployTargetPanel.addLabeledComboBox(MobileResourceUtils.getText("BUILD_OPTIONS_MINIMUM_IOS_VERSION"), this.getEarliestTargetVersionArray(), 0, sdkLocationPanelGridY++, true);
        this.m_earliestTargetVersionComboBox.addActionListener(this);
        this.m_simulatorVersionComboBox = deployTargetPanel.addLabeledDelayedListComboBox(MobileResourceUtils.getText("BUILD_OPTIONS_DEPLOY_TARGET_LABEL"), 0, sdkLocationPanelGridY++, (Component)((Object)this), this.newProgressMonitorProperties(), this.newListCreator(), false);
        this.m_targetFamilyVersionComboBox = deployTargetPanel.addLabeledComboBox(MobileResourceUtils.getText("BUILD_OPTIONS_TARGET_FAMILY"), this.createTargetFamilyArray(), 0, sdkLocationPanelGridY++);
        parentPanel.addPanel(deployTargetPanel, 0, groupPanelGridY++);
        parentPanel.addJWrappedLabel(MobileResourceUtils.getText("BUILD_OPTIONS_MODE_LABEL"), 0, groupPanelGridY++, 1, true);
        int LEFT_INDENT_PIXEL_LEN = 6;
        ControlGroupPanel sdkDebugFlagPanel = new ControlGroupPanel();
        sdkDebugFlagPanel.setLeftIndentPixelSize(6);
        this.m_debugRadio = sdkDebugFlagPanel.addRadioButton(MobileResourceUtils.getText("BUILD_OPTIONS_DEBUG_MODE"), true, 0, groupPanelGridY++);
        this.m_releaseRadio = sdkDebugFlagPanel.addRadioButton(MobileResourceUtils.getText("BUILD_OPTIONS_RELEASE_MODE"), false, 0, groupPanelGridY++);
        parentPanel.addPanel(sdkDebugFlagPanel, 0, groupPanelGridY++);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_debugRadio);
        buttonGroup.add(this.m_releaseRadio);
    }

    private String[] getEarliestTargetVersionArray() {
        if ("5.0".compareTo("5.0") != 0) {
            return new String[]{"5.0", "5.0", "6.0"};
        }
        return new String[]{"5.0", "6.0"};
    }

    private void setListForSimulatorDropdown(String earliestTargetVersion) {
        List<String> simulatorTargetList = this.pruneSimulatorTargetArray(earliestTargetVersion);
        String currSelectedSimulator = (String)this.m_simulatorVersionComboBox.getSelectedItem();
        this.m_simulatorVersionComboBox.setModel(new DefaultComboBoxModel<String>(simulatorTargetList.toArray(new String[0])));
        if (simulatorTargetList.contains(currSelectedSimulator)) {
            this.m_simulatorVersionComboBox.setSelectedItem(currSelectedSimulator);
        }
    }

    private List<String> pruneSimulatorTargetArray(String earliestTargetVersion) {
        VersionNumber targetVersionNumber = new VersionNumber(earliestTargetVersion);
        ArrayList<String> finalSimulatorTargetList = new ArrayList<String>();
        String localizedHighestDefaultSimulator = MobileResourceUtils.getText("BUILD_OPTIONS_DEFAULT_SIMULATOR_TARGET_VERSION");
        finalSimulatorTargetList.add(0, localizedHighestDefaultSimulator);
        if (!this.m_simulatorVersionList.isEmpty()) {
            for (String currSimulatorVersion : this.m_simulatorVersionList) {
                VersionNumber currSimulatorVersionNumber;
                if (currSimulatorVersion.equals(localizedHighestDefaultSimulator) || !(currSimulatorVersionNumber = new VersionNumber(currSimulatorVersion)).isAfter(targetVersionNumber, true)) continue;
                finalSimulatorTargetList.add(currSimulatorVersion);
            }
        }
        return finalSimulatorTargetList;
    }

    private String[] createTargetFamilyArray() {
        return new String[]{MobileResourceUtils.getText("BUILD_OPTIONS_DEPLOY_TARGET_DEFAULT"), MobileResourceUtils.getText("BUILD_OPTIONS_DEPLOY_TARGET_IPAD"), MobileResourceUtils.getText("BUILD_OPTIONS_DEPLOY_TARGET_IPHONE")};
    }

    public void onEntry(TraversableContext tc) {
        super.onEntry(tc);
        DeploymentOptions opts = IosArchiveEditor.getDeploymentOptions((Namespace)tc);
        String deployTargetFamily = opts.getTargetFamily();
        String deployTargetFamilyValue = MobileResourceUtils.getText("BUILD_OPTIONS_DEPLOY_TARGET_DEFAULT");
        if (deployTargetFamily.compareTo("iPad") == 0) {
            deployTargetFamilyValue = MobileResourceUtils.getText("BUILD_OPTIONS_DEPLOY_TARGET_IPAD");
        } else if (deployTargetFamily.compareTo("iPhone") == 0) {
            deployTargetFamilyValue = MobileResourceUtils.getText("BUILD_OPTIONS_DEPLOY_TARGET_IPHONE");
        }
        String deployTargetVersion = opts.getDeployTargetVersion();
        this.setListForSimulatorDropdown(deployTargetVersion);
        this.m_appBundleId.setText(opts.getAppBundleId());
        this.m_appArchiveName.setText(opts.getApplicationArchiveName());
        this.m_earliestTargetVersionComboBox.setSelectedItem(deployTargetVersion);
        this.initializeSimulatorVersionCombobox(opts);
        this.m_targetFamilyVersionComboBox.setSelectedItem(deployTargetFamilyValue);
        boolean bIsDebug = opts.getDebugFlag();
        this.m_debugRadio.setSelected(bIsDebug);
        this.m_releaseRadio.setSelected(!bIsDebug);
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        super.onExit(tc);
        DeploymentOptions opts = IosArchiveEditor.getDeploymentOptions((Namespace)tc);
        if (opts != null) {
            String sAppBundleId = this.m_appBundleId.getText();
            String deployTargetFamilyValue = (String)this.m_targetFamilyVersionComboBox.getSelectedItem();
            String deployTargetFamily = "iPhone/iPad";
            if (deployTargetFamilyValue.compareTo(MobileResourceUtils.getText("BUILD_OPTIONS_DEPLOY_TARGET_IPAD")) == 0) {
                deployTargetFamily = "iPad";
            } else if (deployTargetFamilyValue.compareTo(MobileResourceUtils.getText("BUILD_OPTIONS_DEPLOY_TARGET_IPHONE")) == 0) {
                deployTargetFamily = "iPhone";
            }
            this.validateApplicationBundleId(sAppBundleId);
            opts.setAppBundleId(sAppBundleId);
            this.validateArchiveName();
            String sAppArchiveName = this.m_appArchiveName.getText();
            opts.setApplicationArchiveName(sAppArchiveName);
            opts.setDeployTargetVersion((String)this.m_earliestTargetVersionComboBox.getSelectedItem());
            String selectedSimulatorVersion = (String)this.m_simulatorVersionComboBox.getSelectedItem();
            String simulatorTargetOptionValue = null;
            simulatorTargetOptionValue = !ModelUtil.hasLength((String)selectedSimulatorVersion) || selectedSimulatorVersion.equals(MobileResourceUtils.getText("BUILD_OPTIONS_DEFAULT_SIMULATOR_TARGET_VERSION")) ? opts.getSimulatorDefaultTargetVersionValue() : selectedSimulatorVersion;
            opts.setSimulatorTargetVersion(simulatorTargetOptionValue);
            opts.setTargetFamily(deployTargetFamily);
            opts.setDebugFlag(this.m_debugRadio.isSelected());
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object oSource = event.getSource();
        if (oSource == this.m_earliestTargetVersionComboBox) {
            String newDeploytargetVersion = (String)this.m_earliestTargetVersionComboBox.getSelectedItem();
            this.setListForSimulatorDropdown(newDeploytargetVersion);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.validateBundleId();
        this.validateAppName();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.validateBundleId();
        this.validateAppName();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.validateBundleId();
        this.validateAppName();
    }

    private void validateBundleId() {
        if (DeployUtil.isValidApplicationArchiveName(this.m_appBundleId.getText())) {
            Borders.restoreBorder((JComponent)this.m_appBundleId);
        } else {
            Borders.attachErrorBorder((JComponent)this.m_appBundleId);
        }
    }

    private void validateAppName() {
        if (DeployUtil.isValidApplicationArchiveName(this.m_appArchiveName.getText())) {
            Borders.restoreBorder((JComponent)this.m_appArchiveName);
        } else {
            Borders.attachErrorBorder((JComponent)this.m_appArchiveName);
        }
    }

    private void validateApplicationBundleId(String sAppName) throws TraversalException {
        if (!DeployUtil.isValidApplicationArchiveName(sAppName)) {
            this.m_appBundleId.requestFocusInWindow();
            throw new TraversalException(MobileResourceUtils.getMsg("ADF-MBL-01002"));
        }
        if (sAppName.compareToIgnoreCase("CON") == 0 || sAppName.compareToIgnoreCase("AUX") == 0 || sAppName.compareToIgnoreCase("PRN") == 0 || sAppName.compareToIgnoreCase("COM1") == 0 || sAppName.compareToIgnoreCase("LPT2") == 0) {
            this.m_appBundleId.requestFocusInWindow();
            throw new TraversalException(MobileResourceUtils.getMsg("ADF-MBL-00006"));
        }
    }

    private void validateArchiveName() throws TraversalException {
        String archiveName = this.m_appArchiveName.getText();
        if (!DeployUtil.isValidApplicationArchiveName(archiveName)) {
            this.m_appArchiveName.requestFocusInWindow();
            String msg = MobileResourceUtils.getMsg("ADF-MBL-02014");
            throw new TraversalException(msg);
        }
    }

    private DelayedListComboBox.ListCreator newListCreator() {
        return new DelayedListComboBox.ListCreator(){

            @Override
            public List<String> createItemList(IndeterminateProgressMonitor progressMonitor) {
                ArrayList<String> createItemList = new ArrayList<String>();
                createItemList.add(0, MobileResourceUtils.getText("BUILD_OPTIONS_DEFAULT_SIMULATOR_TARGET_VERSION"));
                createItemList.addAll(IosDeployUtil.invokeXcodebuildShowSdks(progressMonitor));
                return createItemList;
            }

            @Override
            public void setItemList(List<String> itemList) {
                DeploymentOptionsPanel.this.m_simulatorVersionList.clear();
                DeploymentOptionsPanel.this.m_simulatorVersionList.addAll(itemList);
                String currentDeployTargetVersion = (String)DeploymentOptionsPanel.this.m_earliestTargetVersionComboBox.getSelectedItem();
                DeploymentOptionsPanel.this.setListForSimulatorDropdown(currentDeployTargetVersion);
            }
        };
    }

    private DelayedListComboBox.ProgressMonitorProperties newProgressMonitorProperties() {
        DelayedListComboBox.ProgressMonitorProperties monitorDialogProperties = new DelayedListComboBox.ProgressMonitorProperties((Component)((Object)this), MobileResourceUtils.getText("IOS_SIMULATOR_PROGRESS_DIALOG_TITLE"), MobileResourceUtils.getText("IOS_SIMULATOR_PROGRESS_DIALOG_MESSAGE"), "", MobileResourceUtils.getText("IOS_SIMULATOR_PROGRESS_DIALOG_CANCEL_MESSAGE"));
        monitorDialogProperties.setMillisToPopup(1000);
        return monitorDialogProperties;
    }

    private void initializeSimulatorVersionCombobox(DeploymentOptions deploymentOptions) {
        String defaultValue = MobileResourceUtils.getText("BUILD_OPTIONS_DEFAULT_SIMULATOR_TARGET_VERSION");
        String configuredSimulatorVersion = deploymentOptions.getSimulatorTargetVersion();
        String initialSimulatorSelection = null;
        initialSimulatorSelection = !configuredSimulatorVersion.equals(deploymentOptions.getSimulatorDefaultTargetVersionValue()) ? configuredSimulatorVersion : defaultValue;
        if (this.m_simulatorVersionList.isEmpty()) {
            this.m_simulatorVersionComboBox.removeAllItems();
            this.m_simulatorVersionComboBox.insertItemAt(defaultValue, 0);
            if (!initialSimulatorSelection.equals(defaultValue)) {
                this.m_simulatorVersionComboBox.addItem(initialSimulatorSelection);
            }
        }
        this.m_simulatorVersionComboBox.setSelectedItem(initialSimulatorSelection);
    }

    private static class FileNameListener
    implements KeyListener {
        private FileNameListener() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            char typed = e.getKeyChar();
            if (File.separatorChar == typed || '*' == typed || ':' == typed || '|' == typed) {
                e.consume();
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    }
}

